/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_backendcapabilities_wrapper.h"
#include "phonon_backendcapabilities_notifierwrapper_wrapper.h"

// Extra includes
#include <QList>
#include <objectdescription.h>
#include "pyside_phonon.h"
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Begin code injection

Phonon::BackendCapabilities::NotifierWrapper* Phonon::BackendCapabilities::NotifierWrapper::m_instance = 0;
Phonon::BackendCapabilities::Notifier* Phonon::BackendCapabilities::NotifierWrapper::m_notifier = 0;

// End of code injection

static PyObject* SbkPhonon_BackendCapabilitiesFunc_availableAudioCaptureDevices(PyObject* self)
{
    PyObject* py_result = 0;

    // availableAudioCaptureDevices()
    QList<Phonon::AudioCaptureDevice > cpp_result = Phonon::BackendCapabilities::availableAudioCaptureDevices();
    py_result = Shiboken::Converter<QList<Phonon::AudioCaptureDevice > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_BackendCapabilitiesFunc_availableAudioEffects(PyObject* self)
{
    PyObject* py_result = 0;

    // availableAudioEffects()
    QList<Phonon::EffectDescription > cpp_result = Phonon::BackendCapabilities::availableAudioEffects();
    py_result = Shiboken::Converter<QList<Phonon::EffectDescription > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_BackendCapabilitiesFunc_availableAudioOutputDevices(PyObject* self)
{
    PyObject* py_result = 0;

    // availableAudioOutputDevices()
    QList<Phonon::AudioOutputDevice > cpp_result = Phonon::BackendCapabilities::availableAudioOutputDevices();
    py_result = Shiboken::Converter<QList<Phonon::AudioOutputDevice > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_BackendCapabilitiesFunc_availableMimeTypes(PyObject* self)
{
    PyObject* py_result = 0;

    // availableMimeTypes()
    QStringList cpp_result = Phonon::BackendCapabilities::availableMimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_BackendCapabilitiesFunc_isMimeTypeAvailable(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isMimeTypeAvailable(QString)
        bool cpp_result = Phonon::BackendCapabilities::isMimeTypeAvailable(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendCapabilitiesFunc_isMimeTypeAvailable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendCapabilitiesFunc_isMimeTypeAvailable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.BackendCapabilities.isMimeTypeAvailable", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendCapabilitiesFunc_notifier(PyObject* self)
{
    PyObject* py_result = 0;

    // notifier()
    // Begin code injection
    
    Phonon::BackendCapabilities::NotifierWrapper *_notifierWrapper =  Phonon::BackendCapabilities::NotifierWrapper::notifier();
    py_result = Shiboken::Converter<Phonon::BackendCapabilities::NotifierWrapper* >::toPython(_notifierWrapper);
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_BackendCapabilities_methods[] = {
    {"availableAudioCaptureDevices", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_availableAudioCaptureDevices, METH_NOARGS|METH_STATIC},
    {"availableAudioEffects", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_availableAudioEffects, METH_NOARGS|METH_STATIC},
    {"availableAudioOutputDevices", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_availableAudioOutputDevices, METH_NOARGS|METH_STATIC},
    {"availableMimeTypes", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_availableMimeTypes, METH_NOARGS|METH_STATIC},
    {"isMimeTypeAvailable", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_isMimeTypeAvailable, METH_O|METH_STATIC},
    {"notifier", (PyCFunction)SbkPhonon_BackendCapabilitiesFunc_notifier, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_BackendCapabilities_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.BackendCapabilities",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_BackendCapabilities_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_Phonon_BackendCapabilities(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_BACKENDCAPABILITIES_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_BackendCapabilities_Type);


    if (PyType_Ready((PyTypeObject*)&SbkPhonon_BackendCapabilities_Type) < 0)
        return;

    PyDict_SetItemString(module,"BackendCapabilities", (PyObject*)&SbkPhonon_BackendCapabilities_Type);

}


} // extern "C"


