/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtwebkit_python.h"

#include "qwebpluginfactory_wrapper.h"
#include "qwebpluginfactory_mimetype_wrapper.h"
#include "qwebpluginfactory_plugin_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebpluginfactory.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QWebPluginFactoryWrapper::QWebPluginFactoryWrapper(QObject * parent) : QWebPluginFactory(parent), m_metaObject(0) {
    // ... middle
}

void QWebPluginFactoryWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWebPluginFactoryWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QObject * QWebPluginFactoryWrapper::create(const QString & mimeType, const QUrl & arg__2, const QStringList & argumentNames, const QStringList & argumentValues) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "create"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QWebPluginFactory.create()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QString & >::toPython(mimeType),
        Shiboken::Converter<QUrl & >::toPython(arg__2),
        Shiboken::Converter<QStringList & >::toPython(argumentNames),
        Shiboken::Converter<QStringList & >::toPython(argumentValues)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QObject * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPluginFactory.create", SbkType<QObject * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QObject * cpp_result(Shiboken::Converter<QObject * >::toCpp(py_result));
    return cpp_result;
}

void QWebPluginFactoryWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QWebPluginFactoryWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWebPluginFactoryWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPluginFactory.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QWebPluginFactoryWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPluginFactory.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QList<QWebPluginFactory::Plugin > QWebPluginFactoryWrapper::plugins() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "plugins"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QWebPluginFactory.plugins()' not implemented.");
        return QList<QWebPluginFactory::Plugin >();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QWebPluginFactory::Plugin >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QWebPluginFactory::Plugin > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPluginFactory.plugins", "list", py_result->ob_type->tp_name);
        return QList<QWebPluginFactory::Plugin >();
    }
    QList<QWebPluginFactory::Plugin > cpp_result(Shiboken::Converter<QList<QWebPluginFactory::Plugin > >::toCpp(py_result));
    return cpp_result;
}

void QWebPluginFactoryWrapper::refreshPlugins()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "refreshPlugins"));
    if (py_override.isNull()) {
        return this->QWebPluginFactory::refreshPlugins();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QWebPluginFactoryWrapper::supportsExtension(QWebPluginFactory::Extension extension) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportsExtension"));
    if (py_override.isNull()) {
        return this->QWebPluginFactory::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWebPluginFactory::Extension >::toPython(extension)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QWebPluginFactory.supportsExtension", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QWebPluginFactoryWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QWebPluginFactoryWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QWebPluginFactory::staticMetaObject);
}
    return m_metaObject;
}

int QWebPluginFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QWebPluginFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QWebPluginFactoryWrapper::~QWebPluginFactoryWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQWebPluginFactory_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebPluginFactoryWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QWebPluginFactory' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebPluginFactory", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QWebPluginFactory(QObject*)
        cptr = new QWebPluginFactoryWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QWebPluginFactory(QObject*)
        cptr = new QWebPluginFactoryWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQWebPluginFactory_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebPluginFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebPluginFactory_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebPluginFactory_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPluginFactory", overloads);
        return -1;
}

static PyObject* SbkQWebPluginFactoryFunc_create(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "create", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QUrl & >::isConvertible(pyargs[1]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[2]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
        QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
        if (!SbkQUrl_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg2_auto_ptr;
        QStringList* cpp_arg2 = Shiboken::Converter<QStringList* >::toCpp(pyargs[2]);
        if (!SbkQStringList_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QStringList >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg3_auto_ptr;
        QStringList* cpp_arg3 = Shiboken::Converter<QStringList* >::toCpp(pyargs[3]);
        if (!SbkQStringList_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QStringList >(cpp_arg3);
        // create(QString,QUrl,QStringList,QStringList)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QWebPluginFactory.create()' not implemented.");
            return 0;
        }
        QWebPluginFactory* cppSelf = Shiboken::Converter<QWebPluginFactory* >::toCpp((PyObject*)self);
        QObject * cpp_result = cppSelf->create(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQWebPluginFactoryFunc_create_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPluginFactoryFunc_create_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QUrl, PySide.QtCore.QStringList, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebPluginFactory.create", overloads);
        return 0;
}

static PyObject* SbkQWebPluginFactoryFunc_plugins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // plugins()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QWebPluginFactory.plugins()' not implemented.");
        return 0;
    }
    QWebPluginFactory* cppSelf = Shiboken::Converter<QWebPluginFactory* >::toCpp((PyObject*)self);
    QList<QWebPluginFactory::Plugin > cpp_result = cppSelf->plugins();
    py_result = Shiboken::Converter<QList<QWebPluginFactory::Plugin > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebPluginFactoryFunc_refreshPlugins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // refreshPlugins()
    QWebPluginFactory* cppSelf = Shiboken::Converter<QWebPluginFactory* >::toCpp((PyObject*)self);
    cppSelf->QWebPluginFactory::refreshPlugins();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQWebPluginFactoryFunc_supportsExtension(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWebPluginFactory::Extension >::isConvertible(arg)) {
        QWebPluginFactory::Extension cpp_arg0 = Shiboken::Converter<QWebPluginFactory::Extension >::toCpp(arg);
        // supportsExtension(QWebPluginFactory::Extension)const
        QWebPluginFactory* cppSelf = Shiboken::Converter<QWebPluginFactory* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QWebPluginFactory::supportsExtension(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPluginFactoryFunc_supportsExtension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebPluginFactoryFunc_supportsExtension_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebPluginFactory.Extension", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebPluginFactory.supportsExtension", overloads);
        return 0;
}

static PyMethodDef SbkQWebPluginFactory_methods[] = {
    {"create", (PyCFunction)SbkQWebPluginFactoryFunc_create, METH_VARARGS},
    {"plugins", (PyCFunction)SbkQWebPluginFactoryFunc_plugins, METH_NOARGS},
    {"refreshPlugins", (PyCFunction)SbkQWebPluginFactoryFunc_refreshPlugins, METH_NOARGS},
    {"supportsExtension", (PyCFunction)SbkQWebPluginFactoryFunc_supportsExtension, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebPluginFactory_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebPluginFactory",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebPluginFactory_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebPluginFactory_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebPluginFactory >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtWebKit_QWebPluginFactory_Extension_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtWebKit_QWebPluginFactory_Extension_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtWebKit_QWebPluginFactory_Extension_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Extension",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtWebKit_QWebPluginFactory_Extension_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtWebKit_QWebPluginFactory_Extension_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtWebKit_QWebPluginFactory_Extension_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QWebPluginFactory(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebPluginFactory_Type);

    SbkQWebPluginFactory_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQWebPluginFactory_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQWebPluginFactory_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebPluginFactory_Type));
    PyModule_AddObject(module, "QWebPluginFactory",
        ((PyObject*)&SbkQWebPluginFactory_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Extension
    SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_EXTENSION_IDX] = &SbkPySide_QtWebKit_QWebPluginFactory_Extension_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtWebKit_QWebPluginFactory_Extension_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtWebKit_QWebPluginFactory_Extension_Type);
    PyDict_SetItemString(SbkQWebPluginFactory_Type.super.ht_type.tp_dict,
            "Extension",((PyObject*)&SbkPySide_QtWebKit_QWebPluginFactory_Extension_Type));

    Shiboken::TypeResolver::createValueTypeResolver<int>("QWebPluginFactory::Extension");

    Shiboken::TypeResolver::createObjectTypeResolver<QWebPluginFactory >("QWebPluginFactory*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWebPluginFactory >(typeid(QWebPluginFactory).name());
}


} // extern "C"

