/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qftp_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qftp.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qurlinfo.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFtpWrapper::QFtpWrapper(QObject * parent) : QFtp(parent), m_metaObject(0) {
    // ... middle
}

void QFtpWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFtpWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFtpWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFtpWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFtpWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFtp.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QFtpWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QFtp.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QFtpWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QFtpWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFtp::staticMetaObject);
}
    return m_metaObject;
}

int QFtpWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFtp::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFtpWrapper::~QFtpWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFtp_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFtpWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QFtp", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QFtp(QObject*)
        cptr = new QFtpWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QFtp(QObject*)
        cptr = new QFtpWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQFtp_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFtp >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFtp_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFtp_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp", overloads);
        return -1;
}

static PyObject* SbkQFtpFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // abort()
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    cppSelf->QFtp::abort();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFtpFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFtp::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_cd(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // cd(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::cd(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_cd_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_cd_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.cd", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_clearPendingCommands(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearPendingCommands()
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    cppSelf->QFtp::clearPendingCommands();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFtpFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    int cpp_result = cppSelf->QFtp::close();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_connectToHost(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "connectToHost", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // connectToHost(QString,quint16)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::connectToHost(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
            // connectToHost(QString,quint16)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::connectToHost(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFtpFunc_connectToHost_TypeError;
    } else goto SbkQFtpFunc_connectToHost_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_connectToHost_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, unsigned short = 21", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.connectToHost", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_currentCommand(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentCommand()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    QFtp::Command cpp_result = cppSelf->QFtp::currentCommand();
    py_result = Shiboken::Converter<QFtp::Command >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_currentDevice(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentDevice()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QFtp::currentDevice();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_currentId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentId()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFtp::currentId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    QFtp::Error cpp_result = cppSelf->QFtp::error();
    py_result = Shiboken::Converter<QFtp::Error >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFtp::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_get(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "get", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // get(QString,QIODevice*,QFtp::TransferType)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::get(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // get(QString,QIODevice*,QFtp::TransferType)
                QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
                thread_state_saver.save();
                int cpp_result = cppSelf->QFtp::get(*cpp_arg0, cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QFtp::TransferType >::isConvertible(pyargs[2])) {
                QFtp::TransferType cpp_arg2 = Shiboken::Converter<QFtp::TransferType >::toCpp(pyargs[2]);
                // get(QString,QIODevice*,QFtp::TransferType)
                QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
                thread_state_saver.save();
                int cpp_result = cppSelf->QFtp::get(*cpp_arg0, cpp_arg1, cpp_arg2);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQFtpFunc_get_TypeError;
        } else goto SbkQFtpFunc_get_TypeError;
    } else goto SbkQFtpFunc_get_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_get_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice = None, PySide.QtNetwork.QFtp.TransferType = Binary", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.get", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_hasPendingCommands(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPendingCommands()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFtp::hasPendingCommands();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_list(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // list(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::list();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // list(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::list(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_list_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_list_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.list", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_login(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "login", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // login(QString,QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::login();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // login(QString,QString)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::login(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // login(QString,QString)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::login(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFtpFunc_login_TypeError;
    } else goto SbkQFtpFunc_login_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_login_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.login", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_mkdir(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // mkdir(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::mkdir(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_mkdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_mkdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.mkdir", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_put(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "put", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // put(QByteArray,QString,QFtp::TransferType)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::put(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFtp::TransferType >::isConvertible(pyargs[2])) {
            QFtp::TransferType cpp_arg2 = Shiboken::Converter<QFtp::TransferType >::toCpp(pyargs[2]);
            // put(QByteArray,QString,QFtp::TransferType)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::put(*cpp_arg0, *cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFtpFunc_put_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // put(QIODevice*,QString,QFtp::TransferType)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::put(cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFtp::TransferType >::isConvertible(pyargs[2])) {
            QFtp::TransferType cpp_arg2 = Shiboken::Converter<QFtp::TransferType >::toCpp(pyargs[2]);
            // put(QIODevice*,QString,QFtp::TransferType)
            QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            int cpp_result = cppSelf->QFtp::put(cpp_arg0, *cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFtpFunc_put_TypeError;
    } else goto SbkQFtpFunc_put_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_put_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QString, PySide.QtNetwork.QFtp.TransferType = Binary", "PySide.QtCore.QByteArray, PySide.QtCore.QString, PySide.QtNetwork.QFtp.TransferType = Binary", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.put", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_rawCommand(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // rawCommand(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::rawCommand(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_rawCommand_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_rawCommand_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.rawCommand", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // read(char*,qint64)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - read_wrapper - START
        char _data[cpp_arg0];
        qint64 _size = cppSelf->read(_data, cpp_arg0);
        if (_size > 0)
        py_result = Shiboken::Converter<QByteArray >::toPython(QByteArray(_data, _size));
        else
        py_result = Shiboken::Converter<QByteArray >::toPython(QByteArray());
        // TEMPLATE - read_wrapper - END
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_read_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.read", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_readAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAll()
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QByteArray cpp_result = cppSelf->QFtp::readAll();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFtpFunc_remove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // remove(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::remove(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_remove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_remove_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.remove", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_rename(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rename", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // rename(QString,QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::rename(*cpp_arg0, *cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_rename_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_rename_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.rename", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_rmdir(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // rmdir(QString)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QFtp::rmdir(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_rmdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_rmdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.rmdir", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_setProxy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProxy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
        // setProxy(QString,quint16)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFtp::setProxy(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_setProxy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_setProxy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, unsigned short", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QFtp.setProxy", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_setTransferMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFtp::TransferMode >::isConvertible(arg)) {
        QFtp::TransferMode cpp_arg0 = Shiboken::Converter<QFtp::TransferMode >::toCpp(arg);
        // setTransferMode(QFtp::TransferMode)
        QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QFtp::setTransferMode(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFtpFunc_setTransferMode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFtpFunc_setTransferMode_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QFtp.TransferMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QFtp.setTransferMode", overloads);
        return 0;
}

static PyObject* SbkQFtpFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QFtp* cppSelf = Shiboken::Converter<QFtp* >::toCpp((PyObject*)self);
    QFtp::State cpp_result = cppSelf->QFtp::state();
    py_result = Shiboken::Converter<QFtp::State >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFtp_methods[] = {
    {"abort", (PyCFunction)SbkQFtpFunc_abort, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQFtpFunc_bytesAvailable, METH_NOARGS},
    {"cd", (PyCFunction)SbkQFtpFunc_cd, METH_O},
    {"clearPendingCommands", (PyCFunction)SbkQFtpFunc_clearPendingCommands, METH_NOARGS},
    {"close", (PyCFunction)SbkQFtpFunc_close, METH_NOARGS},
    {"connectToHost", (PyCFunction)SbkQFtpFunc_connectToHost, METH_VARARGS},
    {"currentCommand", (PyCFunction)SbkQFtpFunc_currentCommand, METH_NOARGS},
    {"currentDevice", (PyCFunction)SbkQFtpFunc_currentDevice, METH_NOARGS},
    {"currentId", (PyCFunction)SbkQFtpFunc_currentId, METH_NOARGS},
    {"error", (PyCFunction)SbkQFtpFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQFtpFunc_errorString, METH_NOARGS},
    {"get", (PyCFunction)SbkQFtpFunc_get, METH_VARARGS},
    {"hasPendingCommands", (PyCFunction)SbkQFtpFunc_hasPendingCommands, METH_NOARGS},
    {"list", (PyCFunction)SbkQFtpFunc_list, METH_NOARGS|METH_O},
    {"login", (PyCFunction)SbkQFtpFunc_login, METH_VARARGS},
    {"mkdir", (PyCFunction)SbkQFtpFunc_mkdir, METH_O},
    {"put", (PyCFunction)SbkQFtpFunc_put, METH_VARARGS},
    {"rawCommand", (PyCFunction)SbkQFtpFunc_rawCommand, METH_O},
    {"read", (PyCFunction)SbkQFtpFunc_read, METH_O},
    {"readAll", (PyCFunction)SbkQFtpFunc_readAll, METH_NOARGS},
    {"remove", (PyCFunction)SbkQFtpFunc_remove, METH_O},
    {"rename", (PyCFunction)SbkQFtpFunc_rename, METH_VARARGS},
    {"rmdir", (PyCFunction)SbkQFtpFunc_rmdir, METH_O},
    {"setProxy", (PyCFunction)SbkQFtpFunc_setProxy, METH_VARARGS},
    {"setTransferMode", (PyCFunction)SbkQFtpFunc_setTransferMode, METH_O},
    {"state", (PyCFunction)SbkQFtpFunc_state, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFtp_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QFtp",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFtp_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFtp_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFtp >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtNetwork_QFtp_TransferType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QFtp_TransferType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QFtp_TransferType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TransferType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QFtp_TransferType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QFtp_TransferType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QFtp_TransferType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QFtp_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QFtp_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QFtp_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QFtp_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QFtp_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QFtp_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QFtp_Command_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QFtp_Command_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QFtp_Command_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Command",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QFtp_Command_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QFtp_Command_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QFtp_Command_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QFtp_TransferMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QFtp_TransferMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QFtp_TransferMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TransferMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QFtp_TransferMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QFtp_TransferMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QFtp_TransferMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtNetwork_QFtp_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QFtp_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QFtp_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QFtp_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QFtp_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QFtp_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QFtp(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QFTP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFtp_Type);

    SbkQFtp_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQFtp_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFtp_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFtp_Type));
    PyModule_AddObject(module, "QFtp",
        ((PyObject*)&SbkQFtp_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: TransferType
    SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERTYPE_IDX] = &SbkPySide_QtNetwork_QFtp_TransferType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QFtp_TransferType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QFtp_TransferType_Type);
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
            "TransferType",((PyObject*)&SbkPySide_QtNetwork_QFtp_TransferType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_TransferType_Type,
        (long) QFtp::Binary, "Binary");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Binary", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_TransferType_Type.tp_dict,
        "Binary", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_TransferType_Type,
        (long) QFtp::Ascii, "Ascii");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Ascii", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_TransferType_Type.tp_dict,
        "Ascii", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFtp::TransferType");

    // init enum class: Error
    SbkPySide_QtNetworkTypes[SBK_QFTP_ERROR_IDX] = &SbkPySide_QtNetwork_QFtp_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QFtp_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QFtp_Error_Type);
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtNetwork_QFtp_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Error_Type,
        (long) QFtp::NoError, "NoError");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Error_Type,
        (long) QFtp::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Error_Type.tp_dict,
        "UnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Error_Type,
        (long) QFtp::HostNotFound, "HostNotFound");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "HostNotFound", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Error_Type.tp_dict,
        "HostNotFound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Error_Type,
        (long) QFtp::ConnectionRefused, "ConnectionRefused");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "ConnectionRefused", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Error_Type.tp_dict,
        "ConnectionRefused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Error_Type,
        (long) QFtp::NotConnected, "NotConnected");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "NotConnected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Error_Type.tp_dict,
        "NotConnected", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFtp::Error");

    // init enum class: Command
    SbkPySide_QtNetworkTypes[SBK_QFTP_COMMAND_IDX] = &SbkPySide_QtNetwork_QFtp_Command_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QFtp_Command_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QFtp_Command_Type);
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
            "Command",((PyObject*)&SbkPySide_QtNetwork_QFtp_Command_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::None, "None");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "None", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "None", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::SetTransferMode, "SetTransferMode");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "SetTransferMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "SetTransferMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::SetProxy, "SetProxy");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "SetProxy", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "SetProxy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::ConnectToHost, "ConnectToHost");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "ConnectToHost", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "ConnectToHost", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Login, "Login");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Login", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Login", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Close, "Close");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::List, "List");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "List", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "List", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Cd, "Cd");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Cd", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Cd", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Get, "Get");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Get", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Get", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Put, "Put");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Put", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Put", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Remove, "Remove");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Remove", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Remove", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Mkdir, "Mkdir");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Mkdir", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Mkdir", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Rmdir, "Rmdir");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Rmdir", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Rmdir", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::Rename, "Rename");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Rename", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "Rename", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_Command_Type,
        (long) QFtp::RawCommand, "RawCommand");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "RawCommand", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_Command_Type.tp_dict,
        "RawCommand", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFtp::Command");

    // init enum class: TransferMode
    SbkPySide_QtNetworkTypes[SBK_QFTP_TRANSFERMODE_IDX] = &SbkPySide_QtNetwork_QFtp_TransferMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QFtp_TransferMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QFtp_TransferMode_Type);
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
            "TransferMode",((PyObject*)&SbkPySide_QtNetwork_QFtp_TransferMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_TransferMode_Type,
        (long) QFtp::Active, "Active");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Active", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_TransferMode_Type.tp_dict,
        "Active", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_TransferMode_Type,
        (long) QFtp::Passive, "Passive");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Passive", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_TransferMode_Type.tp_dict,
        "Passive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFtp::TransferMode");

    // init enum class: State
    SbkPySide_QtNetworkTypes[SBK_QFTP_STATE_IDX] = &SbkPySide_QtNetwork_QFtp_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QFtp_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QFtp_State_Type);
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtNetwork_QFtp_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::Unconnected, "Unconnected");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Unconnected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "Unconnected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::HostLookup, "HostLookup");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "HostLookup", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "HostLookup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::Connecting, "Connecting");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Connecting", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "Connecting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::Connected, "Connected");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Connected", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "Connected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::LoggedIn, "LoggedIn");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "LoggedIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "LoggedIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QFtp_State_Type,
        (long) QFtp::Closing, "Closing");
    PyDict_SetItemString(SbkQFtp_Type.super.ht_type.tp_dict,
        "Closing", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QFtp_State_Type.tp_dict,
        "Closing", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFtp::State");

    Shiboken::TypeResolver::createObjectTypeResolver<QFtp >("QFtp*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFtp >(typeid(QFtp).name());
}


} // extern "C"

