/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qwindowstatechangeevent_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QWindowStateChangeEventWrapper::QWindowStateChangeEventWrapper(QFlags<Qt::WindowState> aOldState) : QWindowStateChangeEvent(aOldState) {
    // ... middle
}

QWindowStateChangeEventWrapper::QWindowStateChangeEventWrapper(QFlags<Qt::WindowState> aOldState, bool isOverride) : QWindowStateChangeEvent(aOldState, isOverride) {
    // ... middle
}

QWindowStateChangeEventWrapper::~QWindowStateChangeEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQWindowStateChangeEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWindowStateChangeEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QWindowStateChangeEvent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (SbkPySide_QtCore_Qt_WindowState_Check(pyargs[0])) {
        QFlags<Qt::WindowState> cpp_arg0 = Shiboken::Converter<QFlags<Qt::WindowState> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QWindowStateChangeEvent(QFlags<Qt::WindowState>)
            cptr = new QWindowStateChangeEventWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // QWindowStateChangeEvent(QFlags<Qt::WindowState>,bool)
            cptr = new QWindowStateChangeEventWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQWindowStateChangeEvent_Init_TypeError;
    } else goto SbkQWindowStateChangeEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWindowStateChangeEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWindowStateChangeEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWindowStateChangeEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.WindowStates", "PySide.QtCore.Qt.WindowStates, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWindowStateChangeEvent", overloads);
        return -1;
}

static PyObject* SbkQWindowStateChangeEventFunc_isOverride(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOverride()const
    QWindowStateChangeEvent* cppSelf = Shiboken::Converter<QWindowStateChangeEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWindowStateChangeEvent::isOverride();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWindowStateChangeEventFunc_oldState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // oldState()const
    QWindowStateChangeEvent* cppSelf = Shiboken::Converter<QWindowStateChangeEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::WindowState> cpp_result = cppSelf->QWindowStateChangeEvent::oldState();
    py_result = Shiboken::Converter<QFlags<Qt::WindowState> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWindowStateChangeEvent_methods[] = {
    {"isOverride", (PyCFunction)SbkQWindowStateChangeEventFunc_isOverride, METH_NOARGS},
    {"oldState", (PyCFunction)SbkQWindowStateChangeEventFunc_oldState, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWindowStateChangeEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QWindowStateChangeEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWindowStateChangeEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWindowStateChangeEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWindowStateChangeEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQWindowStateChangeEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQWindowStateChangeEvent_Type);
     if ( reinterpret_cast<QWindowStateChangeEvent*>(cptr)->type() == QEvent::WindowStateChange)
        return &SbkQWindowStateChangeEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QWindowStateChangeEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QWINDOWSTATECHANGEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWindowStateChangeEvent_Type);

    SbkQWindowStateChangeEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQWindowStateChangeEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQWindowStateChangeEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQWindowStateChangeEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQWindowStateChangeEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWindowStateChangeEvent_Type));
    PyModule_AddObject(module, "QWindowStateChangeEvent",
        ((PyObject*)&SbkQWindowStateChangeEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QWindowStateChangeEvent >("QWindowStateChangeEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWindowStateChangeEvent >(typeid(QWindowStateChangeEvent).name());
}


} // extern "C"

