/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qvector2d_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qpoint.h>
#include <qvariant.h>
#include <qvector2d.h>
#include <qvector3d.h>
#include <qvector4d.h>

using namespace Shiboken;

static int
SbkQVector2D_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QVector2D* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QVector2D", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QVector2D()
        cptr = new QVector2D();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // QVector2D(qreal,qreal)
        cptr = new QVector2D(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // QVector2D(QPoint)
        cptr = new QVector2D(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // QVector2D(QPointF)
        cptr = new QVector2D(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[0]);
        // QVector2D(QVector2D)
        cptr = new QVector2D(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector3D & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVector3D > cpp_arg0_auto_ptr;
        QVector3D* cpp_arg0 = Shiboken::Converter<QVector3D* >::toCpp(pyargs[0]);
        if (!SbkQVector3D_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector3D >(cpp_arg0);
        // QVector2D(QVector3D)
        cptr = new QVector2D(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector4D & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVector4D > cpp_arg0_auto_ptr;
        QVector4D* cpp_arg0 = Shiboken::Converter<QVector4D* >::toCpp(pyargs[0]);
        if (!SbkQVector4D_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVector4D >(cpp_arg0);
        // QVector2D(QVector4D)
        cptr = new QVector2D(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2D_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QVector2D >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQVector2D_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQVector2D_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", "", "PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "PySide.QtGui.QVector3D", "PySide.QtGui.QVector4D", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QVector2D", overloads);
        return -1;
}

static PyObject* SbkQVector2DFunc_dotProduct(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dotProduct", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVector2D & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QVector2D* cpp_arg1 = Shiboken::Converter<QVector2D* >::toCpp(pyargs[1]);
        // dotProduct(QVector2D,QVector2D)
        qreal cpp_result = QVector2D::dotProduct(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc_dotProduct_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc_dotProduct_TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D, PySide.QtGui.QVector2D", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QVector2D.dotProduct", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVector2D::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector2D::length();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_lengthSquared(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lengthSquared()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector2D::lengthSquared();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_normalize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // normalize()
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    cppSelf->QVector2D::normalize();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQVector2DFunc_normalized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalized()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    QVector2D cpp_result = cppSelf->QVector2D::normalized();
    py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setX(qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        cppSelf->QVector2D::setX(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector2DFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.setX", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setY(qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        cppSelf->QVector2D::setY(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVector2DFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.setY", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc_toPoint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPoint()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QVector2D::toPoint();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_toPointF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPointF()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QVector2D::toPointF();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_toVector3D(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector3D()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    QVector3D cpp_result = cppSelf->QVector2D::toVector3D();
    py_result = Shiboken::Converter<QVector3D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_toVector4D(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector4D()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    QVector4D cpp_result = cppSelf->QVector2D::toVector4D();
    py_result = Shiboken::Converter<QVector4D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector2D::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QVector2D::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQVector2D_methods[] = {
    {"dotProduct", (PyCFunction)SbkQVector2DFunc_dotProduct, METH_VARARGS|METH_STATIC},
    {"isNull", (PyCFunction)SbkQVector2DFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQVector2DFunc_length, METH_NOARGS},
    {"lengthSquared", (PyCFunction)SbkQVector2DFunc_lengthSquared, METH_NOARGS},
    {"normalize", (PyCFunction)SbkQVector2DFunc_normalize, METH_NOARGS},
    {"normalized", (PyCFunction)SbkQVector2DFunc_normalized, METH_NOARGS},
    {"setX", (PyCFunction)SbkQVector2DFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQVector2DFunc_setY, METH_O},
    {"toPoint", (PyCFunction)SbkQVector2DFunc_toPoint, METH_NOARGS},
    {"toPointF", (PyCFunction)SbkQVector2DFunc_toPointF, METH_NOARGS},
    {"toVector3D", (PyCFunction)SbkQVector2DFunc_toVector3D, METH_NOARGS},
    {"toVector4D", (PyCFunction)SbkQVector2DFunc_toVector4D, METH_NOARGS},
    {"x", (PyCFunction)SbkQVector2DFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQVector2DFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQVector2DFunc___mul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rmul__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rmul__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QVector2D,qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QVector2D) [reverse operator]
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator*(QVector2D,QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___mul___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", "float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__mul__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___imul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator*=(QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        (*cppSelf) *= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQVector2DFunc___imul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__imul__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator+(QVector2D,QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__add__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___iadd__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator+=(QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQVector2DFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__iadd__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    // operator-(QVector2D)
    QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
    const QVector2D cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVector2DFunc___sub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rsub__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rsub__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator-(QVector2D,QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___sub___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__sub__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___isub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QVector2D & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVector2D* cpp_arg0 = Shiboken::Converter<QVector2D* >::toCpp(arg);
        // operator-=(QVector2D)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQVector2DFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtGui.QVector2D", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__isub__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___div__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rdiv__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rdiv__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QVector2D,qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        const QVector2D cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QVector2D >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___div___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__div__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___idiv__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVector2DFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQVector2DFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__idiv__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QVector2D) [reverse operator]
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQVector2DFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQVector2DFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQVector2D_Check(arg) && !SbkQVector2D_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QVector2D&) [reverse operator]
        QVector2D* cppSelf = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQVector2DFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVector2DFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QVector2D.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQVector2D_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQVector2DFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQVector2DFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQVector2DFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQVector2DFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQVector2DFunc___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQVector2DFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQVector2DFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQVector2DFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQVector2DFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQVector2DFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQVector2DFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQVector2D_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QVector2D& cpp_self = *Shiboken::Converter<QVector2D* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVector2D & >::isConvertible(other)) {
                // operator!=(const QVector2D & v2)
                QVector2D* cpp_other = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QVector2D  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQVector2D_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVector2D & >::isConvertible(other)) {
                // operator==(const QVector2D & v2)
                QVector2D* cpp_other = Shiboken::Converter<QVector2D* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QVector2D  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQVector2D_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQVector2D_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQVector2D_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QVector2D",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQVector2D_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQVector2D_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQVector2D_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQVector2D_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QVector2D >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QVector2D(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QVECTOR2D_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQVector2D_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQVector2D_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQVector2D_Type));
    PyModule_AddObject(module, "QVector2D",
        ((PyObject*)&SbkQVector2D_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QVector2D >("QVector2D");
    Shiboken::TypeResolver::createValueTypeResolver<QVector2D >(typeid(QVector2D).name());
}


} // extern "C"

