/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SBK_QTIMEEDITWRAPPER_H
#define SBK_QTIMEEDITWRAPPER_H

#define protected public

#include <shiboken.h>

#include <qdatetimeedit.h>

namespace PySide { class DynamicQMetaObject; }

class QTimeEditWrapper : public QTimeEdit
{
public:
    QTimeEditWrapper(QWidget * parent = 0);
    QTimeEditWrapper(const QTime & time, QWidget * parent = 0);
    virtual void actionEvent(QActionEvent * arg__1);
    virtual void changeEvent(QEvent * event);
    virtual void childEvent(QChildEvent * arg__1);
    virtual void clear();
    virtual void closeEvent(QCloseEvent * event);
    virtual void connectNotify(const char * signal);
    virtual void contextMenuEvent(QContextMenuEvent * event);
    virtual void customEvent(QEvent * arg__1);
    virtual QDateTime dateTimeFromText(const QString & text) const;
    virtual int devType() const;
    virtual void disconnectNotify(const char * signal);
    virtual void dragEnterEvent(QDragEnterEvent * arg__1);
    virtual void dragLeaveEvent(QDragLeaveEvent * arg__1);
    virtual void dragMoveEvent(QDragMoveEvent * arg__1);
    virtual void dropEvent(QDropEvent * arg__1);
    virtual void enterEvent(QEvent * arg__1);
    virtual bool event(QEvent * event);
    virtual bool eventFilter(QObject * arg__1, QEvent * arg__2);
    virtual void fixup(QString & input) const;
    virtual void focusInEvent(QFocusEvent * event);
    virtual bool focusNextPrevChild(bool next);
    virtual void focusOutEvent(QFocusEvent * event);
    virtual int heightForWidth(int arg__1) const;
    virtual void hideEvent(QHideEvent * event);
    virtual void inputMethodEvent(QInputMethodEvent * arg__1);
    virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg__1) const;
    virtual void keyPressEvent(QKeyEvent * event);
    virtual void keyReleaseEvent(QKeyEvent * event);
    virtual void languageChange();
    virtual void leaveEvent(QEvent * arg__1);
    virtual const QMetaObject * metaObject() const;
    virtual int metric(QPaintDevice::PaintDeviceMetric arg__1) const;
    virtual QSize minimumSizeHint() const;
    virtual void mouseDoubleClickEvent(QMouseEvent * arg__1);
    virtual void mouseMoveEvent(QMouseEvent * event);
    virtual void mousePressEvent(QMouseEvent * event);
    virtual void mouseReleaseEvent(QMouseEvent * event);
    virtual void moveEvent(QMoveEvent * arg__1);
    virtual QPaintEngine * paintEngine() const;
    virtual void paintEvent(QPaintEvent * event);
    virtual void resizeEvent(QResizeEvent * event);
    virtual void setVisible(bool visible);
    virtual void showEvent(QShowEvent * event);
    virtual QSize sizeHint() const;
    virtual void stepBy(int steps);
    virtual QFlags<QAbstractSpinBox::StepEnabledFlag> stepEnabled() const;
    virtual void tabletEvent(QTabletEvent * arg__1);
    virtual QString textFromDateTime(const QDateTime & dt) const;
    virtual void timerEvent(QTimerEvent * event);
    virtual QValidator::State validate(QString & input, int & pos) const;
    virtual void wheelEvent(QWheelEvent * event);
    ~QTimeEditWrapper();
public:
    virtual int qt_metacall(QMetaObject::Call call, int id, void** args);
private:
    mutable PySide::DynamicQMetaObject* m_metaObject;
};

#endif // SBK_QTIMEEDITWRAPPER_H

