/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtablewidget_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qheaderview.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qtablewidget.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTableWidgetWrapper::QTableWidgetWrapper(QWidget * parent) : QTableWidget(parent), m_metaObject(0) {
    // ... middle
}

QTableWidgetWrapper::QTableWidgetWrapper(int rows, int columns, QWidget * parent) : QTableWidget(rows, columns, parent), m_metaObject(0) {
    // ... middle
}

void QTableWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTableWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTableWidgetWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QTableView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(current),
        Shiboken::Converter<QModelIndex & >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(topLeft),
        Shiboken::Converter<QModelIndex & >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTableWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QTableWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTableWidgetWrapper::dropMimeData(int row, int column, const QMimeData * data, Qt::DropAction action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QTableWidget::dropMimeData(row, column, data, action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiSS)",
        row,
        column,
        Shiboken::Converter<QMimeData * >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.dropMimeData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTableWidgetWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.edit", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QTableWidgetWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QObject * >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTableWidgetWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QTableWidget::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTableWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTableWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTableWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTableWidgetWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QTableView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.horizontalOffset", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QTableView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QTableWidgetWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QTableView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPoint & >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.indexAt", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QTableWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QTableWidgetWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QTableView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.isIndexHidden", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTableWidgetWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTableWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QStringList QTableWidgetWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QTableWidget::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.mimeTypes", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QSize QTableWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTableWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTableView::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Sii)",
        Shiboken::Converter<QModelIndex & >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Sii)",
        Shiboken::Converter<QModelIndex & >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QTableView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QTableView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QTableWidgetWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QTableView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.selectedIndexes", "list", py_result->ob_type->tp_name);
        return QList<QModelIndex >();
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QTableView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QItemSelection & >::toPython(selected),
        Shiboken::Converter<QItemSelection & >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QTableWidgetWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.selectionCommand", SbkType<QFlags<QItemSelectionModel::SelectionFlag> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTableWidgetWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QTableView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QTableView::setSelection(rect, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QTableView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QItemSelectionModel * >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QTableWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QTableWidgetWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QTableView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.sizeHintForColumn", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QTableWidgetWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QTableView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.sizeHintForRow", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::DropAction> QTableWidgetWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QTableWidget::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.supportedDropActions", SbkType<QFlags<Qt::DropAction> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::DropAction>();
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTableWidgetWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTableView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QTableView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTableWidgetWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QTableView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.verticalOffset", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QTableView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTableWidgetWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QTableWidgetWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QTableView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.viewOptions", SbkType<QStyleOptionViewItem >()->tp_name, py_result->ob_type->tp_name);
        return QStyleOptionViewItem();
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QTableWidgetWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.viewportEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QTableWidgetWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QTableView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.visualRect", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QTableWidgetWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QTableView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QItemSelection & >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTableWidget.visualRegionForSelection", SbkType<QRegion >()->tp_name, py_result->ob_type->tp_name);
        return QRegion();
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QTableWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTableWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTableWidget::staticMetaObject);
}
    return m_metaObject;
}

int QTableWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTableWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTableWidgetWrapper::~QTableWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTableWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTableWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QTableWidget", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QTableWidget(QWidget*)
        cptr = new QTableWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QTableWidget(int,int,QWidget*)
            cptr = new QTableWidgetWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // QTableWidget(int,int,QWidget*)
            cptr = new QTableWidgetWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else goto SbkQTableWidget_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTableWidget(QWidget*)
        cptr = new QTableWidgetWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTableWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTableWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTableWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTableWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "int, int, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget", overloads);
        return -1;
}

static PyObject* SbkQTableWidgetFunc_cellWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cellWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // cellWidget(int,int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTableWidget::cellWidget(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_cellWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_cellWidget_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.cellWidget", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    cppSelf->QTableWidget::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTableWidgetFunc_clearContents(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearContents()
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    cppSelf->QTableWidget::clearContents();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTableWidgetFunc_closePersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // closePersistentEditor(QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::closePersistentEditor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_closePersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_closePersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.closePersistentEditor", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_column(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // column(const QTableWidgetItem*)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTableWidget::column(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_column_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_column_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.column", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidget::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_currentColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentColumn()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidget::currentColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_currentItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentItem()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    QTableWidgetItem * cpp_result = cppSelf->QTableWidget::currentItem();
    py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_currentRow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentRow()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidget::currentRow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::dropEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.dropEvent", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QMimeData * >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QMimeData* cpp_arg2 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[2]);
        Qt::DropAction cpp_arg3 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[3]);
        // dropMimeData(int,int,const QMimeData*,Qt::DropAction)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTableWidget::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_dropMimeData_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.dropMimeData", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_editItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // editItem(QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::editItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_editItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_editItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.editItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTableWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.event", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_findItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "findItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QFlags<Qt::MatchFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[1]);
        // findItems(QString,QFlags<Qt::MatchFlag>)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QList<QTableWidgetItem * > cpp_result = cppSelf->QTableWidget::findItems(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QList<QTableWidgetItem * > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_findItems_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_findItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.findItems", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_horizontalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // horizontalHeaderItem(int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::horizontalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_horizontalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_horizontalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.horizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_indexFromItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // indexFromItem(QTableWidgetItem*)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QTableWidget::indexFromItem(cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_indexFromItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_indexFromItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.indexFromItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_insertColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // insertColumn(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::insertColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_insertColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_insertColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.insertColumn", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_insertRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // insertRow(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::insertRow(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_insertRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_insertRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.insertRow", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_item(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "item", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // item(int,int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::item(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_item_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_item_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.item", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // itemAt(int,int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::itemAt(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // itemAt(QPoint)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::itemAt(*cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_itemAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.itemAt", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_itemFromIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemFromIndex(QModelIndex)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::itemFromIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_itemFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_itemFromIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.itemFromIndex", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_itemPrototype(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemPrototype()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    const QTableWidgetItem * cpp_result = cppSelf->QTableWidget::itemPrototype();
    py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_items(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMimeData * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // items(const QMimeData*)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QList<QTableWidgetItem * > cpp_result = cppSelf->QTableWidget::items(cpp_arg0);
        py_result = Shiboken::Converter<QList<QTableWidgetItem * > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_items_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_items_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.items", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QTableWidget::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_openPersistentEditor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // openPersistentEditor(QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::openPersistentEditor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_openPersistentEditor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_openPersistentEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.openPersistentEditor", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_removeCellWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeCellWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeCellWidget(int,int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::removeCellWidget(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_removeCellWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_removeCellWidget_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.removeCellWidget", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_removeColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeColumn(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::removeColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_removeColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_removeColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.removeColumn", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_removeRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeRow(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::removeRow(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_removeRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_removeRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.removeRow", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_row(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // row(const QTableWidgetItem*)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTableWidget::row(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_row_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_row_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.row", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTableWidget::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_scrollToItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollToItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollToItem(const QTableWidgetItem*,QAbstractItemView::ScrollHint)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::scrollToItem(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollToItem(const QTableWidgetItem*,QAbstractItemView::ScrollHint)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::scrollToItem(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTableWidgetFunc_scrollToItem_TypeError;
    } else goto SbkQTableWidgetFunc_scrollToItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_scrollToItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.scrollToItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_selectedItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedItems()
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    QList<QTableWidgetItem * > cpp_result = cppSelf->QTableWidget::selectedItems();
    py_result = Shiboken::Converter<QList<QTableWidgetItem * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_selectedRanges(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedRanges()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    QList<QTableWidgetSelectionRange > cpp_result = cppSelf->QTableWidget::selectedRanges();
    py_result = Shiboken::Converter<QList<QTableWidgetSelectionRange > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_setCellWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCellWidget", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // setCellWidget(int,int,QWidget*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setCellWidget(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[2]);
    } else goto SbkQTableWidgetFunc_setCellWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setCellWidget_TypeError:
        const char* overloads[] = {"int, int, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setCellWidget", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setColumnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColumnCount(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setColumnCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_setColumnCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setColumnCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.setColumnCount", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setCurrentCell(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentCell", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // setCurrentCell(int,int)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::setCurrentCell(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[2])) {
            QFlags<QItemSelectionModel::SelectionFlag> cpp_arg2 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[2]);
            // setCurrentCell(int,int,QFlags<QItemSelectionModel::SelectionFlag>)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::setCurrentCell(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTableWidgetFunc_setCurrentCell_TypeError;
    } else goto SbkQTableWidgetFunc_setCurrentCell_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setCurrentCell_TypeError:
        const char* overloads[] = {"int, int", "int, int, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setCurrentCell", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setCurrentItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCurrentItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setCurrentItem(QTableWidgetItem*)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::setCurrentItem(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (numArgs == 2 && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
            QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
            // setCurrentItem(QTableWidgetItem*,QFlags<QItemSelectionModel::SelectionFlag>)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::setCurrentItem(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQTableWidgetFunc_setCurrentItem_TypeError;
    } else goto SbkQTableWidgetFunc_setCurrentItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setCurrentItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", "PySide.QtGui.QTableWidgetItem, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setCurrentItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setHorizontalHeaderItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHorizontalHeaderItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTableWidgetItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTableWidgetItem* cpp_arg1 = Shiboken::Converter<QTableWidgetItem* >::toCpp(pyargs[1]);
        // setHorizontalHeaderItem(int,QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setHorizontalHeaderItem(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTableWidgetFunc_setHorizontalHeaderItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setHorizontalHeaderItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setHorizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setHorizontalHeaderLabels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setHorizontalHeaderLabels(QStringList)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setHorizontalHeaderLabels(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_setHorizontalHeaderLabels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setHorizontalHeaderLabels_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.setHorizontalHeaderLabels", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setItem", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QTableWidgetItem * >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTableWidgetItem* cpp_arg2 = Shiboken::Converter<QTableWidgetItem* >::toCpp(pyargs[2]);
        // setItem(int,int,QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setItem(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[2]);
    } else goto SbkQTableWidgetFunc_setItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setItem_TypeError:
        const char* overloads[] = {"int, int, PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setItemPrototype(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // setItemPrototype(const QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setItemPrototype(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQTableWidgetFunc_setItemPrototype_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setItemPrototype_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.setItemPrototype", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setRangeSelected(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRangeSelected", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTableWidgetSelectionRange & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTableWidgetSelectionRange* cpp_arg0 = Shiboken::Converter<QTableWidgetSelectionRange* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setRangeSelected(QTableWidgetSelectionRange,bool)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setRangeSelected(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_setRangeSelected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setRangeSelected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetSelectionRange, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setRangeSelected", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setRowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRowCount(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setRowCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_setRowCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setRowCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.setRowCount", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setVerticalHeaderItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setVerticalHeaderItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTableWidgetItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTableWidgetItem* cpp_arg1 = Shiboken::Converter<QTableWidgetItem* >::toCpp(pyargs[1]);
        // setVerticalHeaderItem(int,QTableWidgetItem*)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setVerticalHeaderItem(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQTableWidgetFunc_setVerticalHeaderItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setVerticalHeaderItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.setVerticalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_setVerticalHeaderLabels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setVerticalHeaderLabels(QStringList)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        cppSelf->QTableWidget::setVerticalHeaderLabels(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_setVerticalHeaderLabels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_setVerticalHeaderLabels_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.setVerticalHeaderLabels", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_sortItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sortItems", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sortItems(int,Qt::SortOrder)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::sortItems(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sortItems(int,Qt::SortOrder)
            QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
            cppSelf->QTableWidget::sortItems(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTableWidgetFunc_sortItems_TypeError;
    } else goto SbkQTableWidgetFunc_sortItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTableWidgetFunc_sortItems_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.sortItems", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QTableWidget::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTableWidgetFunc_takeHorizontalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeHorizontalHeaderItem(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::takeHorizontalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQTableWidgetFunc_takeHorizontalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_takeHorizontalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.takeHorizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_takeItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "takeItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // takeItem(int,int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::takeItem(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQTableWidgetFunc_takeItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_takeItem_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTableWidget.takeItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_takeVerticalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeVerticalHeaderItem(int)
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::takeVerticalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQTableWidgetFunc_takeVerticalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_takeVerticalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.takeVerticalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_verticalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // verticalHeaderItem(int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QTableWidgetItem * cpp_result = cppSelf->QTableWidget::verticalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QTableWidgetItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTableWidgetFunc_verticalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_verticalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.verticalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_visualColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // visualColumn(int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTableWidget::visualColumn(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_visualColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_visualColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.visualColumn", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_visualItemRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTableWidgetItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTableWidgetItem* cpp_arg0 = Shiboken::Converter<QTableWidgetItem* >::toCpp(arg);
        // visualItemRect(const QTableWidgetItem*)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTableWidget::visualItemRect(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_visualItemRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_visualItemRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTableWidgetItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.visualItemRect", overloads);
        return 0;
}

static PyObject* SbkQTableWidgetFunc_visualRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // visualRow(int)const
        QTableWidget* cppSelf = Shiboken::Converter<QTableWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTableWidget::visualRow(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTableWidgetFunc_visualRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTableWidgetFunc_visualRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTableWidget.visualRow", overloads);
        return 0;
}

static PyMethodDef SbkQTableWidget_methods[] = {
    {"cellWidget", (PyCFunction)SbkQTableWidgetFunc_cellWidget, METH_VARARGS},
    {"clear", (PyCFunction)SbkQTableWidgetFunc_clear, METH_NOARGS},
    {"clearContents", (PyCFunction)SbkQTableWidgetFunc_clearContents, METH_NOARGS},
    {"closePersistentEditor", (PyCFunction)SbkQTableWidgetFunc_closePersistentEditor, METH_O},
    {"column", (PyCFunction)SbkQTableWidgetFunc_column, METH_O},
    {"columnCount", (PyCFunction)SbkQTableWidgetFunc_columnCount, METH_NOARGS},
    {"currentColumn", (PyCFunction)SbkQTableWidgetFunc_currentColumn, METH_NOARGS},
    {"currentItem", (PyCFunction)SbkQTableWidgetFunc_currentItem, METH_NOARGS},
    {"currentRow", (PyCFunction)SbkQTableWidgetFunc_currentRow, METH_NOARGS},
    {"dropEvent", (PyCFunction)SbkQTableWidgetFunc_dropEvent, METH_O},
    {"dropMimeData", (PyCFunction)SbkQTableWidgetFunc_dropMimeData, METH_VARARGS},
    {"editItem", (PyCFunction)SbkQTableWidgetFunc_editItem, METH_O},
    {"event", (PyCFunction)SbkQTableWidgetFunc_event, METH_O},
    {"findItems", (PyCFunction)SbkQTableWidgetFunc_findItems, METH_VARARGS},
    {"horizontalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_horizontalHeaderItem, METH_O},
    {"indexFromItem", (PyCFunction)SbkQTableWidgetFunc_indexFromItem, METH_O},
    {"insertColumn", (PyCFunction)SbkQTableWidgetFunc_insertColumn, METH_O},
    {"insertRow", (PyCFunction)SbkQTableWidgetFunc_insertRow, METH_O},
    {"item", (PyCFunction)SbkQTableWidgetFunc_item, METH_VARARGS},
    {"itemAt", (PyCFunction)SbkQTableWidgetFunc_itemAt, METH_VARARGS},
    {"itemFromIndex", (PyCFunction)SbkQTableWidgetFunc_itemFromIndex, METH_O},
    {"itemPrototype", (PyCFunction)SbkQTableWidgetFunc_itemPrototype, METH_NOARGS},
    {"items", (PyCFunction)SbkQTableWidgetFunc_items, METH_O},
    {"mimeTypes", (PyCFunction)SbkQTableWidgetFunc_mimeTypes, METH_NOARGS},
    {"openPersistentEditor", (PyCFunction)SbkQTableWidgetFunc_openPersistentEditor, METH_O},
    {"removeCellWidget", (PyCFunction)SbkQTableWidgetFunc_removeCellWidget, METH_VARARGS},
    {"removeColumn", (PyCFunction)SbkQTableWidgetFunc_removeColumn, METH_O},
    {"removeRow", (PyCFunction)SbkQTableWidgetFunc_removeRow, METH_O},
    {"row", (PyCFunction)SbkQTableWidgetFunc_row, METH_O},
    {"rowCount", (PyCFunction)SbkQTableWidgetFunc_rowCount, METH_NOARGS},
    {"scrollToItem", (PyCFunction)SbkQTableWidgetFunc_scrollToItem, METH_VARARGS},
    {"selectedItems", (PyCFunction)SbkQTableWidgetFunc_selectedItems, METH_NOARGS},
    {"selectedRanges", (PyCFunction)SbkQTableWidgetFunc_selectedRanges, METH_NOARGS},
    {"setCellWidget", (PyCFunction)SbkQTableWidgetFunc_setCellWidget, METH_VARARGS},
    {"setColumnCount", (PyCFunction)SbkQTableWidgetFunc_setColumnCount, METH_O},
    {"setCurrentCell", (PyCFunction)SbkQTableWidgetFunc_setCurrentCell, METH_VARARGS},
    {"setCurrentItem", (PyCFunction)SbkQTableWidgetFunc_setCurrentItem, METH_VARARGS},
    {"setHorizontalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_setHorizontalHeaderItem, METH_VARARGS},
    {"setHorizontalHeaderLabels", (PyCFunction)SbkQTableWidgetFunc_setHorizontalHeaderLabels, METH_O},
    {"setItem", (PyCFunction)SbkQTableWidgetFunc_setItem, METH_VARARGS},
    {"setItemPrototype", (PyCFunction)SbkQTableWidgetFunc_setItemPrototype, METH_O},
    {"setRangeSelected", (PyCFunction)SbkQTableWidgetFunc_setRangeSelected, METH_VARARGS},
    {"setRowCount", (PyCFunction)SbkQTableWidgetFunc_setRowCount, METH_O},
    {"setVerticalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_setVerticalHeaderItem, METH_VARARGS},
    {"setVerticalHeaderLabels", (PyCFunction)SbkQTableWidgetFunc_setVerticalHeaderLabels, METH_O},
    {"sortItems", (PyCFunction)SbkQTableWidgetFunc_sortItems, METH_VARARGS},
    {"supportedDropActions", (PyCFunction)SbkQTableWidgetFunc_supportedDropActions, METH_NOARGS},
    {"takeHorizontalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_takeHorizontalHeaderItem, METH_O},
    {"takeItem", (PyCFunction)SbkQTableWidgetFunc_takeItem, METH_VARARGS},
    {"takeVerticalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_takeVerticalHeaderItem, METH_O},
    {"verticalHeaderItem", (PyCFunction)SbkQTableWidgetFunc_verticalHeaderItem, METH_O},
    {"visualColumn", (PyCFunction)SbkQTableWidgetFunc_visualColumn, METH_O},
    {"visualItemRect", (PyCFunction)SbkQTableWidgetFunc_visualItemRect, METH_O},
    {"visualRow", (PyCFunction)SbkQTableWidgetFunc_visualRow, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTableWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTableWidget* me = reinterpret_cast<QTableWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTABLEVIEW_IDX]))
        return static_cast<QTableView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTableWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTableWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTableWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTableWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTableWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTableWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTableWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABLEWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTableWidget_Type);

    SbkQTableWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTABLEVIEW_IDX];
    SbkQTableWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTableWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTableWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTableWidget_Type));
    PyModule_AddObject(module, "QTableWidget",
        ((PyObject*)&SbkQTableWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTableWidget >("QTableWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTableWidget >(typeid(QTableWidget).name());
}


} // extern "C"

