/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qprintpreviewwidget_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPrintPreviewWidgetWrapper::QPrintPreviewWidgetWrapper(QPrinter * printer, QWidget * parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(printer, parent, flags), m_metaObject(0) {
    // ... middle
}

QPrintPreviewWidgetWrapper::QPrintPreviewWidgetWrapper(QWidget * parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(parent, flags), m_metaObject(0) {
    // ... middle
}

void QPrintPreviewWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QPrintPreviewWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QPrintPreviewWidgetWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QPrintPreviewWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QPrintPreviewWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QPrintPreviewWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QPrintPreviewWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QPrintPreviewWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QPrintPreviewWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QPrintPreviewWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QPrintPreviewWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QPrintPreviewWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintPreviewWidget.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QPrintPreviewWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPrintPreviewWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPrintPreviewWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QPrintPreviewWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QPrintPreviewWidget::staticMetaObject);
}
    return m_metaObject;
}

int QPrintPreviewWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QPrintPreviewWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QPrintPreviewWidgetWrapper::~QPrintPreviewWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQPrintPreviewWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPrintPreviewWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QPrintPreviewWidget", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QPrintPreviewWidget(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QPrintPreviewWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QPrintPreviewWidget(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QPrintPreviewWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QPrintPreviewWidget(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QPrintPreviewWidgetWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQPrintPreviewWidget_Init_TypeError;
    } else if (Shiboken::Converter<QPrinter * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QPrintPreviewWidget(QPrinter*,QWidget*,QFlags<Qt::WindowType>)
            cptr = new QPrintPreviewWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QPrintPreviewWidget(QPrinter*,QWidget*,QFlags<Qt::WindowType>)
                cptr = new QPrintPreviewWidgetWrapper(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], self);
            } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[2])) {
                QFlags<Qt::WindowType> cpp_arg2 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[2]);
                // QPrintPreviewWidget(QPrinter*,QWidget*,QFlags<Qt::WindowType>)
                cptr = new QPrintPreviewWidgetWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], self);
            } else goto SbkQPrintPreviewWidget_Init_TypeError;
        } else goto SbkQPrintPreviewWidget_Init_TypeError;
    } else goto SbkQPrintPreviewWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPrintPreviewWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPrintPreviewWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPrintPreviewWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter, PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", "PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrintPreviewWidget", overloads);
        return -1;
}

static PyObject* SbkQPrintPreviewWidgetFunc_currentPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentPage()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrintPreviewWidget::currentPage();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_fitInView(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // fitInView()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::fitInView();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_fitToWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // fitToWidth()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::fitToWidth();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_numPages(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numPages()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrintPreviewWidget::numPages();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    QPrinter::Orientation cpp_result = cppSelf->QPrintPreviewWidget::orientation();
    py_result = Shiboken::Converter<QPrinter::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_pageCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pageCount()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPrintPreviewWidget::pageCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_print(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // print()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::print();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setAllPagesViewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setAllPagesViewMode()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::setAllPagesViewMode();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setCurrentPage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentPage(int)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setCurrentPage(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setCurrentPage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setCurrentPage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setCurrentPage", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setFacingPagesViewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setFacingPagesViewMode()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::setFacingPagesViewMode();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setLandscapeOrientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setLandscapeOrientation()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::setLandscapeOrientation();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrinter::Orientation >::isConvertible(arg)) {
        QPrinter::Orientation cpp_arg0 = Shiboken::Converter<QPrinter::Orientation >::toCpp(arg);
        // setOrientation(QPrinter::Orientation)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setOrientation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrinter.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setOrientation", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setPortraitOrientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setPortraitOrientation()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::setPortraitOrientation();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setSinglePageViewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setSinglePageViewMode()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::setSinglePageViewMode();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setViewMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrintPreviewWidget::ViewMode >::isConvertible(arg)) {
        QPrintPreviewWidget::ViewMode cpp_arg0 = Shiboken::Converter<QPrintPreviewWidget::ViewMode >::toCpp(arg);
        // setViewMode(QPrintPreviewWidget::ViewMode)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setViewMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setViewMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setViewMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrintPreviewWidget.ViewMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setViewMode", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setVisible", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setZoomFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setZoomFactor(qreal)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setZoomFactor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setZoomFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setZoomFactor_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setZoomFactor", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_setZoomMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPrintPreviewWidget::ZoomMode >::isConvertible(arg)) {
        QPrintPreviewWidget::ZoomMode cpp_arg0 = Shiboken::Converter<QPrintPreviewWidget::ZoomMode >::toCpp(arg);
        // setZoomMode(QPrintPreviewWidget::ZoomMode)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::setZoomMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_setZoomMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_setZoomMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrintPreviewWidget.ZoomMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.setZoomMode", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_updatePreview(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updatePreview()
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    cppSelf->QPrintPreviewWidget::updatePreview();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPrintPreviewWidgetFunc_viewMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewMode()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    QPrintPreviewWidget::ViewMode cpp_result = cppSelf->QPrintPreviewWidget::viewMode();
    py_result = Shiboken::Converter<QPrintPreviewWidget::ViewMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_zoomFactor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // zoomFactor()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPrintPreviewWidget::zoomFactor();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_zoomIn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // zoomIn(qreal)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::zoomIn();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // zoomIn(qreal)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::zoomIn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_zoomIn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_zoomIn_TypeError:
        const char* overloads[] = {"float = 1.1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.zoomIn", overloads);
        return 0;
}

static PyObject* SbkQPrintPreviewWidgetFunc_zoomMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // zoomMode()const
    QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
    QPrintPreviewWidget::ZoomMode cpp_result = cppSelf->QPrintPreviewWidget::zoomMode();
    py_result = Shiboken::Converter<QPrintPreviewWidget::ZoomMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintPreviewWidgetFunc_zoomOut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // zoomOut(qreal)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::zoomOut();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // zoomOut(qreal)
        QPrintPreviewWidget* cppSelf = Shiboken::Converter<QPrintPreviewWidget* >::toCpp((PyObject*)self);
        cppSelf->QPrintPreviewWidget::zoomOut(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintPreviewWidgetFunc_zoomOut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintPreviewWidgetFunc_zoomOut_TypeError:
        const char* overloads[] = {"float = 1.1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintPreviewWidget.zoomOut", overloads);
        return 0;
}

static PyMethodDef SbkQPrintPreviewWidget_methods[] = {
    {"currentPage", (PyCFunction)SbkQPrintPreviewWidgetFunc_currentPage, METH_NOARGS},
    {"fitInView", (PyCFunction)SbkQPrintPreviewWidgetFunc_fitInView, METH_NOARGS},
    {"fitToWidth", (PyCFunction)SbkQPrintPreviewWidgetFunc_fitToWidth, METH_NOARGS},
    {"numPages", (PyCFunction)SbkQPrintPreviewWidgetFunc_numPages, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQPrintPreviewWidgetFunc_orientation, METH_NOARGS},
    {"pageCount", (PyCFunction)SbkQPrintPreviewWidgetFunc_pageCount, METH_NOARGS},
    {"print", (PyCFunction)SbkQPrintPreviewWidgetFunc_print, METH_NOARGS},
    {"setAllPagesViewMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_setAllPagesViewMode, METH_NOARGS},
    {"setCurrentPage", (PyCFunction)SbkQPrintPreviewWidgetFunc_setCurrentPage, METH_O},
    {"setFacingPagesViewMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_setFacingPagesViewMode, METH_NOARGS},
    {"setLandscapeOrientation", (PyCFunction)SbkQPrintPreviewWidgetFunc_setLandscapeOrientation, METH_NOARGS},
    {"setOrientation", (PyCFunction)SbkQPrintPreviewWidgetFunc_setOrientation, METH_O},
    {"setPortraitOrientation", (PyCFunction)SbkQPrintPreviewWidgetFunc_setPortraitOrientation, METH_NOARGS},
    {"setSinglePageViewMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_setSinglePageViewMode, METH_NOARGS},
    {"setViewMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_setViewMode, METH_O},
    {"setVisible", (PyCFunction)SbkQPrintPreviewWidgetFunc_setVisible, METH_O},
    {"setZoomFactor", (PyCFunction)SbkQPrintPreviewWidgetFunc_setZoomFactor, METH_O},
    {"setZoomMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_setZoomMode, METH_O},
    {"updatePreview", (PyCFunction)SbkQPrintPreviewWidgetFunc_updatePreview, METH_NOARGS},
    {"viewMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_viewMode, METH_NOARGS},
    {"zoomFactor", (PyCFunction)SbkQPrintPreviewWidgetFunc_zoomFactor, METH_NOARGS},
    {"zoomIn", (PyCFunction)SbkQPrintPreviewWidgetFunc_zoomIn, METH_NOARGS|METH_O},
    {"zoomMode", (PyCFunction)SbkQPrintPreviewWidgetFunc_zoomMode, METH_NOARGS},
    {"zoomOut", (PyCFunction)SbkQPrintPreviewWidgetFunc_zoomOut, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQPrintPreviewWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QPrintPreviewWidget* me = reinterpret_cast<QPrintPreviewWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPrintPreviewWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPrintPreviewWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPrintPreviewWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPrintPreviewWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQPrintPreviewWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPrintPreviewWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ZoomMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ViewMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QPrintPreviewWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPrintPreviewWidget_Type);

    SbkQPrintPreviewWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQPrintPreviewWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQPrintPreviewWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPrintPreviewWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPrintPreviewWidget_Type));
    PyModule_AddObject(module, "QPrintPreviewWidget",
        ((PyObject*)&SbkQPrintPreviewWidget_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ZoomMode
    SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_ZOOMMODE_IDX] = &SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type);
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
            "ZoomMode",((PyObject*)&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type,
        (long) QPrintPreviewWidget::CustomZoom, "CustomZoom");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "CustomZoom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type.tp_dict,
        "CustomZoom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type,
        (long) QPrintPreviewWidget::FitToWidth, "FitToWidth");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "FitToWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type.tp_dict,
        "FitToWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type,
        (long) QPrintPreviewWidget::FitInView, "FitInView");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "FitInView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ZoomMode_Type.tp_dict,
        "FitInView", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrintPreviewWidget::ZoomMode");

    // init enum class: ViewMode
    SbkPySide_QtGuiTypes[SBK_QPRINTPREVIEWWIDGET_VIEWMODE_IDX] = &SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type);
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
            "ViewMode",((PyObject*)&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type,
        (long) QPrintPreviewWidget::SinglePageView, "SinglePageView");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "SinglePageView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type.tp_dict,
        "SinglePageView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type,
        (long) QPrintPreviewWidget::FacingPagesView, "FacingPagesView");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "FacingPagesView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type.tp_dict,
        "FacingPagesView", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type,
        (long) QPrintPreviewWidget::AllPagesView, "AllPagesView");
    PyDict_SetItemString(SbkQPrintPreviewWidget_Type.super.ht_type.tp_dict,
        "AllPagesView", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintPreviewWidget_ViewMode_Type.tp_dict,
        "AllPagesView", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrintPreviewWidget::ViewMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QPrintPreviewWidget >("QPrintPreviewWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPrintPreviewWidget >(typeid(QPrintPreviewWidget).name());
}


} // extern "C"

