/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qmenu_wrapper.h"

// Extra includes
#include <QList>
#include "glue/qmenu_glue.h"
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmenu.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMenuWrapper::QMenuWrapper(QWidget * parent) : QMenu(parent), m_metaObject(0) {
    // ... middle
}

QMenuWrapper::QMenuWrapper(const QString & title, QWidget * parent) : QMenu(title, parent), m_metaObject(0) {
    // ... middle
}

void QMenuWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QMenu::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QMenu::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMenuWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QMenu::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMenuWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QMenu::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMenuWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMenuWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QMenu::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QMenuWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QMenu::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QMenuWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QMenu::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QMenu::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMenuWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QMenuWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QMenu::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QMenu::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QMenu::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QMenuWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QMenu::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QMenuWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QMenu::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMenu.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMenuWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMenuWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QMenu::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMenuWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QMenu::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QMenuWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMenu::staticMetaObject);
}
    return m_metaObject;
}

int QMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMenuWrapper::~QMenuWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMenu_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMenuWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QMenu", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QMenu(QWidget*)
        cptr = new QMenuWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QMenu(QString,QWidget*)
            cptr = new QMenuWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QMenu(QString,QWidget*)
            cptr = new QMenuWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQMenu_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QMenu(QWidget*)
        cptr = new QMenuWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQMenu_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMenu_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMenu_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "PySide.QtCore.QString, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu", overloads);
        return -1;
}

static PyObject* SbkQMenuFunc_actionAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // actionAt(QPoint)const
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QMenu::actionAt(*cpp_arg0);
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQMenuFunc_actionAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_actionAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.actionAt", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_actionEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QActionEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QActionEvent* cpp_arg0 = Shiboken::Converter<QActionEvent* >::toCpp(arg);
        // actionEvent(QActionEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::actionEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_actionEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_actionEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QActionEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.actionEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_actionGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // actionGeometry(QAction*)const
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QMenu::actionGeometry(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_actionGeometry_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_actionGeometry_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.actionGeometry", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_activeAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // activeAction()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QMenu::activeAction();
    py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_addAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addAction", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addAction(QString)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // addAction(QString,const QObject*,const char*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QKeySequence & >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_arg3_auto_ptr;
                QKeySequence* cpp_arg3 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[3]);
                if (!SbkQKeySequence_Check(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg3);
                // addAction(QString,const QObject*,const char*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, py_result);
            } else goto SbkQMenuFunc_addAction_TypeError;
        } else if (PyObject_Check(pyargs[1])) {
            if (numArgs == 2) {
                // addAction(QString,PyObject*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                (void)cppSelf; // avoid warnings about unused variables
                // Begin code injection
                
                py_result = addActionWithPyObject(cppSelf, QIcon(), (*cpp_arg0), pyargs[1], 0);
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_arg2_auto_ptr;
                QKeySequence* cpp_arg2 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[2]);
                if (!SbkQKeySequence_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg2);
                // addAction(QString,PyObject*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                (void)cppSelf; // avoid warnings about unused variables
                // Begin code injection
                
                py_result = addActionWithPyObject(cppSelf, QIcon(), (*cpp_arg0), pyargs[1], (*cpp_arg2));
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQMenuFunc_addAction_TypeError;
        } else goto SbkQMenuFunc_addAction_TypeError;
    } else if (Shiboken::Converter<QIcon >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // addAction(QIcon,QString)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
            const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // addAction(QIcon,QString,const QObject*,const char*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, py_result);
            } else if (Shiboken::Converter<QKeySequence & >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_arg4_auto_ptr;
                QKeySequence* cpp_arg4 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[4]);
                if (!SbkQKeySequence_Check(pyargs[4]))
                    cpp_arg4_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg4);
                // addAction(QIcon,QString,const QObject*,const char*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                QAction * cpp_result = cppSelf->QMenu::addAction(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, py_result);
            } else goto SbkQMenuFunc_addAction_TypeError;
        } else if (PyObject_Check(pyargs[2])) {
            if (numArgs == 3) {
                // addAction(QIcon,QString,PyObject*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                (void)cppSelf; // avoid warnings about unused variables
                // Begin code injection
                
                py_result = addActionWithPyObject(cppSelf, (*cpp_arg0), (*cpp_arg1), pyargs[2], 0);
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_arg3_auto_ptr;
                QKeySequence* cpp_arg3 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[3]);
                if (!SbkQKeySequence_Check(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg3);
                // addAction(QIcon,QString,PyObject*,QKeySequence)
                QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
                (void)cppSelf; // avoid warnings about unused variables
                // Begin code injection
                
                py_result = addActionWithPyObject(cppSelf, (*cpp_arg0), (*cpp_arg1), pyargs[2], (*cpp_arg3));
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQMenuFunc_addAction_TypeError;
        } else goto SbkQMenuFunc_addAction_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QAction * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        // addAction(QAction*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::addAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQMenuFunc_addAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_addAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", "PySide.QtGui.QIcon, PySide.QtCore.QString, PyObject, PySide.QtGui.QKeySequence = 0", "PySide.QtCore.QString, PyObject, PySide.QtGui.QKeySequence = 0", "PySide.QtGui.QIcon, PySide.QtCore.QString", "PySide.QtGui.QIcon, PySide.QtCore.QString, PySide.QtCore.QObject, str, PySide.QtGui.QKeySequence = 0", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QObject, str, PySide.QtGui.QKeySequence = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu.addAction", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_addMenu(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addMenu", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addMenu(QString)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QMenu * cpp_result = cppSelf->QMenu::addMenu(*cpp_arg0);
        py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 2 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addMenu(QIcon,QString)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QMenu * cpp_result = cppSelf->QMenu::addMenu(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QMenu * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMenu* cpp_arg0 = Shiboken::Converter<QMenu* >::toCpp(pyargs[0]);
        // addMenu(QMenu*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QMenu::addMenu(cpp_arg0);
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], py_result);
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQMenuFunc_addMenu_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_addMenu_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMenu", "PySide.QtGui.QIcon, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu.addMenu", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_addSeparator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // addSeparator()
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QMenu::addSeparator();
    py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    cppSelf->QMenu::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMenuFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMenu::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_defaultAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultAction()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QMenu::defaultAction();
    py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_enterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // enterEvent(QEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::enterEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_enterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_enterEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.enterEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMenu::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.event", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_exec_(PyObject* self, PyObject* args)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "exec_", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 0) {
        // exec()
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QAction * cpp_result = cppSelf->QMenu::exec();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // exec(QPoint,QAction*)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            QAction * cpp_result = cppSelf->QMenu::exec(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QAction * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QAction* cpp_arg1 = Shiboken::Converter<QAction* >::toCpp(pyargs[1]);
            // exec(QPoint,QAction*)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            QAction * cpp_result = cppSelf->QMenu::exec(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQMenuFunc_exec__TypeError;
    } else if (Shiboken::Converter<QList<QAction * > >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        QList<QAction * > cpp_arg0 = Shiboken::Converter<QList<QAction * > >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // exec(QList<QAction*>,QPoint,QAction*)
            thread_state_saver.save();
            QAction * cpp_result = QMenu::exec(cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QAction * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QAction* cpp_arg2 = Shiboken::Converter<QAction* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // exec(QList<QAction*>,QPoint,QAction*)
                thread_state_saver.save();
                QAction * cpp_result = QMenu::exec(cpp_arg0, *cpp_arg1, cpp_arg2);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (numArgs == 4 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QWidget* cpp_arg3 = Shiboken::Converter<QWidget* >::toCpp(pyargs[3]);
                // exec(QList<QAction*>,QPoint,QAction*,QWidget*)
                thread_state_saver.save();
                QAction * cpp_result = QMenu::exec(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQMenuFunc_exec__TypeError;
        } else goto SbkQMenuFunc_exec__TypeError;
    } else goto SbkQMenuFunc_exec__TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_exec__TypeError:
        const char* overloads[] = {"", "list, PySide.QtCore.QPoint, PySide.QtGui.QAction = None", "list, PySide.QtCore.QPoint, PySide.QtGui.QAction, PySide.QtGui.QWidget", "PySide.QtCore.QPoint, PySide.QtGui.QAction = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu.exec_", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMenu::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.focusNextPrevChild", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_hideTearOffMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // hideTearOffMenu()
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    cppSelf->QMenu::hideTearOffMenu();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMenuFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QMenu::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_insertMenu(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertMenu", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAction * >::isConvertible(pyargs[0]) && Shiboken::Converter<QMenu * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QMenu* cpp_arg1 = Shiboken::Converter<QMenu* >::toCpp(pyargs[1]);
        // insertMenu(QAction*,QMenu*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QMenu::insertMenu(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], py_result);
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQMenuFunc_insertMenu_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_insertMenu_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction, PySide.QtGui.QMenu", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu.insertMenu", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_insertSeparator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // insertSeparator(QAction*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QMenu::insertSeparator(cpp_arg0);
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQMenuFunc_insertSeparator_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMenuFunc_insertSeparator_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.insertSeparator", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMenu::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_isTearOffEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTearOffEnabled()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMenu::isTearOffEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_isTearOffMenuVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTearOffMenuVisible()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMenu::isTearOffMenuVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_leaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // leaveEvent(QEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::leaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_leaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_leaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.leaveEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_menuAction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menuAction()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QAction * cpp_result = cppSelf->QMenu::menuAction();
    py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_popup(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "popup", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // popup(QPoint,QAction*)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            cppSelf->QMenu::popup(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QAction * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QAction* cpp_arg1 = Shiboken::Converter<QAction* >::toCpp(pyargs[1]);
            // popup(QPoint,QAction*)
            QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
            cppSelf->QMenu::popup(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQMenuFunc_popup_TypeError;
    } else goto SbkQMenuFunc_popup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_popup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtGui.QAction = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMenu.popup", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_separatorsCollapsible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // separatorsCollapsible()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMenu::separatorsCollapsible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_setActiveAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // setActiveAction(QAction*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setActiveAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setActiveAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setActiveAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setActiveAction", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_setDefaultAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAction* cpp_arg0 = Shiboken::Converter<QAction* >::toCpp(arg);
        // setDefaultAction(QAction*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setDefaultAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setDefaultAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setDefaultAction_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setDefaultAction", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!SbkQIcon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setIcon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setIcon", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_setSeparatorsCollapsible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSeparatorsCollapsible(bool)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setSeparatorsCollapsible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setSeparatorsCollapsible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setSeparatorsCollapsible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setSeparatorsCollapsible", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_setTearOffEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTearOffEnabled(bool)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setTearOffEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setTearOffEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setTearOffEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setTearOffEnabled", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_setTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setTitle(QString)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::setTitle(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_setTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_setTitle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.setTitle", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMenu::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::timerEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.timerEvent", overloads);
        return 0;
}

static PyObject* SbkQMenuFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMenu::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMenuFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QMenu* cppSelf = Shiboken::Converter<QMenu* >::toCpp((PyObject*)self);
        cppSelf->QMenu::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMenuFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMenuFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMenu.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQMenuMethod_exec_ = {
    "exec_", (PyCFunction)SbkQMenuFunc_exec_, METH_VARARGS|METH_STATIC
};

static PyMethodDef SbkQMenu_methods[] = {
    {"actionAt", (PyCFunction)SbkQMenuFunc_actionAt, METH_O},
    {"actionEvent", (PyCFunction)SbkQMenuFunc_actionEvent, METH_O},
    {"actionGeometry", (PyCFunction)SbkQMenuFunc_actionGeometry, METH_O},
    {"activeAction", (PyCFunction)SbkQMenuFunc_activeAction, METH_NOARGS},
    {"addAction", (PyCFunction)SbkQMenuFunc_addAction, METH_VARARGS},
    {"addMenu", (PyCFunction)SbkQMenuFunc_addMenu, METH_VARARGS},
    {"addSeparator", (PyCFunction)SbkQMenuFunc_addSeparator, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQMenuFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQMenuFunc_clear, METH_NOARGS},
    {"columnCount", (PyCFunction)SbkQMenuFunc_columnCount, METH_NOARGS},
    {"defaultAction", (PyCFunction)SbkQMenuFunc_defaultAction, METH_NOARGS},
    {"enterEvent", (PyCFunction)SbkQMenuFunc_enterEvent, METH_O},
    {"event", (PyCFunction)SbkQMenuFunc_event, METH_O},
    SbkQMenuMethod_exec_,
    {"focusNextPrevChild", (PyCFunction)SbkQMenuFunc_focusNextPrevChild, METH_O},
    {"hideEvent", (PyCFunction)SbkQMenuFunc_hideEvent, METH_O},
    {"hideTearOffMenu", (PyCFunction)SbkQMenuFunc_hideTearOffMenu, METH_NOARGS},
    {"icon", (PyCFunction)SbkQMenuFunc_icon, METH_NOARGS},
    {"insertMenu", (PyCFunction)SbkQMenuFunc_insertMenu, METH_VARARGS},
    {"insertSeparator", (PyCFunction)SbkQMenuFunc_insertSeparator, METH_O},
    {"isEmpty", (PyCFunction)SbkQMenuFunc_isEmpty, METH_NOARGS},
    {"isTearOffEnabled", (PyCFunction)SbkQMenuFunc_isTearOffEnabled, METH_NOARGS},
    {"isTearOffMenuVisible", (PyCFunction)SbkQMenuFunc_isTearOffMenuVisible, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQMenuFunc_keyPressEvent, METH_O},
    {"leaveEvent", (PyCFunction)SbkQMenuFunc_leaveEvent, METH_O},
    {"menuAction", (PyCFunction)SbkQMenuFunc_menuAction, METH_NOARGS},
    {"mouseMoveEvent", (PyCFunction)SbkQMenuFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQMenuFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQMenuFunc_mouseReleaseEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQMenuFunc_paintEvent, METH_O},
    {"popup", (PyCFunction)SbkQMenuFunc_popup, METH_VARARGS},
    {"separatorsCollapsible", (PyCFunction)SbkQMenuFunc_separatorsCollapsible, METH_NOARGS},
    {"setActiveAction", (PyCFunction)SbkQMenuFunc_setActiveAction, METH_O},
    {"setDefaultAction", (PyCFunction)SbkQMenuFunc_setDefaultAction, METH_O},
    {"setIcon", (PyCFunction)SbkQMenuFunc_setIcon, METH_O},
    {"setSeparatorsCollapsible", (PyCFunction)SbkQMenuFunc_setSeparatorsCollapsible, METH_O},
    {"setTearOffEnabled", (PyCFunction)SbkQMenuFunc_setTearOffEnabled, METH_O},
    {"setTitle", (PyCFunction)SbkQMenuFunc_setTitle, METH_O},
    {"sizeHint", (PyCFunction)SbkQMenuFunc_sizeHint, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQMenuFunc_timerEvent, METH_O},
    {"title", (PyCFunction)SbkQMenuFunc_title, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQMenuFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQMenu_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "exec_") == 0)
            return PyCFunction_NewEx(&SbkQMenuMethod_exec_, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

extern "C"
{

static void* SbkQMenuSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QMenu* me = reinterpret_cast<QMenu*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMenu_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMenu",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQMenu_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMenu_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMenu_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQMenuSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMenu >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QMenu(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMENU_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMenu_Type);

    SbkQMenu_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQMenu_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQMenu_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMenu_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMenu_Type));
    PyModule_AddObject(module, "QMenu",
        ((PyObject*)&SbkQMenu_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMenu >("QMenu*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMenu >(typeid(QMenu).name());
}


} // extern "C"

