/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qdesktopservices_wrapper.h"

// Extra includes
#include <qobject.h>
#include <qstring.h>
#include <qurl.h>

using namespace Shiboken;

static int
SbkQDesktopServices_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDesktopServices* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QDesktopServices()
    cptr = new QDesktopServices();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDesktopServices >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQDesktopServicesFunc_displayName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QDesktopServices::StandardLocation >::isConvertible(arg)) {
        QDesktopServices::StandardLocation cpp_arg0 = Shiboken::Converter<QDesktopServices::StandardLocation >::toCpp(arg);
        // displayName(QDesktopServices::StandardLocation)
        QString cpp_result = QDesktopServices::displayName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDesktopServicesFunc_displayName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDesktopServicesFunc_displayName_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDesktopServices.StandardLocation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDesktopServices.displayName", overloads);
        return 0;
}

static PyObject* SbkQDesktopServicesFunc_openUrl(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // openUrl(QUrl)
        bool cpp_result = QDesktopServices::openUrl(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDesktopServicesFunc_openUrl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDesktopServicesFunc_openUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDesktopServices.openUrl", overloads);
        return 0;
}

static PyObject* SbkQDesktopServicesFunc_setUrlHandler(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setUrlHandler", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        // setUrlHandler(QString,QObject*,const char*)
        QDesktopServices::setUrlHandler(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDesktopServicesFunc_setUrlHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDesktopServicesFunc_setUrlHandler_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QObject, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDesktopServices.setUrlHandler", overloads);
        return 0;
}

static PyObject* SbkQDesktopServicesFunc_storageLocation(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QDesktopServices::StandardLocation >::isConvertible(arg)) {
        QDesktopServices::StandardLocation cpp_arg0 = Shiboken::Converter<QDesktopServices::StandardLocation >::toCpp(arg);
        // storageLocation(QDesktopServices::StandardLocation)
        QString cpp_result = QDesktopServices::storageLocation(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDesktopServicesFunc_storageLocation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDesktopServicesFunc_storageLocation_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDesktopServices.StandardLocation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDesktopServices.storageLocation", overloads);
        return 0;
}

static PyObject* SbkQDesktopServicesFunc_unsetUrlHandler(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // unsetUrlHandler(QString)
        QDesktopServices::unsetUrlHandler(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDesktopServicesFunc_unsetUrlHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDesktopServicesFunc_unsetUrlHandler_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDesktopServices.unsetUrlHandler", overloads);
        return 0;
}

static PyMethodDef SbkQDesktopServices_methods[] = {
    {"displayName", (PyCFunction)SbkQDesktopServicesFunc_displayName, METH_O|METH_STATIC},
    {"openUrl", (PyCFunction)SbkQDesktopServicesFunc_openUrl, METH_O|METH_STATIC},
    {"setUrlHandler", (PyCFunction)SbkQDesktopServicesFunc_setUrlHandler, METH_VARARGS|METH_STATIC},
    {"storageLocation", (PyCFunction)SbkQDesktopServicesFunc_storageLocation, METH_O|METH_STATIC},
    {"unsetUrlHandler", (PyCFunction)SbkQDesktopServicesFunc_unsetUrlHandler, METH_O|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDesktopServices_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDesktopServices",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDesktopServices_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDesktopServices_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDesktopServices >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QDesktopServices_StandardLocation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDesktopServices_StandardLocation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDesktopServices_StandardLocation_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardLocation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDesktopServices_StandardLocation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDesktopServices_StandardLocation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDesktopServices_StandardLocation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QDesktopServices(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDesktopServices_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDesktopServices_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDesktopServices_Type));
    PyModule_AddObject(module, "QDesktopServices",
        ((PyObject*)&SbkQDesktopServices_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StandardLocation
    SbkPySide_QtGuiTypes[SBK_QDESKTOPSERVICES_STANDARDLOCATION_IDX] = &SbkPySide_QtGui_QDesktopServices_StandardLocation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type);
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
            "StandardLocation",((PyObject*)&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::DesktopLocation, "DesktopLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "DesktopLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "DesktopLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::DocumentsLocation, "DocumentsLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "DocumentsLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "DocumentsLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::FontsLocation, "FontsLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "FontsLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "FontsLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::ApplicationsLocation, "ApplicationsLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "ApplicationsLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "ApplicationsLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::MusicLocation, "MusicLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "MusicLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "MusicLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::MoviesLocation, "MoviesLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "MoviesLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "MoviesLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::PicturesLocation, "PicturesLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "PicturesLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "PicturesLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::TempLocation, "TempLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "TempLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "TempLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::HomeLocation, "HomeLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "HomeLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "HomeLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::DataLocation, "DataLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "DataLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "DataLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDesktopServices_StandardLocation_Type,
        (long) QDesktopServices::CacheLocation, "CacheLocation");
    PyDict_SetItemString(SbkQDesktopServices_Type.super.ht_type.tp_dict,
        "CacheLocation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDesktopServices_StandardLocation_Type.tp_dict,
        "CacheLocation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDesktopServices::StandardLocation");

    Shiboken::TypeResolver::createObjectTypeResolver<QDesktopServices >("QDesktopServices*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDesktopServices >(typeid(QDesktopServices).name());
}


} // extern "C"

