/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qvariantanimation_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <QVector>
#include <qanimationgroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qeasingcurve.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qvariantanimation.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QVariantAnimationWrapper::QVariantAnimationWrapper(QObject * parent) : QVariantAnimation(parent), m_metaObject(0) {
    // ... middle
}

void QVariantAnimationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QVariantAnimationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QVariantAnimationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QVariantAnimationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QVariantAnimationWrapper::duration() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "duration"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::duration();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVariantAnimation.duration", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QVariantAnimationWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVariantAnimation.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QVariantAnimationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVariantAnimation.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QVariant QVariantAnimationWrapper::interpolated(const QVariant & from, const QVariant & to, qreal progress) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "interpolated"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::interpolated(from, to, progress);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSd)",
        Shiboken::Converter<QVariant & >::toPython(from),
        Shiboken::Converter<QVariant & >::toPython(to),
        Shiboken::Converter<double >::toPython(progress)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVariantAnimation.interpolated", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QVariantAnimationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QVariantAnimationWrapper::updateCurrentTime(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentTime"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::updateCurrentTime(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QVariantAnimationWrapper::updateCurrentValue(const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVariantAnimation.updateCurrentValue()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QVariantAnimationWrapper::updateDirection(QAbstractAnimation::Direction direction)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateDirection"));
    if (py_override.isNull()) {
        return this->QAbstractAnimation::updateDirection(direction);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractAnimation::Direction >::toPython(direction)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QVariantAnimationWrapper::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateState"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::updateState(newState, oldState);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QAbstractAnimation::State >::toPython(newState),
        Shiboken::Converter<QAbstractAnimation::State >::toPython(oldState)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QVariantAnimationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QVariantAnimation::staticMetaObject);
}
    return m_metaObject;
}

int QVariantAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QVariantAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QVariantAnimationWrapper::~QVariantAnimationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQVariantAnimation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QVariantAnimationWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QVARIANTANIMATION_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QVariantAnimation' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QVariantAnimation", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QVariantAnimation(QObject*)
        cptr = new QVariantAnimationWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QVariantAnimation(QObject*)
        cptr = new QVariantAnimationWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQVariantAnimation_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QVariantAnimation >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQVariantAnimation_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQVariantAnimation_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QVariantAnimation", overloads);
        return -1;
}

static PyObject* SbkQVariantAnimationFunc_currentValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentValue()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QVariantAnimation::currentValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_duration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duration()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVariantAnimation::duration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_easingCurve(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // easingCurve()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    QEasingCurve cpp_result = cppSelf->QVariantAnimation::easingCurve();
    py_result = Shiboken::Converter<QEasingCurve >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_endValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endValue()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QVariantAnimation::endValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QVariantAnimation::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVariantAnimationFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.event", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_interpolated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "interpolated", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QVariant & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // interpolated(QVariant,QVariant,qreal)const
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QVariantAnimation::interpolated(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_interpolated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVariantAnimationFunc_interpolated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, PySide.QtCore.QVariant, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QVariantAnimation.interpolated", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_keyValueAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // keyValueAt(qreal)const
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QVariantAnimation::keyValueAt(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_keyValueAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVariantAnimationFunc_keyValueAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.keyValueAt", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_keyValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyValues()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    QVector<QPair<qreal, QVariant > > cpp_result = cppSelf->QVariantAnimation::keyValues();
    py_result = Shiboken::Converter<QVector<QPair<qreal, QVariant > > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_setDuration(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDuration(int)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setDuration(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setDuration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setDuration_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.setDuration", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_setEasingCurve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEasingCurve & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QEasingCurve > cpp_arg0_auto_ptr;
        QEasingCurve* cpp_arg0 = Shiboken::Converter<QEasingCurve* >::toCpp(arg);
        if (!SbkQEasingCurve_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QEasingCurve >(cpp_arg0);
        // setEasingCurve(QEasingCurve)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setEasingCurve(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setEasingCurve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setEasingCurve_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEasingCurve", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.setEasingCurve", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_setEndValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setEndValue(QVariant)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setEndValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setEndValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setEndValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.setEndValue", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_setKeyValueAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setKeyValueAt", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setKeyValueAt(qreal,QVariant)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setKeyValueAt(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setKeyValueAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setKeyValueAt_TypeError:
        const char* overloads[] = {"float, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QVariantAnimation.setKeyValueAt", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_setKeyValues(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QPair<qreal, QVariant > >  >::isConvertible(arg)) {
        QVector<QPair<qreal, QVariant > >  cpp_arg0 = Shiboken::Converter<QVector<QPair<qreal, QVariant > >  >::toCpp(arg);
        // setKeyValues(QVector<QPair<qreal,QVariant> >)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setKeyValues(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setKeyValues_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setKeyValues_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.setKeyValues", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_setStartValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setStartValue(QVariant)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::setStartValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_setStartValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_setStartValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.setStartValue", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_startValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startValue()const
    QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QVariantAnimation::startValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVariantAnimationFunc_updateCurrentTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // updateCurrentTime(int)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::updateCurrentTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_updateCurrentTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_updateCurrentTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.updateCurrentTime", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_updateCurrentValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // updateCurrentValue(QVariant)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVariantAnimation.updateCurrentValue()' not implemented.");
            return 0;
        }
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->updateCurrentValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_updateCurrentValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_updateCurrentValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QVariantAnimation.updateCurrentValue", overloads);
        return 0;
}

static PyObject* SbkQVariantAnimationFunc_updateState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "updateState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[1])) {
        QAbstractAnimation::State cpp_arg0 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[0]);
        QAbstractAnimation::State cpp_arg1 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[1]);
        // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
        QVariantAnimation* cppSelf = Shiboken::Converter<QVariantAnimation* >::toCpp((PyObject*)self);
        cppSelf->QVariantAnimation::updateState(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVariantAnimationFunc_updateState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVariantAnimationFunc_updateState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.State, PySide.QtCore.QAbstractAnimation.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QVariantAnimation.updateState", overloads);
        return 0;
}

static PyMethodDef SbkQVariantAnimation_methods[] = {
    {"currentValue", (PyCFunction)SbkQVariantAnimationFunc_currentValue, METH_NOARGS},
    {"duration", (PyCFunction)SbkQVariantAnimationFunc_duration, METH_NOARGS},
    {"easingCurve", (PyCFunction)SbkQVariantAnimationFunc_easingCurve, METH_NOARGS},
    {"endValue", (PyCFunction)SbkQVariantAnimationFunc_endValue, METH_NOARGS},
    {"event", (PyCFunction)SbkQVariantAnimationFunc_event, METH_O},
    {"interpolated", (PyCFunction)SbkQVariantAnimationFunc_interpolated, METH_VARARGS},
    {"keyValueAt", (PyCFunction)SbkQVariantAnimationFunc_keyValueAt, METH_O},
    {"keyValues", (PyCFunction)SbkQVariantAnimationFunc_keyValues, METH_NOARGS},
    {"setDuration", (PyCFunction)SbkQVariantAnimationFunc_setDuration, METH_O},
    {"setEasingCurve", (PyCFunction)SbkQVariantAnimationFunc_setEasingCurve, METH_O},
    {"setEndValue", (PyCFunction)SbkQVariantAnimationFunc_setEndValue, METH_O},
    {"setKeyValueAt", (PyCFunction)SbkQVariantAnimationFunc_setKeyValueAt, METH_VARARGS},
    {"setKeyValues", (PyCFunction)SbkQVariantAnimationFunc_setKeyValues, METH_O},
    {"setStartValue", (PyCFunction)SbkQVariantAnimationFunc_setStartValue, METH_O},
    {"startValue", (PyCFunction)SbkQVariantAnimationFunc_startValue, METH_NOARGS},
    {"updateCurrentTime", (PyCFunction)SbkQVariantAnimationFunc_updateCurrentTime, METH_O},
    {"updateCurrentValue", (PyCFunction)SbkQVariantAnimationFunc_updateCurrentValue, METH_O},
    {"updateState", (PyCFunction)SbkQVariantAnimationFunc_updateState, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQVariantAnimation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QVariantAnimation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQVariantAnimation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQVariantAnimation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QVariantAnimation >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QVariantAnimation(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QVARIANTANIMATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQVariantAnimation_Type);

    SbkQVariantAnimation_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTANIMATION_IDX];
    // Fill type discovery information
    SbkQVariantAnimation_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQVariantAnimation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQVariantAnimation_Type));
    PyModule_AddObject(module, "QVariantAnimation",
        ((PyObject*)&SbkQVariantAnimation_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QVariantAnimation >("QVariantAnimation*");
    Shiboken::TypeResolver::createObjectTypeResolver<QVariantAnimation >(typeid(QVariantAnimation).name());
}


} // extern "C"

