/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qtimer_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qtimer.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTimerWrapper::QTimerWrapper(QObject * parent) : QTimer(parent), m_metaObject(0) {
    // ... middle
}

void QTimerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTimerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTimerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTimerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTimerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTimer.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTimerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTimer.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTimerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTimer::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTimerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTimer::staticMetaObject);
}
    return m_metaObject;
}

int QTimerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTimer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTimerWrapper::~QTimerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTimer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTimerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTimer", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTimer(QObject*)
        cptr = new QTimerWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QTimer(QObject*)
        cptr = new QTimerWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTimer_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTimer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTimer_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTimer_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTimer", overloads);
        return -1;
}

static PyObject* SbkQTimerFunc_interval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // interval()const
    QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimer::interval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimerFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTimer::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimerFunc_isSingleShot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSingleShot()const
    QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTimer::isSingleShot();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTimerFunc_setInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setInterval(int)
        QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
        cppSelf->QTimer::setInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimerFunc_setInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimerFunc_setInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimer.setInterval", overloads);
        return 0;
}

static PyObject* SbkQTimerFunc_setSingleShot(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSingleShot(bool)
        QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
        cppSelf->QTimer::setSingleShot(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimerFunc_setSingleShot_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimerFunc_setSingleShot_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimer.setSingleShot", overloads);
        return 0;
}

static PyObject* SbkQTimerFunc_singleShot(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "singleShot", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && Shiboken::Converter<QObject * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
            // singleShot(int,QObject*,const char*)
            // Begin code injection
            
            // singleShot() - disable generation of c++ function call
            Shiboken::AutoDecRef emptyTuple(PyTuple_New(0));
            PyObject* pyTimer = Shiboken::SbkType<QTimer>()->tp_new(Shiboken::SbkType<QTimer>(), emptyTuple, 0);
            Shiboken::SbkType<QTimer>()->tp_init(pyTimer, emptyTuple, 0);
            
            QTimer* timer = Converter<QTimer*>::toCpp(pyTimer);
            PyObject* result = PyObject_CallMethod(pyTimer, const_cast<char*>("connect"), const_cast<char*>("OsOs"), pyTimer, SIGNAL(timeout()), pyargs[2-1], cpp_arg2);
            Py_DECREF(result);
            timer->setSingleShot(true);
            timer->connect(timer, SIGNAL("timeout()"), timer, SLOT("deleteLater()"));
            timer->start(cpp_arg0);
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyCallable_Check(pyargs[1])) {
            // singleShot(int,PyCallable*)
            // Begin code injection
            
            // singleShot() - disable generation of c++ function call
            Shiboken::AutoDecRef emptyTuple(PyTuple_New(0));
            PyObject* pyTimer = Shiboken::SbkType<QTimer>()->tp_new(Shiboken::SbkType<QTimer>(), emptyTuple, 0);
            Shiboken::SbkType<QTimer>()->tp_init(pyTimer, emptyTuple, 0);
            QTimer* timer = Converter<QTimer*>::toCpp(pyTimer);
            timer->setSingleShot(true);
            timer->connect(timer, SIGNAL(timeout()), timer, SLOT(deleteLater()));
            PyObject* result = PyObject_CallMethod(pyTimer, const_cast<char*>("connect"), const_cast<char*>("OsO"), pyTimer, SIGNAL(timeout()), pyargs[1]);
            Py_DECREF(result);
            timer->start(cpp_arg0);
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQTimerFunc_singleShot_TypeError;
    } else goto SbkQTimerFunc_singleShot_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimerFunc_singleShot_TypeError:
        const char* overloads[] = {"int, PyCallable", "int, PySide.QtCore.QObject, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTimer.singleShot", overloads);
        return 0;
}

static PyObject* SbkQTimerFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start()
        QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
        cppSelf->QTimer::start();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // start(int)
        QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
        cppSelf->QTimer::start(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimerFunc_start_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimerFunc_start_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimer.start", overloads);
        return 0;
}

static PyObject* SbkQTimerFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
    cppSelf->QTimer::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTimerFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
        cppSelf->QTimer::timerEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTimerFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTimerFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTimer.timerEvent", overloads);
        return 0;
}

static PyObject* SbkQTimerFunc_timerId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // timerId()const
    QTimer* cppSelf = Shiboken::Converter<QTimer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTimer::timerId();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTimer_methods[] = {
    {"interval", (PyCFunction)SbkQTimerFunc_interval, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQTimerFunc_isActive, METH_NOARGS},
    {"isSingleShot", (PyCFunction)SbkQTimerFunc_isSingleShot, METH_NOARGS},
    {"setInterval", (PyCFunction)SbkQTimerFunc_setInterval, METH_O},
    {"setSingleShot", (PyCFunction)SbkQTimerFunc_setSingleShot, METH_O},
    {"singleShot", (PyCFunction)SbkQTimerFunc_singleShot, METH_VARARGS|METH_STATIC},
    {"start", (PyCFunction)SbkQTimerFunc_start, METH_NOARGS|METH_O},
    {"stop", (PyCFunction)SbkQTimerFunc_stop, METH_NOARGS},
    {"timerEvent", (PyCFunction)SbkQTimerFunc_timerEvent, METH_O},
    {"timerId", (PyCFunction)SbkQTimerFunc_timerId, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTimer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTimer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTimer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTimer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTimer >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTimer(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTIMER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTimer_Type);

    SbkQTimer_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQTimer_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTimer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTimer_Type));
    PyModule_AddObject(module, "QTimer",
        ((PyObject*)&SbkQTimer_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTimer >("QTimer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTimer >(typeid(QTimer).name());
}


} // extern "C"

