/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtextencoder_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qstring.h>
#include <qtextcodec.h>

using namespace Shiboken;

static int
SbkQTextEncoder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextEncoder* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextEncoder", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTextCodec * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(pyargs[0]);
        // QTextEncoder(const QTextCodec*)
        cptr = new QTextEncoder(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextEncoder_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextEncoder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextEncoder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextEncoder_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTextEncoder", overloads);
        return -1;
}

static PyObject* SbkQTextEncoderFunc_fromUnicode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromUnicode(QString)
        QTextEncoder* cppSelf = Shiboken::Converter<QTextEncoder* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QTextEncoder::fromUnicode(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextEncoderFunc_fromUnicode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextEncoderFunc_fromUnicode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextEncoder.fromUnicode", overloads);
        return 0;
}

static PyObject* SbkQTextEncoderFunc_hasFailure(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFailure()const
    QTextEncoder* cppSelf = Shiboken::Converter<QTextEncoder* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextEncoder::hasFailure();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextEncoder_methods[] = {
    {"fromUnicode", (PyCFunction)SbkQTextEncoderFunc_fromUnicode, METH_O},
    {"hasFailure", (PyCFunction)SbkQTextEncoderFunc_hasFailure, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextEncoder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTextEncoder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextEncoder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextEncoder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextEncoder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextEncoder(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTEXTENCODER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextEncoder_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextEncoder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextEncoder_Type));
    PyModule_AddObject(module, "QTextEncoder",
        ((PyObject*)&SbkQTextEncoder_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTextEncoder >("QTextEncoder*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextEncoder >(typeid(QTextEncoder).name());
}


} // extern "C"

