/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsystemlocale_wrapper.h"

// Extra includes
#include <qlocale.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSystemLocaleWrapper::QSystemLocaleWrapper() : QSystemLocale() {
    // ... middle
}

QLocale QSystemLocaleWrapper::fallbackLocale() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fallbackLocale"));
    if (py_override.isNull()) {
        return this->QSystemLocale::fallbackLocale();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QLocale();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLocale >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemLocale.fallbackLocale", SbkType<QLocale >()->tp_name, py_result->ob_type->tp_name);
        return QLocale();
    }
    QLocale cpp_result(Shiboken::Converter<QLocale >::toCpp(py_result));
    return cpp_result;
}

QVariant QSystemLocaleWrapper::query(QSystemLocale::QueryType type, QVariant in) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "query"));
    if (py_override.isNull()) {
        return this->QSystemLocale::query(type, in);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QSystemLocale::QueryType >::toPython(type),
        Shiboken::Converter<QVariant >::toPython(in)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemLocale.query", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QSystemLocaleWrapper::~QSystemLocaleWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQSystemLocale_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSystemLocaleWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QSystemLocale()
    cptr = new QSystemLocaleWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSystemLocale >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQSystemLocaleFunc_fallbackLocale(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fallbackLocale()const
    QSystemLocale* cppSelf = Shiboken::Converter<QSystemLocale* >::toCpp((PyObject*)self);
    QLocale cpp_result = cppSelf->QSystemLocale::fallbackLocale();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSystemLocaleFunc_query(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "query", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QSystemLocale::QueryType >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1])) {
        QSystemLocale::QueryType cpp_arg0 = Shiboken::Converter<QSystemLocale::QueryType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // query(QSystemLocale::QueryType,QVariant)const
        QSystemLocale* cppSelf = Shiboken::Converter<QSystemLocale* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QSystemLocale::query(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSystemLocaleFunc_query_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSystemLocaleFunc_query_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSystemLocale.QueryType, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSystemLocale.query", overloads);
        return 0;
}

static PyMethodDef SbkQSystemLocale_methods[] = {
    {"fallbackLocale", (PyCFunction)SbkQSystemLocaleFunc_fallbackLocale, METH_NOARGS},
    {"query", (PyCFunction)SbkQSystemLocaleFunc_query, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSystemLocale_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSystemLocale",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSystemLocale_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSystemLocale_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSystemLocale >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQSystemLocale_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQSystemLocale_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QSystemLocale*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtCore_QSystemLocale_QueryType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSystemLocale_QueryType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSystemLocale_QueryType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QueryType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSystemLocale_QueryType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSystemLocale_QueryType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QSystemLocale_QueryType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QSystemLocale(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSystemLocale_Type);

    // Fill type discovery information
    SbkQSystemLocale_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQSystemLocale_Type.type_discovery->addTypeDiscoveryFunction(&SbkQSystemLocale_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQSystemLocale_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSystemLocale_Type));
    PyModule_AddObject(module, "QSystemLocale",
        ((PyObject*)&SbkQSystemLocale_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: QueryType
    SbkPySide_QtCoreTypes[SBK_QSYSTEMLOCALE_QUERYTYPE_IDX] = &SbkPySide_QtCore_QSystemLocale_QueryType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSystemLocale_QueryType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSystemLocale_QueryType_Type);
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
            "QueryType",((PyObject*)&SbkPySide_QtCore_QSystemLocale_QueryType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::LanguageId, "LanguageId");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "LanguageId", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "LanguageId", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::CountryId, "CountryId");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "CountryId", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "CountryId", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DecimalPoint, "DecimalPoint");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DecimalPoint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DecimalPoint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::GroupSeparator, "GroupSeparator");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "GroupSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "GroupSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::ZeroDigit, "ZeroDigit");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "ZeroDigit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "ZeroDigit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::NegativeSign, "NegativeSign");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "NegativeSign", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "NegativeSign", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateFormatLong, "DateFormatLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateFormatLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateFormatLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateFormatShort, "DateFormatShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateFormatShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateFormatShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::TimeFormatLong, "TimeFormatLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "TimeFormatLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "TimeFormatLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::TimeFormatShort, "TimeFormatShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "TimeFormatShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "TimeFormatShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DayNameLong, "DayNameLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DayNameLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DayNameLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DayNameShort, "DayNameShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DayNameShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DayNameShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::MonthNameLong, "MonthNameLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "MonthNameLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "MonthNameLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::MonthNameShort, "MonthNameShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "MonthNameShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "MonthNameShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateToStringLong, "DateToStringLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateToStringLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateToStringLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateToStringShort, "DateToStringShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateToStringShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateToStringShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::TimeToStringLong, "TimeToStringLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "TimeToStringLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "TimeToStringLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::TimeToStringShort, "TimeToStringShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "TimeToStringShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "TimeToStringShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateTimeFormatLong, "DateTimeFormatLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateTimeFormatLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateTimeFormatLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateTimeFormatShort, "DateTimeFormatShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateTimeFormatShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateTimeFormatShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateTimeToStringLong, "DateTimeToStringLong");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateTimeToStringLong", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateTimeToStringLong", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::DateTimeToStringShort, "DateTimeToStringShort");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "DateTimeToStringShort", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "DateTimeToStringShort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::MeasurementSystem, "MeasurementSystem");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "MeasurementSystem", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "MeasurementSystem", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::PositiveSign, "PositiveSign");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "PositiveSign", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "PositiveSign", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::AMText, "AMText");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "AMText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "AMText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSystemLocale_QueryType_Type,
        (long) QSystemLocale::PMText, "PMText");
    PyDict_SetItemString(SbkQSystemLocale_Type.super.ht_type.tp_dict,
        "PMText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSystemLocale_QueryType_Type.tp_dict,
        "PMText", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSystemLocale::QueryType");

    Shiboken::TypeResolver::createObjectTypeResolver<QSystemLocale >("QSystemLocale*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSystemLocale >(typeid(QSystemLocale).name());
}


} // extern "C"

