/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qcryptographichash_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qcryptographichash.h>

using namespace Shiboken;

static int
SbkQCryptographicHash_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCryptographicHash* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QCryptographicHash", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QCryptographicHash::Algorithm >::isConvertible(pyargs[0])) {
        QCryptographicHash::Algorithm cpp_arg0 = Shiboken::Converter<QCryptographicHash::Algorithm >::toCpp(pyargs[0]);
        // QCryptographicHash(QCryptographicHash::Algorithm)
        cptr = new QCryptographicHash(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCryptographicHash_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QCryptographicHash >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQCryptographicHash_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQCryptographicHash_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QCryptographicHash.Algorithm", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCryptographicHash", overloads);
        return -1;
}

static PyObject* SbkQCryptographicHashFunc_addData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // addData(QByteArray)
        QCryptographicHash* cppSelf = Shiboken::Converter<QCryptographicHash* >::toCpp((PyObject*)self);
        cppSelf->QCryptographicHash::addData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCryptographicHashFunc_addData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCryptographicHashFunc_addData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCryptographicHash.addData", overloads);
        return 0;
}

static PyObject* SbkQCryptographicHashFunc_hash(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hash", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<QCryptographicHash::Algorithm >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        QCryptographicHash::Algorithm cpp_arg1 = Shiboken::Converter<QCryptographicHash::Algorithm >::toCpp(pyargs[1]);
        // hash(QByteArray,QCryptographicHash::Algorithm)
        QByteArray cpp_result = QCryptographicHash::hash(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCryptographicHashFunc_hash_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCryptographicHashFunc_hash_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QCryptographicHash.Algorithm", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCryptographicHash.hash", overloads);
        return 0;
}

static PyObject* SbkQCryptographicHashFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QCryptographicHash* cppSelf = Shiboken::Converter<QCryptographicHash* >::toCpp((PyObject*)self);
    cppSelf->QCryptographicHash::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQCryptographicHashFunc_result(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // result()const
    QCryptographicHash* cppSelf = Shiboken::Converter<QCryptographicHash* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QCryptographicHash::result();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQCryptographicHash_methods[] = {
    {"addData", (PyCFunction)SbkQCryptographicHashFunc_addData, METH_O},
    {"hash", (PyCFunction)SbkQCryptographicHashFunc_hash, METH_VARARGS|METH_STATIC},
    {"reset", (PyCFunction)SbkQCryptographicHashFunc_reset, METH_NOARGS},
    {"result", (PyCFunction)SbkQCryptographicHashFunc_result, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCryptographicHash_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QCryptographicHash",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCryptographicHash_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCryptographicHash_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QCryptographicHash >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QCryptographicHash_Algorithm_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QCryptographicHash_Algorithm_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QCryptographicHash_Algorithm_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Algorithm",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QCryptographicHash_Algorithm_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QCryptographicHash_Algorithm_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QCryptographicHash_Algorithm_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QCryptographicHash(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCryptographicHash_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQCryptographicHash_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCryptographicHash_Type));
    PyModule_AddObject(module, "QCryptographicHash",
        ((PyObject*)&SbkQCryptographicHash_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Algorithm
    SbkPySide_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX] = &SbkPySide_QtCore_QCryptographicHash_Algorithm_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type);
    PyDict_SetItemString(SbkQCryptographicHash_Type.super.ht_type.tp_dict,
            "Algorithm",((PyObject*)&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type,
        (long) QCryptographicHash::Md4, "Md4");
    PyDict_SetItemString(SbkQCryptographicHash_Type.super.ht_type.tp_dict,
        "Md4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCryptographicHash_Algorithm_Type.tp_dict,
        "Md4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type,
        (long) QCryptographicHash::Md5, "Md5");
    PyDict_SetItemString(SbkQCryptographicHash_Type.super.ht_type.tp_dict,
        "Md5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCryptographicHash_Algorithm_Type.tp_dict,
        "Md5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCryptographicHash_Algorithm_Type,
        (long) QCryptographicHash::Sha1, "Sha1");
    PyDict_SetItemString(SbkQCryptographicHash_Type.super.ht_type.tp_dict,
        "Sha1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCryptographicHash_Algorithm_Type.tp_dict,
        "Sha1", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCryptographicHash::Algorithm");

    Shiboken::TypeResolver::createObjectTypeResolver<QCryptographicHash >("QCryptographicHash*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCryptographicHash >(typeid(QCryptographicHash).name());
}


} // extern "C"

