# -*- coding: UTF8 -*-
import gtk
import hildon
import gobject
import pyrecipe_utils
import gettext
from portrait import FremantleRotation

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
ui_edit = gtk.HILDON_UI_MODE_EDIT
thsize = gtk.HILDON_SIZE_THUMB_HEIGHT
autosize = gtk.HILDON_SIZE_AUTO_HEIGHT

class ShopGui():
    def __init__(self, imagesdir, ings):
        self.window = hildon.Window()

        FremantleRotation("Pyrecipe", self.window, '0.3', 0)

        self.window.set_default_size(800, 480)
        self.window.set_title(_('Shopping List'))
        self.window.connect("delete-event", self.hide_window)
        #screen = gtk.gdk.screen_get_default()
        #screen.connect("size-changed", self.orientation_changed)

        menu = hildon.AppMenu()
        button = gtk.Button(_("Open"))
        button.connect("clicked", self.open_shopping_list)
        menu.append(button)

        button = gtk.Button(_("Save"))
        button.connect("clicked", self.save_shopping_list)
        menu.append(button)

        button = hildon.CheckButton(fhsize)
        button.set_label(_("Move items"))
        button.connect("toggled", self.move_items)
        menu.append(button)

        menu.show_all()
        self.window.set_app_menu(menu)

        portrait = self.is_portrait()

        vbox = gtk.VBox()

        if portrait:
            hildon.hildon_gtk_window_set_portrait_flags(self.window,
                                                hildon.PORTRAIT_MODE_REQUEST)

        parea = hildon.PannableArea()
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)

        # create tree model
        self.shoplist_model = self.create_shop_list_model(ings)
        self.shoplist_tv = hildon.GtkTreeView(ui_edit)
        self.shoplist_tv.set_model(self.shoplist_model)

        # add columns to the tree view
        self.add_columns_to_shop_list(self.shoplist_tv)

        parea.add(self.shoplist_tv)

        vbox.pack_start(parea, True, True, 0)

        hbox = gtk.HBox()
        hbox.set_homogeneous(True)

        self.toolbox = gtk.HBox()
        self.toolbox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'add.png')
        button.set_image(img)
        button.connect('clicked', self.show_add_item_dlg, "", "", "", False,
                        False, "")
        self.toolbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'edit.png')
        button.set_image(img)
        button.connect('clicked', self.edit_one_item)
        self.toolbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'delete.png')
        button.set_image(img)
        button.connect('clicked', self.remove_item)
        self.toolbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'clear.png')
        button.set_image(img)
        button.connect('clicked', self.clear_shoplist)
        self.toolbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'mark.png')
        button.set_image(img)
        button.connect('clicked', self.mark_item_as_bought)
        self.toolbox.pack_start(button, True, True, 0)

        self.movebox = gtk.HBox()
        self.movebox.set_homogeneous(True)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.image_new_from_icon_name("rss_reader_move_up",
                                            gtk.ICON_SIZE_SMALL_TOOLBAR)
        button.set_image(img)
        button.connect('clicked', self.move_up)
        self.movebox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        img = gtk.image_new_from_icon_name("rss_reader_move_down",
                                            gtk.ICON_SIZE_SMALL_TOOLBAR)
        button.set_image(img)
        button.connect('clicked', self.move_down)
        self.movebox.pack_start(button, True, True, 0)

        hbox.pack_start(self.toolbox, True, True, 0)
        hbox.pack_start(self.movebox, True, True, 0)

        vbox.pack_start(hbox, False, False, 0)

        self.window.add(vbox)
        self.window.show_all()
        self.movebox.hide()

    def move_items(self, button):
        if button.get_active():
            self.movebox.show()
            self.toolbox.hide()
        else:
            self.movebox.hide()
            self.toolbox.show()

    def move_up(self, widget):
        selection = self.shoplist_tv.get_selection()
        model, (path,) = selection.get_selected_rows()
        seliter = model.get_iter(path)
        try:
            previter = model.get_iter((path[0]-1,))
            self.shoplist_model.swap(seliter, previter)
        except:
            pass

    def move_down(self, widget):
        selection = self.shoplist_tv.get_selection()
        selmodel, seliter = selection.get_selected()
        nextiter = selmodel.iter_next(seliter)
        try:
            self.shoplist_model.swap(seliter, nextiter)
        except:
            pass


    def is_portrait(self):
        width = gtk.gdk.screen_width()
        height = gtk.gdk.screen_height()
        if width > height:
            return False
        else:
            return True

    #Show the window if it's hidden.
    def show(self):
        self.window.show()
        self.window.present()
        return True

    #Hide the window, when closing it
    def hide_window(self, widget, event=None):
        self.window.hide()
        return True

    def create_shop_list_model(self, ings):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,
                                gobject.TYPE_STRING, 'gboolean')

        for item in ings:
            lstore_iter = lstore.append()
            lstore.set(lstore_iter, 0, item[0], 1, item[1], 2, item[2], 3, item[3])

        return lstore

    def add_columns_to_shop_list(self, treeview):
        model = treeview.get_model()

        # column for shopping items
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        renderer.set_property('wrap-mode',gtk.WRAP_WORD)
        renderer.set_property('wrap-width', 450)
        column = gtk.TreeViewColumn('Item', renderer, text=2, strikethrough=3)
        column.set_property("expand", True)
        treeview.append_column(column)

        # column for amount
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        column = gtk.TreeViewColumn('Amount', renderer, text=0, strikethrough=3)
        treeview.append_column(column)

        # column for unit
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        column = gtk.TreeViewColumn('Unit', renderer, text=1, strikethrough=3)
        #column.set_property("expand", True)
        treeview.append_column(column)


    def show_add_item_dlg(self, widget, amount, unit, item, mark, edit, seliter):
        if edit:
            label = _("Edit item")
        else:
            label = _("Add item")

        dlg = gtk.Dialog(title=label, parent=None, flags=0)
        dlg.set_has_separator(False)

        self.ening = hildon.Entry(fhsize)
        self.ening.connect("activate", self.on_add_ingredient, dlg, edit,
                            seliter, mark)
        self.ening.set_placeholder(_("Item"))
        self.ening.set_text(item)
        dlg.vbox.pack_start(self.ening, False, False, 0)

        self.enamount = hildon.Entry(fhsize)
        self.enamount.connect("activate", self.on_add_ingredient, dlg, edit,
                            seliter, mark)
        self.enamount.set_placeholder(_("Amount"))
        self.enamount.set_text(amount)
        dlg.vbox.pack_start(self.enamount, False, False, 0)

        self.unit_btn = hildon.PickerButton(fhsize, horbtn)
        data = ["", _("box"), _("can"), _("bucket"), _("bushel"), "cl", "dl", _("clove"),
                _("dram"), _("drop"), "fl oz", "gallon", _("grains"), "g", "kg", _("large"),
                "l", _("medium"), "mg", "ml", "oz", _("peck"), "pt", _("package"), "lb",
                "qt", _("slices"), _("small"), "Tbs", "tsp", _("whole")]
        selector = self.create_selector(data, True)
        self.unit_btn.set_selector(selector)
        self.unit_btn.set_title(_("Unit"))
        self.unit_btn.set_value(unit)

        dlg.vbox.pack_start(self.unit_btn, False, False, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label(label)
        button.connect("clicked", self.on_add_ingredient, dlg, edit, seliter, mark)
        dlg.vbox.pack_start(button, False, False, 0)

        dlg.show_all()
        dlg.run()
        dlg.destroy()

    def on_add_ingredient(self, widget, dlg, edit, seliter, mark):
        ing = self.ening.get_text()

        if ing == '':
            return

        unit = self.unit_btn.get_value()
        amount = self.enamount.get_text()
        dlg.destroy()

        item = [amount, unit, ing, mark]

        if edit:
            self.shoplist_model.set(seliter, 0, item[0], 1, item[1],
                                    2, item[2], 3, item[3])
        else:
            newiter = self.shoplist_model.append()
            self.shoplist_model.set(newiter, 0, item[0], 1, item[1],
                                    2, item[2], 3, item[3])

    def edit_one_item(self, widget):
        selection = self.shoplist_tv.get_selection()
        selmodel, seliter = selection.get_selected()

        if seliter:
             amount = self.shoplist_model.get_value(seliter, 0)
             unit = self.shoplist_model.get_value(seliter, 1)
             item = self.shoplist_model.get_value(seliter, 2)
             mark = self.shoplist_model.get_value(seliter, 3)
        else:
            self.show_info_banner(widget, _('No selected item'))
            return

        self.show_add_item_dlg(widget, amount, unit, item, mark, True, seliter)


    #Remove item from the shopping list
    def remove_item(self, widget):
        selection = self.shoplist_tv.get_selection()
        select_model, select_iter = selection.get_selected()

        if not select_iter:
            self.show_info_banner(widget, _('No selected item'))
            return
        else:
            conf = pyrecipe_utils.light_confirmation(self.window,
                                                _("Delete item?"), _('Delete'))
            if conf:
                select_model.remove(select_iter)

    #Clear completely the shopping list
    def clear_shoplist(self, widget):
        conf = pyrecipe_utils.light_confirmation(self.window,
                                            _("Clear shopping list?"), _("Clear"))
        if conf:
            self.shoplist_model.clear()

    #Mark or unmark a shopped item.
    def mark_item_as_bought(self, widget):
        selection = self.shoplist_tv.get_selection()
        select_model, select_iter = selection.get_selected()

        if select_iter:
            item = self.shoplist_model.get_value(select_iter, 2)
            amount = self.shoplist_model.get_value(select_iter, 0)
            unit = self.shoplist_model.get_value(select_iter, 1)
            marked = self.shoplist_model.get_value(select_iter, 3)

            if marked == True:
                self.shoplist_model.set(select_iter, 0, amount, 1, unit,
                                        2, item, 3, False)
            else:
                self.shoplist_model.set(select_iter, 0, amount, 1, unit,
                                        2, item, 3, True)

        else:
            self.show_info_banner(widget, _('No selected item'))

            return

    #Open a saved shopping list
    def open_shopping_list(self, widget):
        filename = pyrecipe_utils.show_filechooser_dialog(self.window, "open",
                    _("Open shopping list"), "", "", "")
        if filename == None:
            return

        shop_list = self.xml_load_from_file(filename)

        print 'shoplist: ', shop_list

        if shop_list == False:
            self.show_info_banner(widget, _('Error opening the shopping list'))

        self.shoplist_model.clear()
        for item in shop_list:
            model_iter = self.shoplist_model.append()
            if item[3] == 'False':
                self.shoplist_model.set(model_iter, 0, item[0], 1, item[1],
                                        2, item[2], 3, False)
            else:
                self.shoplist_model.set(model_iter, 0, item[0], 1, item[1],
                                        2, item[2], 3, True)

    #Save a shopping list in a file
    def save_shopping_list(self, widget):
        import datetime
        date_today = datetime.date.today()
        name = 'shoplist-' + date_today.isoformat()
        filename = pyrecipe_utils.show_filechooser_dialog(self.window, "save",
                    _("Save shopping list"), name, "", "shpl")
        if filename == None:
            return

        ing_list = []
        for i in range(len(self.shoplist_model)):
            item = self.shoplist_model[i][2]
            amount = self.shoplist_model[i][0]
            unit = self.shoplist_model[i][1]
            marked  = self.shoplist_model[i][3]
            lista = (amount, unit, item, str(marked))
            ing_list.append(lista)

        xml_document = self.create_xml(ing_list)

        success = pyrecipe_utils.save_xml_file(filename, xml_document)

        if success == True:
            self.show_info_banner(widget, _('Shopping list saved'))
        else:
            self.show_info_banner(widget, _('Error ocurred while saving the file'))

    #Create the xml document for the shopping list saved
    def create_xml(self, ing_list):
        from lxml import etree
        root  = etree.Element("pyrecipe")
        shop = etree.SubElement(root, "shopping-list")

        for i in range(len(ing_list)):
            item = etree.SubElement(shop, "item")

            amount = etree.SubElement(item, "amount")
            amount.text = ing_list[i][0]

            unit = etree.SubElement(item, "unit")
            unit.text = ing_list[i][1]

            title = etree.SubElement(item, "title")
            title.text = ing_list[i][2]

            marked = etree.SubElement(item, "marked")
            marked.text = ing_list[i][3]

        xml_document = (etree.tostring(root, pretty_print=True))

        return xml_document

    #Load the xml for the saved shopping list
    #<shopping-list>
    #<item>
    #<amount>1 l</amount>
    #<title>milk</title>
    #<marked>False</marked>
    #</item>
    #</shopping-list>
    def xml_load(self, xml_document):
        from lxml import etree
        shop_list = []
        root = etree.XML(xml_document)
        for i in root.getchildren()[0]:
            amount = i.getchildren()[0].text
            if not amount:
                amount = ''

            unit = i.getchildren()[1].text
            if not unit:
                unit = ''

            title = i.getchildren()[2].text
            if not title:
                title = ''

            marked = i.getchildren()[3].text
            if not marked:
                marked = 'False'
            shop_list.append([amount, unit, title, marked])


        print shop_list #[[u'1/2', u'box', u'test 2', u'False'], [u'12', u'lb', u'test1', u'False']]
        return shop_list

    #Get the xml document from a file.
    def xml_load_from_file(self, namefile):
        shoplist = False
        try:
            file_object = open(namefile, "r")
            xmlfile = file_object.read()
            file_object.close()
            shoplist = self.xml_load(xmlfile)
        except IOError, (errno, strerror):
            print "Error loading shoplist file(%s): %s" % (errno, strerror)
        except:
            print "Error loading shoplist file."
        return shoplist

    def create_selector(self, data, entry):
        if entry:
            selector = hildon.TouchSelectorEntry(text=True)
        else:
            selector = hildon.TouchSelector(text=True)

        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)
