# -*- coding: UTF8 -*-
import gtk
import hildon
import gobject
import pyrecipe_utils

fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
ui_edit = gtk.HILDON_UI_MODE_EDIT
thsize = gtk.HILDON_SIZE_THUMB_HEIGHT
autosize = gtk.HILDON_SIZE_AUTO_HEIGHT

class ShopGui():
    def __init__(self, imagesdir, ings):
        self.window = hildon.Window()
        hildon.hildon_gtk_window_set_portrait_flags(self.window,
                                                hildon.PORTRAIT_MODE_SUPPORT)
        self.window.set_default_size(800, 480)
        self.window.set_title('Pyrecipe - Shopping List')
        self.window.connect("delete-event", self.hide_window)
        screen = gtk.gdk.screen_get_default()
        screen.connect("size-changed", self.orientation_changed)

        menu = hildon.AppMenu()
        button = gtk.Button("Open")
        button.connect("clicked", self.open_shopping_list)
        menu.append(button)

        button = gtk.Button("Save")
        button.connect("clicked", self.save_shopping_list)
        menu.append(button)

        menu.show_all()
        self.window.set_app_menu(menu)

        portrait = self.is_portrait()

        if portrait:
            hbox = gtk.VBox()
            hildon.hildon_gtk_window_set_portrait_flags(self.window,
                                                hildon.PORTRAIT_MODE_REQUEST)
        else:
            hbox = gtk.HBox()

        parea = hildon.PannableArea()
        parea.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)

        # create tree model
        self.shoplist_model = self.create_shop_list_model(ings)
        self.shoplist_tv = hildon.GtkTreeView(ui_edit)
        self.shoplist_tv.set_model(self.shoplist_model)

        # add columns to the tree view
        self.add_columns_to_shop_list(self.shoplist_tv)

        parea.add(self.shoplist_tv)

        hbox.pack_start(parea, True, True, 0)

        if portrait:
            vbox = gtk.HBox()
        else:
            vbox = gtk.VBox()

        vbox.set_homogeneous(True)

        button = hildon.Button(autosize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'add.png')
        button.set_image(img)
        button.connect('clicked', self.show_add_item_dlg, "", "", "", False,
                        False, "")
        vbox.pack_start(button, True, True, 0)

        button = hildon.Button(autosize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'edit.png')
        button.set_image(img)
        button.connect('clicked', self.edit_one_item)
        vbox.pack_start(button, True, True, 0)

        button = hildon.Button(autosize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'remove.png')
        button.set_image(img)
        button.connect('clicked', self.remove_item)
        vbox.pack_start(button, True, True, 0)

        button = hildon.Button(autosize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'clear.png')
        button.set_image(img)
        button.connect('clicked', self.clear_shoplist)
        vbox.pack_start(button, True, True, 0)

        button = hildon.Button(autosize, horbtn)
        img = gtk.Image()
        img.set_from_file(imagesdir + 'mark.png')
        button.set_image(img)
        button.connect('clicked', self.mark_item_as_bought)
        vbox.pack_start(button, True, True, 0)

        hbox.pack_start(vbox, False, False, 0)

        self.window.add(hbox)
        self.window.show_all()

    def orientation_changed(self, widget):
        print 'orientation changed'

    def is_portrait(self):
        width = gtk.gdk.screen_width()
        height = gtk.gdk.screen_height()
        if width > height:
            return False
        else:
            return True

    #Show the window if it's hidden.
    def show(self):
        self.window.show()
        self.window.present()
        return True

    #Hide the window, when closing it
    def hide_window(self, widget, event=None):
        self.window.hide()
        return True

    def create_shop_list_model(self, ings):
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING,
                                gobject.TYPE_STRING, 'gboolean')

        for item in ings:
            lstore_iter = lstore.append()
            lstore.set(lstore_iter, 0, item[0], 1, item[1], 2, item[2], 3, item[3])

        return lstore

    def add_columns_to_shop_list(self, treeview):
        model = treeview.get_model()

        # column for shopping items
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        renderer.set_property('wrap-mode',gtk.WRAP_WORD)
        renderer.set_property('wrap-width', 450)
        column = gtk.TreeViewColumn('Item', renderer, text=2, strikethrough=3)
        column.set_property("expand", True)
        treeview.append_column(column)

        # column for amount
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        column = gtk.TreeViewColumn('Amount', renderer, text=0, strikethrough=3)
        treeview.append_column(column)

        # column for unit
        renderer = gtk.CellRendererText()
        renderer.set_property('strikethrough', False)
        column = gtk.TreeViewColumn('Unit', renderer, text=1, strikethrough=3)
        #column.set_property("expand", True)
        treeview.append_column(column)


    def show_add_item_dlg(self, widget, amount, unit, item, mark, edit, seliter):
        if edit:
            label = "Edit item"
        else:
            label = "Add item"

        dlg = gtk.Dialog(title=label, parent=None, flags=0)
        dlg.set_has_separator(False)

        self.ening = hildon.Entry(fhsize)
        self.ening.set_placeholder("Item")
        self.ening.set_text(item)
        dlg.vbox.pack_start(self.ening, False, False, 0)

        self.enamount = hildon.Entry(fhsize)
        self.enamount.set_placeholder("Amount")
        self.enamount.set_text(amount)
        dlg.vbox.pack_start(self.enamount, False, False, 0)

        self.unit_btn = hildon.PickerButton(fhsize, horbtn)
        data = ["", "box", "can", "bucket", "bushel", "cl", "dl", "clove",
                "dram", "drop", "fl oz", "gallon", "grains", "g", "kg", "large",
                "l", "medium", "mg", "ml", "oz", "peck", "pt", "package", "lb",
                "qt", "slices", "small", "Tbs", "tsp", "whole"]
        selector = self.create_selector(data, True)
        self.unit_btn.set_selector(selector)
        self.unit_btn.set_title("Unit")
        self.unit_btn.set_value(unit)

        dlg.vbox.pack_start(self.unit_btn, False, False, 0)

        button = hildon.Button(fhsize, horbtn)
        button.set_label(label)
        button.connect("clicked", self.on_add_ingredient, dlg, edit, seliter, mark)
        dlg.vbox.pack_start(button, False, False, 0)

        dlg.show_all()
        dlg.run()
        dlg.destroy()

    def on_add_ingredient(self, widget, dlg, edit, seliter, mark):
        ing = self.ening.get_text()

        if ing == '':
            return

        unit = self.unit_btn.get_value()
        amount = self.enamount.get_text()
        dlg.destroy()

        item = [amount, unit, ing, mark]

        if edit:
            self.shoplist_model.set(seliter, 0, item[0], 1, item[1],
                                    2, item[2], 3, item[3])
        else:
            newiter = self.shoplist_model.append()
            self.shoplist_model.set(newiter, 0, item[0], 1, item[1],
                                    2, item[2], 3, item[3])

    def edit_one_item(self, widget):
        selection = self.shoplist_tv.get_selection()
        selmodel, seliter = selection.get_selected()

        if seliter:
             amount = self.shoplist_model.get_value(seliter, 0)
             unit = self.shoplist_model.get_value(seliter, 1)
             item = self.shoplist_model.get_value(seliter, 2)
             mark = self.shoplist_model.get_value(seliter, 3)
        else:
            self.show_info_banner(widget, 'No selected item')
            return

        self.show_add_item_dlg(widget, amount, unit, item, mark, True, seliter)


    #Remove item from the shopping list
    def remove_item(self, widget):
        selection = self.shoplist_tv.get_selection()
        select_model, select_iter = selection.get_selected()

        if not select_iter:
            self.show_info_banner(widget, 'No selected item')
            return
        else:
            conf = pyrecipe_utils.on_confirmation(self.window, "Delete item?")
            if conf:
                select_model.remove(select_iter)

    #Clear completely the shopping list
    def clear_shoplist(self, widget):
        conf = pyrecipe_utils.on_confirmation(self.window, "Clear shopping list?")
        if conf:
            self.shoplist_model.clear()

    #Mark or unmark a shopped item.
    def mark_item_as_bought(self, widget):
        selection = self.shoplist_tv.get_selection()
        select_model, select_iter = selection.get_selected()

        if select_iter:
            item = self.shoplist_model.get_value(select_iter, 2)
            amount = self.shoplist_model.get_value(select_iter, 0)
            unit = self.shoplist_model.get_value(select_iter, 1)
            marked = self.shoplist_model.get_value(select_iter, 3)

            if marked == True:
                self.shoplist_model.set(select_iter, 0, amount, 1, unit,
                                        2, item, 3, False)
            else:
                self.shoplist_model.set(select_iter, 0, amount, 1, unit,
                                        2, item, 3, True)

        else:
            self.show_info_banner(widget, 'No selected item')

            return

    #Open a saved shopping list
    def open_shopping_list(self, widget):
        filename = pyrecipe_utils.show_filechooser_dialog(self.window, "open",
                    "Open shopping list", "", "", "")
        if filename == None:
            return

        shop_list = self.xml_load_from_file(filename)

        if shop_list == False:
            self.show_info_banner(widget, 'Error opening the shopping list')

        self.shoplist_model.clear()
        for item in shop_list:
            model_iter = self.shoplist_model.append()
            if item[3] == 'False':
                self.shoplist_model.set(model_iter, 0, item[0], 1, item[1],
                                        2, item[2], 3, False)
            else:
                self.shoplist_model.set(model_iter, 0, item[0], 1, item[1],
                                        2, item[2], 3, True)

    #Save a shopping list in a file
    def save_shopping_list(self, widget):
        import datetime
        date_today = datetime.date.today()
        name = 'shoplist-' + date_today.isoformat()
        filename = pyrecipe_utils.show_filechooser_dialog(self.window, "save",
                    "Save shopping list", name, "", "shpl")
        if filename == None:
            return

        ing_list = []
        for i in range(len(self.shoplist_model)):
            item = self.shoplist_model[i][2]
            amount = self.shoplist_model[i][0]
            unit = self.shoplist_model[i][1]
            marked  = self.shoplist_model[i][3]
            lista = (amount, unit, item, str(marked))
            ing_list.append(lista)

        xml_document = self.create_xml(ing_list)

        success = pyrecipe_utils.save_xml_file(filename, xml_document)

        if success == True:
            self.show_info_banner(widget, 'Shopping list saved')
        else:
            self.show_info_banner(widget, 'Error ocurred while saving the file')

    #Create the xml document for the shopping list saved
    def create_xml(self, ing_list):
        from xml.dom import minidom
        impl = minidom.getDOMImplementation()
        xml_document = impl.createDocument(None, 'pyrecipe', None)

        list_element = xml_document.createElement('shopping-list')

        for i in range(len(ing_list)):
            item_element = xml_document.createElement('item')

            amount_element = xml_document.createElement('amount')
            amount_element.appendChild(xml_document.createTextNode(ing_list[i][0]))

            unit_element = xml_document.createElement('unit')
            unit_element.appendChild(xml_document.createTextNode(ing_list[i][1]))

            title_element = xml_document.createElement('title')
            title_element.appendChild(xml_document.createTextNode(ing_list[i][2]))

            marked_element = xml_document.createElement('marked')
            marked_element.appendChild(xml_document.createTextNode(ing_list[i][3]))

            item_element.appendChild(amount_element)
            item_element.appendChild(unit_element)
            item_element.appendChild(title_element)
            item_element.appendChild(marked_element)

            list_element.appendChild(item_element)

        xml_document.documentElement.appendChild(list_element)

        return xml_document

    #Load the xml for the saved shopping list
    #<shopping-list>
    #<item>
    #<amount>1 l</amount>
    #<title>milk</title>
    #<marked>False</marked>
    #</item>
    #</shopping-list>
    def xml_load(self, xml_document):
        shop_list = []
        for node in xml_document.documentElement.childNodes:
            if (node.nodeName == 'shopping-list'):
                for item_node in node.childNodes:
                    if (item_node.nodeName == 'item'):
                        for i in item_node.childNodes:
                            if (i.nodeName == 'amount'):
                                amount = i.firstChild.nodeValue
                            if (i.nodeName == 'unit'):
                                unit = i.firstChild.nodeValue
                            elif (i.nodeName == 'title'):
                                title = i.firstChild.nodeValue
                            elif (i.nodeName == 'marked'):
                                marked = i.firstChild.nodeValue
                                shop_list.append([amount, unit, title, marked])
        return shop_list

    #Get the xml document from a file.
    def xml_load_from_file(self, namefile):
        from xml.dom import minidom
        success = False
        try:
            xml_document = minidom.parse(namefile)
            if (xml_document):
                success = ((self.xml_load(xml_document)))
        except IOError, (errno, strerror):
            print "Error loading post file(%s): %s" % (errno, strerror)
        except:
            print "Error loading post file."
        return success

    def create_selector(self, data, entry):
        if entry:
            selector = hildon.TouchSelectorEntry(text=True)
        else:
            selector = hildon.TouchSelector(text=True)

        for i in range(len(data)):
            selector.append_text(data[i])

        return selector

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)
