/*
 * This file is part of pwsafe
 *
 * Copyright (C) 2005 Nokia Corporation.
 * Copyright (C) 2005 HolisTech Limited.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <src/interface.h>
#include <src/preferences.h>
#include <gtk/gtk.h>
#include <src/appdata.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* file-> new/open/save */
void callback_file_new ( GtkAction * action, MainView *mainview );
void callback_file_open ( GtkAction * action, MainView *mainview );
void callback_file_open_last ( GtkAction * action, MainView *mainview );
void callback_file_close ( GtkAction * action, MainView *mainview );
void callback_file_save ( GtkAction * action, MainView *mainview );
void callback_file_saveas ( GtkAction * action, MainView *mainview );
/* item/change password */
void callback_add_entry ( GtkAction * action, MainView *mainview );
void callback_change_password( GtkAction * action, MainView *mainview );
/* fullscreen */
void callback_fullscreen ( GtkAction * action, gpointer data );
/* filter */
void callback_filter(GtkWidget *widget, MainView *mainview );
/* export */
void callback_export ( GtkAction * action, MainView *mainview );
void callback_import_xml(GtkAction * action, MainView *mainview );
/* grid activated */
void callback_hildon_activate_treeView(GtkTreeView *treeView, GtkTreePath *path, MainView *mainview);
void callback_activate_treeView(GtkTreeView *treeView, GtkTreePath *path, GtkTreeViewColumn *column, MainView *mainview);
/* record details button */
void callback_rec_response(GtkDialog *dialog, gint arg1, MainView *mainview);
/* hardware events */
void hw_event_handler(osso_hw_state_t *state, MainView *mainview);
gboolean callback_key_press(GtkWidget* widget, GdkEventKey* event,  MainView *mainview);
gboolean callback_tree_key_pressed(GtkTreeView *treeView, GdkEventKey *event, MainView *mainview);

gboolean exit_event_handler( GtkWidget *widget, GdkEvent  *event, MainView *mainview);

void callback_buffer_changed(GtkTextBuffer *buffer, MainView *mainview) ;
gboolean callback_tag_event(GtkTextTag *tag, GObject *object, GdkEvent *event, GtkTextIter *iter, MainView *mainview);
DBusHandlerResult dbus_handle_mce_message(DBusConnection *con, DBusMessage *msg, MainView *mainView);

void callback_pwdialog_changed(GtkWidget *widget, PasswordUI *pwUi) ;
void callback_pwdialog_activate(GtkWidget *widget, PasswordUI *pwUi);
void callback_pwdialog_button(GtkWidget *widget, PasswordUI *pwUI);
void callback_pwdialog_cancel(GtkWidget *widget, PasswordUI *pwUi);

#endif
