/*
 * This file is part of pwsafe
 *
 * Copyright (C) 2005 Nokia Corporation.
 * Copyright (C) 2005 HolisTech Limited.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef INTERFACE_H
#define INTERFACE_H

#include <gtk/gtk.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-app.h>
#endif

#include <mce/dbus-names.h>

#include <src/appdata.h>

#define _(String) gettext(String)

/* confirmation responses */
#define CONFRESP_YES 1
#define CONFRESP_NO 2
#define CONFRESP_OK 3
#define CONFRESP_CANCEL 4
#define CONFRESP_ERROR 5

/*Password Dialog Type */
#define PWD_DLG_GET 1
#define PWD_DLG_CHANGE 2
#define PWD_DLG_NEW 3

#define MAIN_VIEW_NAME ""

#define MCE_MATCH_RULE "type='signal',interface='" MCE_SIGNAL_IF "',member='" MCE_INACTIVITY_SIG "'"

typedef enum {
	PWSAFE_NO_ERROR = 0,
	PWSAFE_ERROR_OPEN_FAILED,
	PWSAFE_ERROR_SAVE_FAILED,
	PWSAFE_ERROR_BADPASS
} PwsafeError;

typedef enum {
	LABEL_COLUMN,
	ICON_COLUMN,
	DATA_COLUMN,
	N_COLUMNS
} PwsafeColumns;

typedef struct RecWindow {
	rec *rec;
	gboolean editable;
	GtkWidget *dialog;
	GtkWidget *title;
	GtkWidget *group;
	GtkWidget *username;
	GtkWidget *password;
	GtkWidget *notes;
	GtkWidget *delete_button;
	GtkWidget *edit_button;
} RecWindow;

typedef struct SearchGroup {
	rec *data;
	gboolean found;
} SearchGroup;

/* Struct to include view's information */
typedef struct _MainView MainView;
struct _MainView
{
	/* Handle to app's data */
	AppData *data;

	/* Fullscreen mode is on (TRUE) or off (FALSE) */
	gboolean fullscreen;

	/* Items for menu */
	GtkWidget *file_item;
	GtkWidget *new_item;
	GtkWidget *open_item;
	GtkWidget *open_last_item;
	GtkWidget *close_item;
	GtkWidget *save_item;
	GtkWidget *saveas_item;
    GtkWidget *export_item;
	GtkWidget *view_item;
	GtkWidget *add_item;
	GtkWidget *change_password;
	GtkWidget *fullscreen_item;

	/* Toolbar */
	GtkWidget* toolbar;
	GtkWidget* iconw;
	GtkToolItem* new_tb;
	GtkToolItem* open_tb;
	GtkToolItem* close_tb;
	GtkToolItem* save_tb;
	GtkToolItem* saveas_tb;
	GtkToolItem* separator_tb1;
	GtkToolItem* add_tb;
	GtkToolItem* change_password_tb;
	GtkToolItem* separator_tb2;
	GtkToolItem* fullscreen_tb;
    GtkToolItem* separator_tb3;
    GtkToolItem* filter_item_tb;
    GtkWidget* filter_tb;

	GtkWidget* mainwindow;

	GtkWidget* treeView;
	GtkTreeStore  *store;

	GtkClipboard* clipboard;	/* clipboard for copy/paste */
	PangoFontDescription* font_desc;
	gboolean file_edited;		/* tells is our file on view edited */
	gchar* file_name;
	gchar *last_file;
	gchar* pass;			/* must be stored to be able to write file again... */
	gchar *preferences;		/* preferences from the file... just written back out. */
	RecWindow* rec_win;		/*active recwindow object... one per app */
#if MAEMO_VERSION_MAJOR >= 5
	GRegex *regexHttp;
	GRegex *regexWww;
#endif
};

typedef struct PasswordUI {
	MainView *main;
	GtkWidget *dialog;
	GtkWidget *button;
	GtkWidget *entry1;
	GtkWidget *entry2;
	GtkWidget *entry3;
	gint type;
	gchar *result;
	gchar *msg;
} PasswordUI;

/* Publics: */
MainView* interface_main_view_new( AppData* data );
void interface_main_view_destroy( MainView* main );
char* interface_file_chooser( MainView* main, GtkFileChooserAction action );
PangoFontDescription* interface_font_chooser( MainView * main );
gint interface_yes_no_note(MainView * main, gchar *title);
void interface_error( PwsafeError me, MainView *main );
void msgbox(MainView* main, char *msg);
void populate_treeView (MainView *main);
void show_rec(MainView *main, rec *record);
void empty_treeView(MainView *main);
void unshow_rec(MainView *main);
gchar *get_password(MainView *main, gchar *caption, gint pwdDlgType);
void interface_show_state(MainView *main);
char *emptynull(char *a);
void interface_fullscreen(MainView *mainview);
void interface_set_rec_editable(RecWindow* rec_win, gboolean editable);
void interfaceCallLastItem(MainView *mainView) ;

#endif
