/**************************************************************************
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**   Special keywords: markus 8/8/2010 2010
**   Environment variables: %$VARIABLE%
**************************************************************************/

#ifndef RELEASEINFORMATION_HPP
#define RELEASEINFORMATION_HPP

#include <time.h>
#include <sys/time.h>
#include <cstdlib>
#include <stdio.h>

#include <QString>
#include <string>

class ReleaseInformation
{
public:
    ReleaseInformation();

    /*Package Version*/
    std::string getPackageVersion();
    QString getPackageVersionQ();

    /* Package Name */
    std::string getPackageName();
    QString getPackageNameQ();

    /* Package release/build date */
    std::string getPackageDate();
    QString getPackageDateQ();
    struct tm getPackageDateTm();

private:
    QString dateToString();

    QString packageVersion;
    QString packageName;
    struct tm packageDate;
};

#endif // RELEASEINFORMATION_HPP
