#include "proximityd.h"

static DBusObjectPathVTable tbl;


Client::Client(int pid_, int interval_):pid(pid_),interval(interval_)
{



}



ProximityDaemon* ProximityDaemon::me=NULL;


void ProximityDaemon::setInterval()	//setting interval for reading
{
	int iint;
	
	debug("Setting Interval");
	for (int i=0;i<pids.size();++i)
	{
		if (i==0)
			iint=pids[i]->interval;

		iint=std::min(iint,pids[i]->interval);
	}
	if (iint<50)
		iint=50;
	if (iint>2000)
		iint=2000;
	
	intervalUsec=1000*iint;
}



int ProximityDaemon::checkProcess()	//checking active processes
{
	toKeep.clear();
	counterCheck=0;

	DIR *dir_p;
	struct dirent *dir_entry_p;
	dir_p = opendir("/proc/"); 																
	while(NULL != (dir_entry_p = readdir(dir_p))) 
	{											
		if (strspn(dir_entry_p->d_name, "0123456789") == strlen(dir_entry_p->d_name)) 
		{		 
			int ppid = atoi(dir_entry_p->d_name);
			
			for (int i=0; i<pids.size(); ++i)
			{
				if (ppid==pids[i]->pid)
				{
					toKeep.push_back(new Client(ppid,pids[i]->interval));
					break;
				}
			}
		}
	} 
	pids.swap(toKeep);
	setInterval();
	
	if (pids.size()==0)
	{
		active=0;
		intervalUsec=INTERVAL_IDLE;
		debug("TURNED OFF");
	}	
	closedir(dir_p);
	return 0;

}


void ProximityDaemon::listen()
{

	{
		dbus_connection_read_write(connMth, 0);
      		msgMth = dbus_connection_pop_message(connMth);
		

		if (NULL != msgMth)
		{		
		 	if (dbus_message_is_method_call(msgMth, "proximityd.method.change", "Change"))
			{
				handleMethodCall(msgMth);
			}
		} 
      	}
}

void ProximityDaemon::changeInterval(int mInterval_, int pid_)	//getting minimum from the intervals
{

	for (int i=0;i<pids.size();++i)
	{
		if (pids[i]->pid==pid_)
		{
			pids[i]->interval=mInterval_;
			setInterval();
			return;
		}

	}

	
}


void ProximityDaemon::debug(const char* message)	//debug writing
{

	if (debugFlag==1)
	{
		std::cout<<"PROXIMITYD: "<<message<<std::endl;
	}

}


void ProximityDaemon::handleMethodCall(DBusMessage* msgMth_)
{

	debug("Handling Message");

	msgMth=msgMth_;
	bool stat = true;
	dbus_uint32_t serial = 0;
		
	intervalMth=0;
	
	if (!dbus_message_iter_init(msgMth, &argsMth))
		debug("Message has no arguments");
	else if (DBUS_TYPE_STRING != dbus_message_iter_get_arg_type(&argsMth))
		debug("Argument is not string");
	else
      		dbus_message_iter_get_basic(&argsMth, &paramMth);

	if (!dbus_message_iter_next(&argsMth))
		debug("Message has too few arguments");
	else if (DBUS_TYPE_INT32 != dbus_message_iter_get_arg_type(&argsMth))
		debug("Argument is not int");
	else
      		dbus_message_iter_get_basic(&argsMth, &paramMthPid);
	

	if (dbus_message_iter_next(&argsMth))
	{
		if (DBUS_TYPE_INT32==dbus_message_iter_get_arg_type(&argsMth))
			dbus_message_iter_get_basic(&argsMth, &intervalMth);
	}	
	
	
	if (strcmp(paramMth,"turnOff")==0 && paramMthPid!=0)
	{
		turnOff();

	} 

	else if (strcmp(paramMth,"turnOn")==0 && paramMthPid!=0)
	{
		turnOn();
	}

	else if (strcmp(paramMth,"changeInterval")==0 && paramMthPid!=0 && intervalMth!=0)
	{
		changeInterval(intervalMth, paramMthPid);
	}

	
	replyMth = dbus_message_new_method_return(msgMth);
		
	dbus_message_iter_init_append(replyMth, &argsMth);
	
	std::string rep = "ERROR";
		

	if (strcmp(paramMth,"turnOff")==0 && paramMthPid!=0)		  
	{
		rep = "turnedOff";
	}
	else 
	{

		if (intervalMth!=0)
			rep="intervalRegistered";
		else
			rep = "turnedOn";
	}

	if (!dbus_message_iter_append_basic(&argsMth, DBUS_TYPE_STRING, &rep)) 
	{
		debug("Out Of Memory");
		return;
	}
	
	if (!dbus_connection_send(connMth, replyMth, &serial)) 
	{
		debug("PROXIMITY: Out Of Memory");
      		return;
	}
	

}


void ProximityDaemon::turnOff()	//turning sensor off
{
	
	for (int i=0; i<pids.size();++i)
	{
		if (pids[i]->pid==paramMthPid)
		{
			pids.erase(pids.begin()+i);
			setInterval();
			break;
		}
	}

	if (pids.size()==0)
	{
		active=0;
		pthread_join(proxThread,NULL);
		intervalUsec=INTERVAL_IDLE;
		debug("TURNED OFF");
	}
	


}


void ProximityDaemon::turnOn()	//turning sensor on
{
	pids.push_back(new Client(paramMthPid,100));
	debug("PUSHED");
	setInterval();
	debug("INTERVAL SET");
	if (active==0)
	{
		active=1;
		pthread_create(&proxThread,NULL,&ProximityDaemon::readProx,NULL);
	}
	debug("TURNED ON");
}



void ProximityDaemon::connectToDbusMethod()
{

	dbus_error_init(&errMth);
	connMth = dbus_bus_get_private(DBUS_BUS_SESSION, &errMth);
	
	if (dbus_error_is_set(&errMth)) 
	{
		debug("Connection Error");
		dbus_error_free(&errMth);
	}
	if (NULL == connMth) 
	{
		debug("Connection Null");
		exit(1);
	}

	retMth = dbus_bus_request_name(connMth, "proximityd.method.change", DBUS_NAME_FLAG_REPLACE_EXISTING , &errMth);
	if (dbus_error_is_set(&errMth)) 
	{
		debug("Name Error");
		dbus_error_free(&errMth);
	}
	      
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retMth) 
	{
		debug("Not Primary Owner");
		exit(1);
	}
	      
	   
	


}

DBusHandlerResult ProximityDaemon::methodFilter (DBusConnection *connection, DBusMessage *message, void *user_data)
{
	me->methodFilterD(connection, message, user_data);

	me->handleMethodCall(message);
	
}


DBusHandlerResult ProximityDaemon::methodFilterD (DBusConnection *connection, DBusMessage *message, void *user_data)
{
	debug("HERE");
	char* s;
	dbus_error_init (&errMth);
	if (dbus_message_get_args(message, &errMth, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID))
	{
		debug(s);
		
	}
}	


ProximityDaemon::ProximityDaemon(int debugFlag_)
{

	debugFlag=debugFlag_;
	debug("Debug Mode ON");
	intervalUsec=INTERVAL_IDLE;
	active=0;
	currentState='n';

	file="/sys/devices/platform/gpio-switch/proximity/state";

	loop = g_main_loop_new (NULL, FALSE);
		
	me=this;
	
	connectToDbusSignal();
	connectToDbusMethod();
	
	dbus_connection_setup_with_g_main (connMth, NULL);
	dbus_bus_add_match (connMth, "type='method_call',interface='proximityd.method.change'",NULL);

	tbl.unregister_function = NULL;
	tbl.message_function = methodFilter;
	
	dbus_connection_register_object_path(connMth,"/proximityd/method/change",&tbl,NULL);
	
	pthread_create(&proxThread,NULL,&ProximityDaemon::readProx,NULL);
	
	g_main_loop_run (loop);
	
	
	counterCheck=0;
	
	
}

ProximityDaemon::~ProximityDaemon()
{

}

void* ProximityDaemon::readProx(void* object)
{
	me->readProxD();
}

void ProximityDaemon::readProxD()	//looped reading
{
	if (currentState=='n')
	{
		fp = fopen (file,"r") ;
		currentState = fgetc (fp); 
		fclose (fp);

	}

	  
	while(active)
	{
		debug("*");
	//	listen();
			++counterCheck;
			if (counterCheck==200)
				checkProcess();
	 		readSensor();
		usleep(intervalUsec);
	}


}


void ProximityDaemon::readSensor()	//single proxy reading
{


	fp = fopen (file,"r") ;
	char ch = fgetc (fp); 
	fclose (fp);
		
	if (ch=='c' && currentState=='o')
	{
		emitState('c');
		currentState=ch;
	}	
	else if (ch=='o' && currentState=='c')
	{
		emitState('o');
		currentState=ch;
	}

}


void ProximityDaemon::emitState(char newState_)	//emitting change signals
{
	
	const char* sigvalue;
	
	if (newState_=='c')
	{
		sigvalue="closed";
	}
	else 
	{
		 sigvalue="open";
	}
	
	msgSig = dbus_message_new_signal("/proximityd/signal/state", // object name of the signal
		      			"proximityd.signal.state", // interface name of the signal
					"changed"); // name of the signal


	if (NULL == msgSig)
	{
		debug("Message Null");
		return;
	}

	dbus_message_iter_init_append(msgSig, &argsSig);
	if (!dbus_message_iter_append_basic(&argsSig, DBUS_TYPE_STRING, &sigvalue)) 
	{
		debug("Out of Memory");
		return;
	}
	   

	if (!dbus_connection_send(connSig, msgSig, &serialSig)) 
	{	
		debug("Out of Memory");
		return;
	}
	   



}



void ProximityDaemon::connectToDbusSignal() //emitting change signals
{
	dbus_error_init(&errSig);
	connSig = dbus_bus_get_private(DBUS_BUS_SESSION, &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		debug("Connection error");
		dbus_error_free(&errSig);
	}
	
	if (NULL == connSig) 
	{
		exit(1);
	}

	retSig = dbus_bus_request_name(connSig, "proximity.signal.source", DBUS_NAME_FLAG_REPLACE_EXISTING , &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		debug("Name error");
		dbus_error_free(&errSig);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retSig) 
	{
		exit(1);
	}
	      
	



}



int main(int argc, char **argv)
{
	
	
	
	if (argc>1)
	{
		if (strcmp(argv[1],"db")==0)
		{
			
			ProximityDaemon* pd = new ProximityDaemon(1);
			
		}
		else 
			ProximityDaemon* pd = new ProximityDaemon(0);
	}
	else 
		ProximityDaemon* pd = new ProximityDaemon(0);
	

return 0;
}
