#include "proximityd.h"






ProximityDaemon::ProximityDaemon()
{

	intervalUsec=100000;
	active=1;
	currentState='n';

	file="/sys/devices/platform/gpio-switch/proximity/state";

	connectToDbusSignal();
	
	
	readProx();
}

ProximityDaemon::~ProximityDaemon()
{

}

void ProximityDaemon::readProx()
{
	if (currentState=='n')
	{
		fp = fopen (file,"r") ;
		currentState = fgetc (fp); 
		fclose (fp);

	}

	
	while(active)
	{
		readSensor();
		usleep(intervalUsec);
	}


}


void ProximityDaemon::readSensor()
{


	fp = fopen (file,"r") ;
	char ch = fgetc (fp); 
	fclose (fp);
		
	if (ch=='c' && currentState=='o')
	{
		emitState('c');
		currentState=ch;
	}	
	else if (ch=='o' && currentState=='c')
	{
		emitState('o');
		currentState=ch;
	}

}


void ProximityDaemon::emitState(char newState_)
{
	
	const char* sigvalue;
	
	if (newState_=='c')
	{
		sigvalue="closed";
	}
	else 
	{
		 sigvalue="open";
	}
	
	msgSig = dbus_message_new_signal("/proximityd/signal/state", // object name of the signal
		      			"proximityd.signal.state", // interface name of the signal
					"changed"); // name of the signal


	if (NULL == msgSig)
	{
		std::cout<<"PROXIMITY: Message Null"<<std::endl;
		return;
	}

	dbus_message_iter_init_append(msgSig, &argsSig);
	if (!dbus_message_iter_append_basic(&argsSig, DBUS_TYPE_STRING, &sigvalue)) 
	{
		std::cout<<"PROXIMITY: Out of Memory"<<std::endl;
		return;
	}
	   

	if (!dbus_connection_send(connSig, msgSig, &serialSig)) 
	{	
		std::cout<<"PROXIMITY: Out of Memory"<<std::endl;
		return;
	}
	   



}



void ProximityDaemon::connectToDbusSignal()
{
	dbus_error_init(&errSig);
	connSig = dbus_bus_get(DBUS_BUS_SESSION, &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		std::cout<<"PROXIMITY: Connection error"<<std::endl;
		dbus_error_free(&errSig);
	}
	
	if (NULL == connSig) 
	{
		exit(1);
	}

	retSig = dbus_bus_request_name(connSig, "proximity.signal.source", DBUS_NAME_FLAG_REPLACE_EXISTING , &errSig);
	
	if (dbus_error_is_set(&errSig)) 
	{
		std::cout<<"PROXIMITY: Name error"<<std::endl;
		dbus_error_free(&errSig);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retSig) 
	{
		exit(1);
	}
	      
	



}



int main(int argc, char **argv)
{
	ProximityDaemon* pd = new ProximityDaemon();
	


	

return 0;
}
