#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    ui->heightBox->setValue(QSettings().value("profilechangerwidget/height").toInt());
    ui->widthBox->setValue(QSettings().value("profilechangerwidget/width").toInt());
    QPushButton *aboutButton = new QPushButton(tr("About"), this);
    connect(aboutButton, SIGNAL(clicked()), this, SLOT(showAbout()));
    connect(this, SIGNAL(rejected()), this, SLOT(close()));
    ui->buttonBox->addButton(aboutButton, QDialogButtonBox::NoRole);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    if (ui->heightBox->text().isEmpty() || ui->widthBox->text().isEmpty()) {
        QMaemo5InformationBox::information(this, tr("Fields cannot be empty!"));
        return;
    }
    QSettings().setValue("profilechangerwidget/width", ui->widthBox->value());
    QSettings().setValue("profilechangerwidget/height", ui->heightBox->value());
    emit settingsChanged();
    this->close();
}

void SettingsDialog::showAbout()
{
    QDialog *aboutDialog = new QDialog(0);
    aboutDialog->setAttribute(Qt::WA_DeleteOnClose);
    aboutDialog->setWindowTitle(tr("About") + " " + "Profile Changer Widget");
    QLabel *aboutText = new QLabel(aboutDialog);
    QString about;
    about.append("Profile Changer Widget\nSmall widget intended to enable an easy change between general and silent profiles..");
    about.append("\n\n");
    about.append(QString::fromUtf8("© 2012 Harald Schmitt\n"));
    aboutText->setText(about);
    aboutText->setWordWrap(true);
    QScrollArea *aboutScroll = new QScrollArea(aboutDialog);
    QVBoxLayout *scrollLayout = new QVBoxLayout(aboutScroll);
    scrollLayout->addWidget(aboutText);
    QVBoxLayout *layout = new QVBoxLayout(aboutDialog);
    layout->addWidget(aboutScroll);
    aboutDialog->setLayout(layout);
    aboutDialog->show();
    this->close();
}
