/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>
#include "ppxmlpaper.h"

PPXmlPaper::PPXmlPaper()
{
}

QDomElement PPXmlPaper::read(PPPaper *paper){
    m_document.clear();

    QDomElement root = m_document.createElement("paper");
    m_document.appendChild(root);

    QRect r = paper->rect();
    root.setAttribute("width",r.width());
    root.setAttribute("height",r.height());
    root.setAttribute("x",r.x());
    root.setAttribute("y",r.y());
//    root.setAttribute("resizable",paper->isResizable());
    root.setAttribute("type","standard");
    root.setAttribute("ver",1);


    QList<QGraphicsItem*> items = paper->childItems();

    foreach (QGraphicsItem *item , items){
        PPGraphicsStroke* stroke = qgraphicsitem_cast<PPGraphicsStroke*>(item);
        if (stroke){
            QDomElement elem = PPXmlPaper::createStrokeElement(stroke,m_document);
            root.appendChild(elem);
        }
    }

    return root;
}

void PPXmlPaper::read(QDomElement elem){
    m_document.setContent(QByteArray());
    QDomNode clone = elem.cloneNode(true);
    m_document.appendChild(clone);
}

bool PPXmlPaper::write(PPPaper *paper){
    bool res = true;
    paper->clear();

    QDomElement elem = m_document.firstChildElement("paper");

    if (elem.isNull())
        return false;

    int width = elem.attribute("width","100").toInt();
    int height = elem.attribute("height","100").toInt();
    int x = elem.attribute("x","0").toInt();
    int y = elem.attribute("y","0").toInt();
//    paper->setResizable(elem.attribute("resizable","1").toInt());

    paper->setRect(QRect(x,y,width,height));

    QDomNodeList list = elem.childNodes();
    for (int i = 0 ; i < list.size() ;i++) {
        QDomElement elem = list.at(i).toElement();
        if (elem.isNull())
            continue;
        // Hard code in this module. Change to a factory class if more sketch item is supported
        if (elem.tagName() == "stroke") {
            PPGraphicsStroke *stroke = new PPGraphicsStroke(paper);
            if (!PPXmlPaper::setStrokeFromElement(stroke,elem)){
                delete stroke ;
            }
        }/* else if (elem.tagName() == "background") {
            PPPaperBackground bg;
            if (PPXmlPaper::setBackgroundFromElement(&bg,elem)){
                paper->setBackground(bg);
            }
        }*/
    }

    paper->setDirty(false);
    return res;
}

bool PPXmlPaper::write(QDomNode node) {
    QDomElement paperElem = m_document.firstChildElement("paper");
    QDomNode res = node.appendChild(paperElem.cloneNode());

    return !res.isNull();
}

void PPXmlPaper::setDocument(QDomDocument &val){
    m_document = val;
}

QDomDocument PPXmlPaper::document() {
    return m_document;
}

QDomElement PPXmlPaper::createStrokeElement(PPGraphicsStroke *stroke , QDomDocument &doc ){
    QDomElement element = doc.createElement("stroke");

    QStringList list;
    QVector<QPointF> pts = stroke->points();
    foreach (QPointF pt , pts) {
        QString str = QString("%1,%2").arg(pt.x()).arg(pt.y());
        list << str;
    }

    QPen pen = stroke->pen();
    element.setAttribute("points",list.join(" "));
    element.setAttribute("color",pen.color().name());
    element.setAttribute("width",pen.width());
    return element;
}

bool PPXmlPaper::setStrokeFromElement(PPGraphicsStroke *stroke, QDomElement &elem){
    if (elem.tagName() != "stroke")
        return false;

    QPen pen = stroke->pen();
    QString color = elem.attribute("color","#000000");
    QColor c(color);
    pen.setColor(c);

    int width = elem.attribute("width","1").toInt();
    pen.setWidth(width);

    stroke->setPen(pen);

    QString val = elem.attribute("points","");
    QStringList list = val.split(" ");

    QPolygonF polygon;

    for (int i = 0 ; i < list.size() ; i++) {
        QStringList xy = list.at(i).split(",");

        if (xy.size() == 2) {
            qreal x = xy.at(0).toFloat();
            qreal y = xy.at(1).toFloat();
            QPointF pt(x,y);

            polygon << pt;
        }

    }

    stroke->setPolygon(polygon);

    return true;
}


