/**
  @author Ben Lau <xbenlau@gmail.com>
 */

#include <QPainter>
#include <QtCore>
#include <QLinearGradient>
#include <QResizeEvent>
#include <QMouseEvent>
#include "maemo5colorhpicker.h"


Maemo5ColorHPicker::Maemo5ColorHPicker(QWidget *parent) :
    QWidget(parent)
{
    markerWidth = 1;
    markerPos = 0;
    m_hue = 0;

}

void Maemo5ColorHPicker::setHue(int val){
//    qDebug() << __func__;
    if (val < 0)
        val = 0;
    if (m_hue!=val) {
        m_hue = val;
        emit hueChanged(val);
        updateMarker();
    }
}

int Maemo5ColorHPicker::hue(){
    return m_hue;
}

void Maemo5ColorHPicker::resizeEvent(QResizeEvent *event){
    updateMarker();
    QWidget::resizeEvent(event);
}

void Maemo5ColorHPicker::paintEvent(QPaintEvent*){
    int w = width() , h = height();
    QPainter painter(this);

    QPalette p = palette();

    if (background.isNull() || background.width() !=w || background.height() != h){
        QImage image(w,h,QImage::Format_RGB32);

        for (int y = 0; y < h; y++) {
            uint *pixel = (uint *) image.scanLine(y);
            const uint *end = pixel + w;
            QColor c;
            c.setHsv( 359 * ( (h - y) /(qreal) h) , 255, 255);

            while (pixel < end) {
                *pixel = c.rgb();
                ++pixel;
            }
        }
        background = QPixmap::fromImage(image);
    }

    painter.drawPixmap(0, 0, background);

    QPen pen(Qt::white);
    pen.setWidth(markerWidth);
    pen.setStyle(Qt::SolidLine);
    painter.setPen(pen);
    painter.drawLine(QPoint(0,markerPos) , QPoint(w,markerPos));

    painter.end();
}

void Maemo5ColorHPicker::mouseMoveEvent(QMouseEvent *event){
//    qDebug() << __func__;
    int h = size().height();
    int y = event->pos().y();
    if (y < 0)
        y = 0;
    if (y > h)
        y = h;
    setHue(yToHue(y));
    markerPos = y;
    update();
}

void Maemo5ColorHPicker::mousePressEvent(QMouseEvent *event){
//    qDebug() << __func__;
    setHue(yToHue(event->pos().y()));
    markerPos = event->pos().y();

    repaint();update();
}

void Maemo5ColorHPicker::updateMarker() {
    int h = size().height();

    markerPos = h - ( m_hue / (qreal) 359) * h;
//    qDebug() << __func__;
}

int Maemo5ColorHPicker::yToHue(int y){
    int h = size().height();
    return ( 359 - (y / (qreal)h) * 359 );
}
