#ifndef STORAGE_H
#define STORAGE_H

#include <QObject>
#include <QSqlDatabase>
#include <QSqlQuery>

/// Database storage

class Storage : public QObject
{
    Q_OBJECT
public:
    static Storage* instance();
    /// Open and initialize database
    bool open(QString file = QString());

    QSqlQuery query();

    static QString defaultDatabaseName();

signals:

public slots:
protected:
    explicit Storage(QObject *parent = 0);

private:
    /// Prepare the path of database storage
    void prepare(QString file);
    void initialize(QSqlDatabase &db);

    QString connectionName;

};

#endif // STORAGE_H
