#include <QDesktopServices>
#include <QtCore>
#include <QCoreApplication>
#include "storage.h"

static Storage* storage =0 ;

Storage::Storage(QObject *parent) :
    QObject(parent)
{
    connectionName = QCoreApplication::applicationName();
}

Storage* Storage::instance(){
    if (!storage){
        QCoreApplication *a = QCoreApplication::instance();
        storage = new Storage(a);
    }
    return storage;
}

bool Storage::open(QString file){
    if (file.isNull()) {
        file = defaultDatabaseName();
        prepare(file);
        qDebug() << "Storage::Open " << file;
    }

    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE",connectionName);
    db.setDatabaseName( file );
    bool res = db.open();
    if (!res) {
        qDebug() << "Failed to open database " + file;
    } else {
        initialize(db);
    }

    return res;
}

void Storage::prepare(QString file){

    QFileInfo info(file);

    QString path = info.absolutePath();

    QDir dir;
    if (!dir.exists(path)) {
        dir.mkpath(path);
    }
}

QString Storage::defaultDatabaseName() {
    return QDesktopServices::storageLocation(QDesktopServices::DataLocation) + "/sketch.db";
}

void Storage::initialize(QSqlDatabase &db) {
    QFile file(":/drawpad/init.sql");

    file.open(QIODevice::ReadOnly);
    QString content = file.readAll();

    QList<QString> statements = content.split(";");

    foreach (QString sql , statements) {
        sql = sql.trimmed();
        if (sql.isEmpty())
            continue;

        QSqlQuery query(db);
        if (!query.exec(sql)){
            qDebug() << "Failed to exec" << sql ;
        }
    }

    QSqlQuery query(db); // set config ver = '1'. It is the version of storage.
    query.prepare("SELECT value from config where key = 'ver' limit 1");
    query.exec();

    if (!query.next()){
        query.exec("INSERT INTO config(key,value) VALUES('ver',1);");
    }

}

QSqlQuery Storage::query(){
    return QSqlQuery(QSqlDatabase::database(connectionName));
}
