#ifndef DRAWPAD_H
#define DRAWPAD_H

#include <QWidget>
#include <QMenu>
#include <QGraphicsRectItem>
#include <QSignalMapper>
#include <QGraphicsView>
#include "strokerecorder.h"
#include "eraser.h"
#include "paper.h"

namespace Ui {
    class Drawpad;
}

class Drawpad : public QWidget
{
    Q_OBJECT

    Q_PROPERTY(QPointF center WRITE setCenter READ center)
public:
    explicit Drawpad(QWidget *parent = 0);
    ~Drawpad();

    enum Mode {
        FreeMoveMode,
        FreeDrawMode,
        EraserMode
    };

    /// Set a new page to the drawpad.
    /**
      @param newPage the new paper. Ownership will be taken

      @remarks Old page will be destroyed automatically
     */
    void setPaper(Paper *val);
    Paper* paper();

    void setMode(Mode val);
    Mode mode();

    QGraphicsView *view();

    QDomDocument toXml();

    void setColor(QColor color);
    QColor color();

    /// Save the paper to a file
    bool save(QString file);

    QList<QAction*> directionActions();

    void setGridSize(QSize val);

    /// Move with viewport
    void move(int vmove,int hmove);

    void setCenter(QPointF val);
    QPointF center();

    QRectF viewRect();

    int brushType();

    /// Refresh the display according to current paper
    void refresh();

public slots:
    void setBrushType(int);

protected:
    void changeEvent(QEvent *e);

private:

    Ui::Drawpad *ui;
    QMenu *brushMenu;
    Mode m_mode;

    StrokeRecorder *strokeRecorder;
    Eraser *eraser;

    /// Current page
    Paper *m_paper;

    QSignalMapper mapper;
    QColor m_color;

    QList<QAction*> m_directionActions;
//    QGraphicsItem *background;
    QSize gridSize;
    int m_brushType;

private slots:
    void on_actionDown_triggered();
    void on_actionUp_triggered();
    void on_actionRight_triggered();
    void on_actionLeft_triggered();
    void on_actionColor_triggered();
    void onStrokeRecorded();
    void on_actionBrush_triggered();
    void onActionTriggered(QAction *);


};

#endif // DRAWPAD_H
