/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Hallyson Melo <hallyson.melo@indt.org.br>
 *          Kyller Gorgonio <kyllercg@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#include <gtk/gtk.h>

#include "nm_conn_widget.h"
#include "nm_settings.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

enum
{
    SETTINGS_CHANGED,
    LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

#define NM_CONN_WIDGET_GET_PRIVATE(o) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((o), NM_CONN_WIDGET_TYPE, NmConnWidgetPrivate))

static void nm_conn_widget_class_init (NmConnWidgetClass *);
static void nm_conn_widget_init       (NmConnWidget *);

G_DEFINE_TYPE (NmConnWidget, nm_conn_widget, GTK_TYPE_FRAME)

static void
nm_conn_widget_class_init (NmConnWidgetClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS (klass);

    klass->apply_changes = NULL;

    signals[SETTINGS_CHANGED] = g_signal_new (NM_CONN_WIDGET_SETTINGS_CHANGED,
                                               G_OBJECT_CLASS_TYPE (object_class),
                                               G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION,
                                               0, NULL, NULL,
                                               g_cclosure_marshal_VOID__VOID,
                                               G_TYPE_NONE, 0, NULL);
}

static void
nm_conn_widget_init (NmConnWidget *self)
{
    gtk_frame_set_label (GTK_FRAME(self), _(" Options "));
}

gboolean
nm_conn_widget_apply_changes (NmConnWidget *self)
{
    return NM_CONN_WIDGET_GET_CLASS (self)->apply_changes (self);
}

void
nm_conn_widget_settings_changed (gpointer data)
{
    g_signal_emit (data, signals[SETTINGS_CHANGED], 0, G_TYPE_NONE);
}
