#include <glib.h>
#include <string.h>
#include <stdlib.h>

#include "nm_ifaces_utils.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define NM_IFACES_APP_ARGC              5
#define NM_IFACES_APP_OP_USB            "usb"
#define NM_IFACES_APP_OP_BT             "bluetooth"

int main (int argc, char *argv[])
{
    if (argc != NM_IFACES_APP_ARGC) {
    
        g_debug ("Usage: nm_ifaces <type> <address> <netmask> <gateway>\n");
        exit (1);
    }
    
    if (strcmp (argv[1], NM_IFACES_APP_OP_USB) == 0) {
    
        nm_ifaces_utils_save_config (NM_IFACES_USB_REGEX, argv[2], argv[3],
                                      argv[4]);
    } else if (strcmp (argv[1], NM_IFACES_APP_OP_BT) == 0) {
    
        nm_ifaces_utils_save_config (NM_IFACES_BT_REGEX, argv[2], argv[3],
                                      argv[4]);
    } else {
    
        g_debug ("syntax error: <type> should be 'usb' or 'bluetooth'\n");
        exit (1);
    }
    
    return 0;
}
