/*
 * Copyright (c) 2009 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */
 
#ifndef __NM_SAMBA_SETUP_H__
#define __NM_SAMBA_SETUP_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define NM_SAMBA_SETUP_TYPE            (nm_samba_setup_get_type ())
#define NM_SAMBA_SETUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_SAMBA_SETUP_TYPE, NmSambaSetup))
#define NM_SAMBA_SETUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_SAMBA_SETUP_TYPE, NmSambaSetupClass))
#define IS_NM_SAMBA_SETUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_SAMBA_SETUP_TYPE))
#define IS_NM_SAMBA_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_SAMBA_SETUP_TYPE))
#define NM_SAMBA_SETUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_SAMBA_SETUP_TYPE, NmSambaSetupClass))

typedef struct _NmSambaSetup      NmSambaSetup;
typedef struct _NmSambaSetupClass NmSambaSetupClass;

struct _NmSambaSetupClass
{
    NmConnWidgetClass parent_class;
};

struct _NmSambaSetup
{
    NmConnWidget parent;
};

GType       nm_samba_setup_get_type (void);
GtkWidget*  nm_samba_setup_new      (gchar *env);
void        nm_samba_setup_enable (NmSambaSetup *self, gboolean enable);
gboolean    nm_samba_setup_is_enabled (NmSambaSetup *);
gboolean    samba_setup_check_enabled (NmSambaSetup *);
void        nm_samba_setup_fill_widget(NmSambaSetup *self);
gboolean    nm_samba_setup_apply_changes (NmConnWidget *);
gboolean    nm_samba_setup_activate_environment (gchar *);
void        nm_samba_setup_save_changes (NmSambaSetup *);

G_END_DECLS

#endif
