#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import gtk
import hildon
from os import listdir, path, system
from ConfigParser import SafeConfigParser
import dbus
from dbus.mainloop.glib import DBusGMainLoop

version = "2.0-0"
trackingEnabled = True
stopTracking = True
stopWhenIdle = False
stopAfterMinutes = "5 minutes"
confirmDisconnect = True
showRestartButton = True
showSettingsButton = True
showConnected = True
connectedIcon = "Symbol"
wifiPMIcon = True
skipSystemCheck = False
autostart = False
keepWifiPMOff = False
toggleWifiPM = False
wifiPMOffSec = "2 seconds"
wifiPMOnSec = "4 seconds"
configReverseOrder = False
configShowWifiHint = True

class Window(object):
    def __init__(self):
        global trackingEnabled
        global stopTracking
        global stopWhenIdle
        global stopAfterMinutes
        global showConnected
        global connectedIcon
        global wifiPMIcon
        global confirmDisconnect
        global showRestartButton
        global showSettingsButton
        global skipSystemCheck
        global autostart
        global keepWifiPMOff
        global toggleWifiPM
        global wifiPMOffSec
        global wifiPMOnSec
        global configReverseOrder
        global configShowWifiHint
        
        autostartDisabled = False
        keepWifiPMOffInstalled = False
        otherForceCommand = False
        
        self.parser = SafeConfigParser()
        self.parser.optionxform = str
        if path.isfile("/home/user/.openssh-status-widget"):
            try:
                self.parser.read('/home/user/.openssh-status-widget')
            except:
                system("rm /home/user/.openssh-status-widget")
            else:
                if not self.parser.has_section('options'):
                    system("rm /home/user/.openssh-status-widget")
        if not path.isfile("/home/user/.openssh-status-widget"):
            configFile = open('/home/user/.openssh-status-widget', 'w')
            self.parser.add_section('options')
            self.parser.set('options', 'trackingEnabled', str(trackingEnabled))
            self.parser.set('options', 'stopTracking', str(stopTracking))
            self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
            self.parser.set('options', 'stopAfterMinutes', str(stopAfterMinutes))
            self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
            self.parser.set('options', 'showRestartButton', str(showRestartButton))
            self.parser.set('options', 'showSettingsButton', str(showSettingsButton))
            self.parser.set('options', 'showConnected', str(showConnected))
            self.parser.set('options', 'connectedIcon', str(connectedIcon))
            self.parser.set('options', 'wifiPMIcon', str(wifiPMIcon))
            self.parser.set('options', 'skipSystemCheck', str(skipSystemCheck))
            self.parser.set('options', 'configReverseOrder', str(configReverseOrder))
            self.parser.set('options', 'configShowWifiHint', str(configShowWifiHint))
            self.parser.write(configFile)
            configFile.close()
        else:
            self.parser.read('/home/user/.openssh-status-widget')
            if self.parser.has_section('options'):
                if self.parser.has_option('options', 'trackingEnabled'):
                    trackingEnabled = self.parser.getboolean('options', 'trackingEnabled')
                else:
                    self.parser.set('options', 'trackingEnabled', str(trackingEnabled))
                if self.parser.has_option('options', 'stopTracking'):
                    stopTracking = self.parser.getboolean('options', 'stopTracking')
                else:
                    self.parser.set('options', 'stopTracking', str(stopTracking))
                if self.parser.has_option('options', 'stopWhenIdle'):
                    stopWhenIdle = self.parser.getboolean('options', 'stopWhenIdle')
                else:
                    self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
                if self.parser.has_option('options', 'stopAfterMinutes'):
                    stopAfterMinutes = self.parser.get('options', 'stopAfterMinutes')
                else:
                    self.parser.set('options', 'stopAfterMinutes', str(stopAfterMinutes))
                if self.parser.has_option('options', 'confirmDisconnect'):
                    confirmDisconnect = self.parser.getboolean('options', 'confirmDisconnect')
                else:
                    self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
                if self.parser.has_option('options', 'showRestartButton'):
                    showRestartButton = self.parser.getboolean('options', 'showRestartButton')
                else:
                    self.parser.set('options', 'showRestartButton', str(showRestartButton))
                if self.parser.has_option('options', 'showSettingsButton'):
                    showSettingsButton = self.parser.getboolean('options', 'showSettingsButton')
                else:
                    self.parser.set('options', 'showSettingsButton', str(showSettingsButton))
                if self.parser.has_option('options', 'showConnected'):
                    showConnected = self.parser.getboolean('options', 'showConnected')
                else:
                    self.parser.set('options', 'showConnected', str(showConnected))
                if self.parser.has_option('options', 'connectedIcon'):
                    connectedIcon = self.parser.get('options', 'connectedIcon')
                else:
                    self.parser.set('options', 'connectedIcon', str(connectedIcon))
                if self.parser.has_option('options', 'wifiPMIcon'):
                    wifiPMIcon = self.parser.getboolean('options', 'wifiPMIcon')
                else:
                    self.parser.set('options', 'wifiPMIcon', str(wifiPMIcon))
                if self.parser.has_option('options', 'skipSystemCheck'):
                    skipSystemCheck = self.parser.getboolean('options', 'skipSystemCheck')
                else:
                    self.parser.set('options', 'skipSystemCheck', str(skipSystemCheck))
                if self.parser.has_option('options', 'configReverseOrder'):
                    configReverseOrder = self.parser.getboolean('options', 'configReverseOrder')
                else:
                    self.parser.set('options', 'configReverseOrder', str(configReverseOrder))
                if self.parser.has_option('options', 'configShowWifiHint'):
                    configShowWifiHint = self.parser.getboolean('options', 'configShowWifiHint')
                else:
                    self.parser.set('options', 'configShowWifiHint', str(configShowWifiHint))
        
        if not path.isfile("/etc/event.d/sshd"):
            system("sudo openssh-status.sh create_sshd")
        sshFile = open("/etc/event.d/sshd",'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "start on stopped rcS":
                autostart = True
            if line.strip('\n').strip(' ') == "#start on stopped rcS":
                autostartDisabled = True
        if not autostart and not autostartDisabled:
            system("sudo openssh-status.sh insert_start")
            
        sshFile = open("/etc/ssh/sshd_config", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "ForceCommand /usr/lib/openssh/session":
                keepWifiPMOffInstalled = True
            else:
                line = line.strip('\n').strip(' ')
                if line[0:12] == "ForceCommand":
                    otherForceCommand = True
        if otherForceCommand:
            system("sudo openssh-status.sh no_force")
            keepWifiPMOffInstalled = False
        if not keepWifiPMOffInstalled:
            system("sudo openssh-status.sh insert_wifipm")
            
        sshFile = open("/usr/lib/openssh/session", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "#SSH_IP=\"disabled\"":
                keepWifiPMOff = True
        
        sshFile = open("/usr/lib/openssh/wifi-power-management", 'r')
        lines = sshFile.readlines()
        sshFile.close()
        for line in lines:
            if line.strip('\n').strip(' ') == "iwconfig wlan0 power on #toggle":
                toggleWifiPM = True
            if "pmoff" in line:
                wifiPMOffSec = line.strip('\n').strip(' ').split(' ')[1]
                if wifiPMOffSec == "1":
                    wifiPMOffSec += " second"
                else:
                    wifiPMOffSec += " seconds"
            if "pmon" in line:
                wifiPMOnSec = line.strip('\n').strip(' ').split(' ')[1] + " seconds"
                break
        
        self.indicatorList = []
        for f in listdir('/usr/share/icons/hicolor/18x18/hildon/'):
            if f[0:21] == "openssh-status_users_" and f <> "openssh-status_users_symbol.png" and f[-4:] ==".png":
                f = f[21:-4]
                self.indicatorList.append(f.title())
        self.indicatorList.sort()
        self.indicatorList.insert(0, "Symbol")
        
        self.timeoutList = ["1 minute", "5 minutes", "15 minutes", "30 minutes", "60 minutes"]
        self.pmOffList = ["1 second", "2 seconds", "3 seconds"]
        self.pmOnList = ["3 seconds", "4 seconds", "5 seconds"]
        
        DBusGMainLoop(set_as_default=True)
        bus = dbus.SessionBus()
        bus.add_signal_receiver(self.dbus, path='/', dbus_interface='org.maemo.oswoptions', signal_name='changed2')
        
    def dbus(self, param, val):
        if param == "keepWifiPMOff":
            self.buttonKeepWifiPMOff_dbus()
 
        if param == "toggleWifiPM":
            self.buttonToggleWifiPM_dbus()
 
        if param == "wifiPMOffSec":
            self.buttonWifiPMOffSec_dbus(val)
 
        if param == "wifiPMOnSec":
            self.buttonWifiPMOnSec_dbus(val)
 
    def main(self):
        self.window = hildon.Window()
        self.window.set_title("OpenSSH Status Widget")
        self.window.connect("delete_event", gtk.main_quit, None)
        
        self.labelWidget = gtk.Label("Widget options:")
        self.labelServer = gtk.Label("Server options:")
        self.labelWifiPM = gtk.Label("Wifi PM options:")
    
        self.buttonTrackingEnabled = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonTrackingEnabled.set_label("Enable tracking")
    
        self.buttonStopTracking = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonStopTracking.set_label("Stop tracking when server is off")
    
        self.buttonStopWhenIdle = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonStopWhenIdle.set_label("Stop server when not connected")
    
        self.buttonStopAfterMinutes = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonStopAfterMinutes.set_title("Wait:")
        self.buttonStopAfterMinutes.set_alignment(0.09, 0.5, 0, 0)
        self.buttonStopAfterMinutes.set_selector(self.selectTimeout())
        try:
            self.buttonStopAfterMinutes.set_active(self.timeoutList.index(stopAfterMinutes))
        except:
            self.buttonStopAfterMinutes.set_active(1)
    
        self.buttonConfirm = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonConfirm.set_label("Show dialog on long tap (do not disconnect)")
        
        self.buttonShowRestart = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonShowRestart.set_label("Show restart button")
        self.buttonShowRestart.set_alignment(0.08, 0.5)
    
        self.buttonShowSettings = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonShowSettings.set_label("Show settings button")
        self.buttonShowSettings.set_alignment(0.083, 0.5)
    
        self.buttonShowConnected = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonShowConnected.set_label("Show status 'connected' in status area")
    
        self.buttonConnectedIcon = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonConnectedIcon.set_title("Indicator:")
        self.buttonConnectedIcon.set_alignment(0.09, 0.5, 0, 0)
        self.buttonConnectedIcon.set_selector(self.selectIndicator())
        try:
            self.buttonConnectedIcon.set_active(self.indicatorList.index(connectedIcon.strip('_')))
        except:
            self.buttonConnectedIcon.set_active(0)
        
        self.buttonWifiPMIcon = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonWifiPMIcon.set_label("Show wifi power management button")
    
        self.buttonAutostart = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonAutostart.set_label("Run server at system startup")
                
        self.buttonKeepWifiPMOff = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonKeepWifiPMOff.set_label("Keep wifi power management off when connected")
    
        self.buttonToggleWifiPM = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.buttonToggleWifiPM.set_label("Toggle mode (less power consuming)")
        self.buttonToggleWifiPM.set_alignment(0.12, 0.5)
    
        self.buttonWifiPMOffSec = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonWifiPMOffSec.set_title("Wifi PM off:")
        self.buttonWifiPMOffSec.set_alignment(0.17, 0.5, 0, 0)
        self.buttonWifiPMOffSec.set_selector(self.selectWifiPMOffSec())
        try:
            self.buttonWifiPMOffSec.set_active(self.pmOffList.index(wifiPMOffSec))
        except:
            self.buttonWifiPMOffSec.set_active(1)
    
        self.buttonWifiPMOnSec = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        self.buttonWifiPMOnSec.set_title("Wifi PM on:")
        self.buttonWifiPMOnSec.set_alignment(0.17, 0.5, 0, 0)
        self.buttonWifiPMOnSec.set_selector(self.selectWifiPMOnSec())
        try:
            self.buttonWifiPMOnSec.set_active(self.pmOnList.index(wifiPMOnSec))
        except:
            self.buttonWifiPMOnSec.set_active(1)
    
        vboxBorder = gtk.VBox(False, 0)
        vboxBorder.set_border_width(8)
        self.vbox = gtk.VBox(False, 0)
        self.vbox.set_border_width(0)
        
        if configReverseOrder:
            self.pack_startWifiPMButtons()
            self.pack_startServerButtons()
            self.pack_startWidgetButtons()
        else:
            self.pack_startWidgetButtons()
            self.pack_startServerButtons()
            self.pack_startWifiPMButtons()
        
        areaScrolling = hildon.PannableArea()
        areaScrolling.add_with_viewport(self.vbox)
        areaScrolling.set_border_width(0)
        
        vboxBorder.pack_start(areaScrolling, True, True, 0)
        
        self.window.add(vboxBorder)
        
        if stopTracking:
            self.buttonStopTracking.set_active(True)
        else:
            self.buttonStopTracking.set_active(False)

        if stopWhenIdle:
            self.buttonStopWhenIdle.set_active(True)
            self.buttonStopAfterMinutes.set_sensitive(True)
        else:
            self.buttonStopWhenIdle.set_active(False)
            self.buttonStopAfterMinutes.set_sensitive(False)

        if confirmDisconnect:
            self.buttonConfirm.set_active(True)
            self.buttonShowRestart.set_sensitive(True)
            self.buttonShowSettings.set_sensitive(True)
        else:
            self.buttonConfirm.set_active(False)
            self.buttonShowRestart.set_sensitive(False)
            self.buttonShowSettings.set_sensitive(False)

        if showRestartButton:
            self.buttonShowRestart.set_active(True)
        else:
            self.buttonShowRestart.set_active(False)

        if showSettingsButton:
            self.buttonShowSettings.set_active(True)
        else:
            self.buttonShowSettings.set_active(False)

        if showConnected:
            self.buttonShowConnected.set_active(True)
            self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonShowConnected.set_active(False)
            self.buttonConnectedIcon.set_sensitive(False)
            
        if wifiPMIcon:
            self.buttonWifiPMIcon.set_active(True)
        else:
            self.buttonWifiPMIcon.set_active(False)

        if trackingEnabled:
            self.buttonTrackingEnabled.set_active(True)
        else:
            self.buttonTrackingEnabled.set_active(False)
            self.buttonStopTracking.set_sensitive(False)
            self.buttonStopWhenIdle.set_sensitive(False)
            self.buttonStopAfterMinutes.set_sensitive(False)
            self.buttonConfirm.set_sensitive(False)
            self.buttonShowRestart.set_sensitive(True)
            self.buttonShowSettings.set_sensitive(True)
            self.buttonShowConnected.set_sensitive(False)
            self.buttonConnectedIcon.set_sensitive(False)
        
        if autostart:
            self.buttonAutostart.set_active(True)
        else:
            self.buttonAutostart.set_active(False)

        if keepWifiPMOff:
            self.buttonKeepWifiPMOff.set_active(True)
            self.buttonToggleWifiPM.set_sensitive(True)
            self.buttonWifiPMOffSec.set_sensitive(True)
            self.buttonWifiPMOnSec.set_sensitive(True)
        else:
            self.buttonKeepWifiPMOff.set_active(False)
            self.buttonToggleWifiPM.set_sensitive(False)
            self.buttonWifiPMOffSec.set_sensitive(False)
            self.buttonWifiPMOnSec.set_sensitive(False)
        
        if toggleWifiPM:
            self.buttonToggleWifiPM.set_active(True)
        else:
            self.buttonToggleWifiPM.set_active(False)

        self.buttonTrackingEnabled.connect("clicked", self.buttonTrackingEnabled_clicked)
        self.buttonStopTracking.connect("clicked", self.buttonStopTracking_clicked)
        self.buttonStopWhenIdle.connect("clicked", self.buttonStopWhenIdle_clicked)
        self.buttonStopAfterMinutes.connect("value-changed", self.buttonStopAfterMinutes_changed)
        self.buttonConfirm.connect("clicked", self.buttonConfirm_clicked)
        self.buttonShowRestart.connect("clicked", self.buttonShowRestart_clicked)
        self.buttonShowSettings.connect("clicked", self.buttonShowSettings_clicked)
        self.buttonShowConnected.connect("clicked", self.buttonShowConnected_clicked)
        self.buttonConnectedIcon.connect("value-changed", self.buttonConnectedIcon_changed)
        self.buttonWifiPMIcon.connect("clicked", self.buttonWifiPMIcon_clicked)
        self.buttonAutostart.connect("clicked", self.buttonAutostart_clicked)
        self.buttonKeepWifiPMOff_id = self.buttonKeepWifiPMOff.connect("clicked", self.buttonKeepWifiPMOff_clicked)
        self.buttonToggleWifiPM_id = self.buttonToggleWifiPM.connect("clicked", self.buttonToggleWifiPM_clicked)
        self.buttonWifiPMOffSec_id = self.buttonWifiPMOffSec.connect("value-changed", self.buttonWifiPMOffSec_changed)
        self.buttonWifiPMOnSec_id = self.buttonWifiPMOnSec.connect("value-changed", self.buttonWifiPMOnSec_changed)
        
        menu = self.create_menu()
        self.window.set_app_menu(menu)
        
        self.window.show_all()
    
        gtk.main()
        
    def pack_startWidgetButtons(self):
        self.vbox.pack_start(self.labelWidget, False, False, 8)
        self.vbox.pack_start(self.buttonTrackingEnabled, False, False, 0)
        self.vbox.pack_start(self.buttonStopTracking, False, False, 0)
        self.vbox.pack_start(self.buttonStopWhenIdle, False, False, 0)
        self.vbox.pack_start(self.buttonStopAfterMinutes, False, False, 0)
        self.vbox.pack_start(self.buttonShowConnected, False, False, 0)
        self.vbox.pack_start(self.buttonConnectedIcon, False, False, 0)
        self.vbox.pack_start(self.buttonConfirm, False, False, 0)
        self.vbox.pack_start(self.buttonShowRestart, False, False, 0)
        self.vbox.pack_start(self.buttonShowSettings, False, False, 0)
        self.vbox.pack_start(self.buttonWifiPMIcon, False, False, 0)
    
    def pack_startServerButtons(self):
        self.vbox.pack_start(self.labelServer, False, False, 8)
        self.vbox.pack_start(self.buttonAutostart, False, False, 0)
        
    def pack_startWifiPMButtons(self):
        self.vbox.pack_start(self.labelWifiPM, False, False, 8)
        self.vbox.pack_start(self.buttonKeepWifiPMOff, False, False, 0)
        self.vbox.pack_start(self.buttonToggleWifiPM, False, False, 0)
        self.vbox.pack_start(self.buttonWifiPMOffSec, False, False, 0)
        self.vbox.pack_start(self.buttonWifiPMOnSec, False, False, 0)
        
    def removeWidgetButtons(self):
        self.vbox.remove(self.labelWidget)
        self.vbox.remove(self.buttonTrackingEnabled)
        self.vbox.remove(self.buttonStopTracking)
        self.vbox.remove(self.buttonStopWhenIdle)
        self.vbox.remove(self.buttonStopAfterMinutes)
        self.vbox.remove(self.buttonShowConnected)
        self.vbox.remove(self.buttonConnectedIcon)
        self.vbox.remove(self.buttonConfirm)
        self.vbox.remove(self.buttonShowRestart)
        self.vbox.remove(self.buttonShowSettings)
        self.vbox.remove(self.buttonWifiPMIcon)
    
    def removeServerButtons(self):
        self.vbox.remove(self.labelServer)
        self.vbox.remove(self.buttonAutostart)
        
    def removeWifiPMButtons(self):
        self.vbox.remove(self.labelWifiPM)
        self.vbox.remove(self.buttonKeepWifiPMOff)
        self.vbox.remove(self.buttonToggleWifiPM)
        self.vbox.remove(self.buttonWifiPMOffSec)
        self.vbox.remove(self.buttonWifiPMOnSec)
        
    def buttonTrackingEnabled_clicked(self, dummy):
        global trackingEnabled
        trackingEnabled = not trackingEnabled
        if trackingEnabled:
            self.buttonStopTracking.set_sensitive(True)
            self.buttonStopWhenIdle.set_sensitive(True)
            if stopWhenIdle:
                self.buttonStopAfterMinutes.set_sensitive(True)
            self.buttonConfirm.set_sensitive(True)
            if confirmDisconnect:
                self.buttonShowRestart.set_sensitive(True)
                self.buttonShowSettings.set_sensitive(True)
            else:
                self.buttonShowRestart.set_sensitive(False)
                self.buttonShowSettings.set_sensitive(False)
            self.buttonShowConnected.set_sensitive(True)
            if showConnected:
                self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonStopTracking.set_sensitive(False)
            self.buttonStopWhenIdle.set_sensitive(False)
            self.buttonStopAfterMinutes.set_sensitive(False)
            self.buttonConfirm.set_sensitive(False)
            self.buttonShowRestart.set_sensitive(True)
            self.buttonShowSettings.set_sensitive(True)
            self.buttonShowConnected.set_sensitive(False)
            self.buttonConnectedIcon.set_sensitive(False)
        self.parser.set('options', 'trackingEnabled', str(trackingEnabled))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'trackingEnabled' string:'"+str(trackingEnabled)+"'")
        
    def buttonStopTracking_clicked(self, dummy):
        global stopTracking
        stopTracking = not stopTracking
        self.parser.set('options', 'stopTracking', str(stopTracking))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'stopTracking' string:'"+str(stopTracking)+"'")
        
    def buttonStopWhenIdle_clicked(self, dummy):
        global stopWhenIdle
        stopWhenIdle = not stopWhenIdle
        if stopWhenIdle:
            self.buttonStopAfterMinutes.set_sensitive(True)
        else:
            self.buttonStopAfterMinutes.set_sensitive(False)
        self.parser.set('options', 'stopWhenIdle', str(stopWhenIdle))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'stopWhenIdle' string:'"+str(stopWhenIdle)+"'")
        
    def selectTimeout(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.timeoutList:
            selector.append_text(i)
        return selector
        
    def buttonStopAfterMinutes_changed(self, dummy):
        t = self.buttonStopAfterMinutes.get_value()
        self.parser.set('options', 'stopAfterMinutes', t)
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'stopAfterMinutes' string:'"+t+"'")
        
    def buttonConfirm_clicked(self, dummy):
        global confirmDisconnect
        confirmDisconnect = not confirmDisconnect
        if confirmDisconnect:
            self.buttonShowRestart.set_sensitive(True)
            self.buttonShowSettings.set_sensitive(True)
        else:
            self.buttonShowRestart.set_sensitive(False)
            self.buttonShowSettings.set_sensitive(False)
            if showSettingsButton:
                self.printDialog("Settings can be accessed by opening 'OSW Options' from the application menu, category desktop.")
        self.parser.set('options', 'confirmDisconnect', str(confirmDisconnect))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'confirmDisconnect' string:'"+str(confirmDisconnect)+"'")

    def buttonShowRestart_clicked(self, dummy):
        global showRestartButton
        showRestartButton = not showRestartButton
        self.parser.set('options', 'showRestartButton', str(showRestartButton))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'showRestartButton' string:'"+str(showRestartButton)+"'")

    def buttonShowSettings_clicked(self, dummy):
        global showSettingsButton
        showSettingsButton = not showSettingsButton
        if not showSettingsButton:
            self.printDialog("Settings can be accessed by opening 'OSW Options' from the application menu, category desktop.")
        self.parser.set('options', 'showSettingsButton', str(showSettingsButton))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'showSettingsButton' string:'"+str(showSettingsButton)+"'")

    def buttonShowConnected_clicked(self, dummy):
        global showConnected
        showConnected = not showConnected
        if showConnected:
            self.buttonConnectedIcon.set_sensitive(True)
        else:
            self.buttonConnectedIcon.set_sensitive(False)
        self.parser.set('options', 'showConnected', str(showConnected))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'showConnected' string:'"+str(showConnected)+"'")
        
    def selectIndicator(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.indicatorList:
            selector.append_text(i)
        return selector
        
    def buttonConnectedIcon_changed(self, dummy):
        style = self.buttonConnectedIcon.get_value()
        while len(style) < 4:
            style = style + "_"
        self.parser.set('options', 'connectedIcon', style)
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'connectedIcon' string:'"+style+"'")
        
    def buttonWifiPMIcon_clicked(self, dummy):
        global wifiPMIcon
        wifiPMIcon = not wifiPMIcon
        self.parser.set('options', 'wifiPMIcon', str(wifiPMIcon))
        self.write_config()
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'wifiPMIcon' string:'"+str(wifiPMIcon)+"'")
        
    def buttonAutostart_clicked(self, dummy):
        global autostart
        autostart = not autostart
        if autostart:
            system("sudo openssh-status.sh enable_autostart")
        else:
            system("sudo openssh-status.sh disable_autostart")

    def buttonKeepWifiPMOff_clicked(self, dummy):
        global keepWifiPMOff
        global configShowWifiHint
        keepWifiPMOff = not keepWifiPMOff
        if keepWifiPMOff:
            self.buttonToggleWifiPM.set_sensitive(True)
            self.buttonWifiPMOffSec.set_sensitive(True)
            self.buttonWifiPMOnSec.set_sensitive(True)
            if configShowWifiHint:
                configShowWifiHint = False
                self.parser.set('options', 'configShowWifiHint', str(configShowWifiHint))
                self.write_config()
                self.printDialog("Keeping off wifi power management increases power consumption significantly. Try toggle mode in addition.")
            system("sudo openssh-status.sh enable_wifipmoff")
        else:
            self.buttonToggleWifiPM.set_sensitive(False)
            self.buttonWifiPMOffSec.set_sensitive(False)
            self.buttonWifiPMOnSec.set_sensitive(False)
            system("sudo openssh-status.sh disable_wifipmoff")
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'keepWifiPMOff' string:'"+str(keepWifiPMOff)+"'")
    
    def buttonKeepWifiPMOff_dbus(self):
        self.buttonKeepWifiPMOff.handler_block(self.buttonKeepWifiPMOff_id)
        global keepWifiPMOff
        global configShowWifiHint
        keepWifiPMOff = not keepWifiPMOff
        if keepWifiPMOff:
            self.buttonKeepWifiPMOff.set_active(True)
            self.buttonToggleWifiPM.set_sensitive(True)
            self.buttonWifiPMOffSec.set_sensitive(True)
            self.buttonWifiPMOnSec.set_sensitive(True)
            if configShowWifiHint:
                configShowWifiHint = False
        else:
            self.buttonKeepWifiPMOff.set_active(False)
            self.buttonToggleWifiPM.set_sensitive(False)
            self.buttonWifiPMOffSec.set_sensitive(False)
            self.buttonWifiPMOnSec.set_sensitive(False)
        self.buttonKeepWifiPMOff.handler_unblock(self.buttonKeepWifiPMOff_id)
    
    def buttonToggleWifiPM_clicked(self, dummy):
        global toggleWifiPM
        toggleWifiPM = not toggleWifiPM
        if toggleWifiPM:
            system("sudo openssh-status.sh enable_togglepm")
        else:
            system("sudo openssh-status.sh disable_togglepm")
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'toggleWifiPM' string:'"+str(toggleWifiPM)+"'")
        
    def buttonToggleWifiPM_dbus(self):
        self.buttonToggleWifiPM.handler_block(self.buttonToggleWifiPM_id)
        global toggleWifiPM
        toggleWifiPM = not toggleWifiPM
        if toggleWifiPM:
            self.buttonToggleWifiPM.set_active(True)
        else:
            self.buttonToggleWifiPM.set_active(False)
        self.buttonToggleWifiPM.handler_unblock(self.buttonToggleWifiPM_id)
        
    def selectWifiPMOffSec(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.pmOffList:
            selector.append_text(i)
        return selector
        
    def buttonWifiPMOffSec_changed(self, dummy):
        t = self.buttonWifiPMOffSec.get_value()
        system("sudo openssh-status.sh set_pmoffsec "+t.split(' ')[0])
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'wifiPMOffSec' string:'"+str(t)+"'")
        
    def buttonWifiPMOffSec_dbus(self, val):
        self.buttonWifiPMOffSec.handler_block(self.buttonWifiPMOffSec_id)
        try:
            self.buttonWifiPMOffSec.set_active(self.pmOffList.index(val))
        except:
            pass
        self.buttonWifiPMOffSec.handler_unblock(self.buttonWifiPMOffSec_id)
        
    def selectWifiPMOnSec(self):
        selector = hildon.TouchSelector(text = True)
        for i in self.pmOnList:
            selector.append_text(i)
        return selector
        
    def buttonWifiPMOnSec_changed(self, dummy):
        t = self.buttonWifiPMOnSec.get_value()
        system("sudo openssh-status.sh set_pmonsec "+t.split(' ')[0])
        system("dbus-send --type=signal / org.maemo.oswoptions.changed1 string:'wifiPMOnSec' string:'"+str(t)+"'")
        
    def buttonWifiPMOnSec_dbus(self, val):
        self.buttonWifiPMOnSec.handler_block(self.buttonWifiPMOnSec_id)
        try:
            self.buttonWifiPMOnSec.set_active(self.pmOnList.index(val))
        except:
            pass
        self.buttonWifiPMOnSec.handler_unblock(self.buttonWifiPMOnSec_id)
        
    def write_config(self):
        configFile = open('/home/user/.openssh-status-widget', 'r+')
        self.parser.write(configFile)
        configFile.close()

    def create_menu(self):
        menu = hildon.AppMenu()
    
        buttonReverse = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonReverse.set_label('Reverse sections order')
        buttonReverse.connect("clicked", self.reverse_clicked)
        buttonAbout = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        buttonAbout.set_label('Info')
        buttonAbout.connect("clicked", self.about_clicked)
    
        menu.append(buttonReverse)
        menu.append(buttonAbout)
    
        menu.show_all()
    
        return menu
    
    def reverse_clicked(self, dummy):
        global configReverseOrder
        configReverseOrder = not configReverseOrder
        self.removeServerButtons()
        if configReverseOrder:
            self.removeWidgetButtons()
            self.pack_startServerButtons()
            self.pack_startWidgetButtons()
        else:
            self.removeWifiPMButtons()
            self.pack_startServerButtons()
            self.pack_startWifiPMButtons()
        self.parser.set('options', 'configReverseOrder', str(configReverseOrder))
        self.write_config()
    
    def about_clicked(self, dummy):
        self.about = gtk.Dialog("Info", self.window)
        logo = gtk.image_new_from_file("/usr/share/icons/hicolor/64x64/apps/openssh-status.png")
        textApp = gtk.Label("<big><b>OpenSSH Status Widget  "+version+"</b></big>")
        textApp.set_use_markup(True)
        textApp.set_line_wrap(True)
        textIandI = gtk.Label("Created by Marc P"+"\xc3\xb6".decode('utf-8')+"pperl (rasmarc)\n")
        buttonForum = hildon.Button(gtk.HILDON_SIZE_FULLSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL | hildon.BUTTON_STYLE_NORMAL)
        buttonForum.set_label('Go to forum thread')
        vbox2 = gtk.VBox(False,16)
        vbox2.set_border_width(16)
        vbox2.pack_start(logo)
        vbox2.pack_start(textApp)
        vbox2.pack_start(textIandI)
        vbox2.pack_start(buttonForum)
        self.about.vbox.pack_start(vbox2)

        buttonForum.connect("clicked", self.buttonForum_clicked)
        
        self.about.show_all()
        
    def buttonForum_clicked(self, dummy):
        self.about.destroy()
        system("dbus-send --session --type=method_call --dest=com.nokia.osso_browser \
        /com/nokia/osso_browser/request com.nokia.osso_browser.open_new_window string:http://talk.maemo.org/showthread.php?t=95429")
            
    def printDialog(self, msg):
        system("run-standalone.sh dbus-send \
        --type=method_call --dest=org.freedesktop.Notifications \
        /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
        string:\""+msg+"\" uint32:0 string:")

if __name__ == "__main__":
    mywindow = Window()
    mywindow.main()
