#!/usr/bin/python2.5
# -*- coding: utf-8 -*-

# 
# Copyright (c) 2007-2008 INdT.
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : ns-schedule.py
# Author      : Giorgos Logiotatidis
# Version     : 0.1
# Description : NS Schedule
# ============================================================================


# TODO: 

# Use gps to pick from station (check error rate)
# Use threads to get data
# fix portair mode
# departure arrival and extra checkboxes
# compile regex
# find icon
# build package
# error handling

import gtk 
import gobject
import hildon
import locationservice
from datetime import datetime, timedelta
from time import strptime, mktime
from nsclient import NSClient, NSClientException, stations
from portrait import FremantleRotation


def display_banner(window, msg):
    hildon.hildon_banner_show_information(window, "", str(msg))
            
class NS(hildon.Program):
    def __init__(self):
        hildon.Program.__init__(self)
        
        self.fromButton = None
        self.toButton = None
        self.viaButton = None
        self.dateButton = None
        self.timeButton = None
        self.searchButton = None
        self.depButton = None
        self.arrButton = None
        self.locationService = locationservice.LocationService(self.setDepartureStation)
        self.locationService.start_location(self.locationService.control)
        self.nsclient = NSClient()

        self.rotation = FremantleRotation('ns-schedule', None, '0.1', 0)

        gtk.set_application_name("NS Schedule")

        self.window = hildon.StackableWindow()
        self.window.connect("delete_event", self.quit)  
        # FIXME
        self.window.get_screen().connect("size-changed", self.drawUI)
        self.rotation.set_mode(1)

        self.add_window(self.window)
       
        # create buttons
        self.create_buttons()

        
        self.drawUI()
        menu = self.create_menu(None)
        self.window.set_app_menu(menu)
   
    def create_buttons(self):
        selector = hildon.TouchSelectorEntry(text=True)
        for station in stations:
            selector.append_text(station)
        
        self.fromButton = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                           hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.fromButton.set_title("From:")    
        self.fromButton.set_selector(selector)
    
        selector = hildon.TouchSelectorEntry(text=True)
        for station in stations:
            selector.append_text(station)
        self.toButton = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                            hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.toButton.set_title("To:")
        self.toButton.set_selector(selector)

        selector = hildon.TouchSelectorEntry(text=True)
        selector.append_text("")
        for station in stations:
            selector.append_text(station)
        self.viaButton = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                            hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.viaButton.set_title("Via:")
        self.viaButton.set_selector(selector)

        self.depButton = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
        self.depButton.set_label("Departure")
        
        self.arrButton = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, self.depButton)
        self.arrButton.set_label("Arrival")        

        
        self.dateButton = hildon.DateButton(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                       hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.dateButton.set_title("Date:")
        
        self.timeButton = hildon.TimeButton(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                       hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.timeButton.set_title("Time:")
              
        self.searchButton = hildon.GtkButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.searchButton.connect("clicked", self.search_button_clicked, None)        
        self.searchButton.set_label("Journey Advice")
        
    def search_button_clicked(self, a=None, b=None):    
        self.results = []   
        toStation = self.toButton.get_value()
        fromStation = self.fromButton.get_value()
        viaStation = self.viaButton.get_value()
        

        date = "%s-%s-%s" % (self.dateButton.get_date()[2], self.dateButton.get_date()[1]+1, self.dateButton.get_date()[0])       
        time = self.timeButton.get_value()

        self.nsclient.clear()
        
        try:
            self.nsclient.set_data(fromStation=fromStation, 
                                    toStation=toStation, 
                                    viaStation=viaStation, 
                                    date=date, 
                                    time=time)
        except NSClientException, error:
            display_banner(self.window, error)
            return
    
        try:
            result = self.nsclient.fetch_next()
        except NSClientException, error:
            display_banner(self.window, error)
            return
            
        self.display_result(result)
        
    def setDepartureStation(self):          
        if self.fromButton.get_value() == "":
            self.fromButton.set_value(self.locationService.closestStation['name'])
        
    def drawUI(self, a=None):      
        # clear everything
        def clearGtkTree(item):
            if (type(item) is hildon.DateButton) or (type(item) is hildon.TimeButton) or (type(item) is hildon.GtkButton) or (type(item) is hildon.PickerButton):
                return
            try:
                for child in item.get_children():            
                    clearGtkTree(child)
                    item.remove(child)
            except AttributeError:
                return  
            
        clearGtkTree(self.window)
        
        # set departure station
        
        self.fromButton.set_value(self.locationService.closestStation['name'])
        
        if (self.rotation._orientation) == "portrait":
            # buttons vbox
            vbox = gtk.VBox(True, 0)
            vbox.add(self.fromButton)
            vbox.add(self.viaButton)
            vbox.add(self.toButton)
            vbox.add(self.dateButton)
            vbox.add(self.timeButton)
            vbox.add(self.searchButton)           
            self.window.add(vbox)
            
        else:
            vbox = gtk.VBox(True, 0)
            vbox.pack_start(self.fromButton)
            vbox.pack_start(self.viaButton)
            vbox.pack_start(self.toButton)
            vbox.pack_start(self.dateButton)
#===============================================================================
#            vbox.add(self.depButton)
#            vbox.add(self.arrButton)
#===============================================================================
            vbox.pack_start(self.timeButton)
            vbox.pack_start(self.searchButton)
            
            
            self.window.add(vbox)

        self.window.show_all()

    def quit(self, *args):
        gtk.main_quit()
        
    def run(self):     
        self.window.show_all()
        gtk.main() 
    
    def result_clicked(self, widget, data, c):
        self.display_result(data[0])

    def display_all_results(self):
        left = self.build_left_column()
        win = hildon.StackableWindow()
        win.set_title("Journeys")    
        win.add(left)          
        win.show_all()
     
    def build_left_column(self):     
        list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING)
        
        count = 1
        for i in self.results:
            niter = list.append()

            date = "%s-%s-%s" % (self.dateButton.get_date()[2], self.dateButton.get_date()[1]+1, self.dateButton.get_date()[0])       
            dateObjectStart = datetime(*strptime("%s %s" % (i[0]['departureTime'], date), "%H:%M %d-%m-%Y")[:6])
            dateObjectStop = datetime(*strptime("%s %s" % (i[-1]['arrivalTime'], date), "%H:%M %d-%m-%Y")[:6])
            diff = (dateObjectStop - dateObjectStart).seconds
            list.set(niter, 0, count, 1, i[0]['departureTime'], 2, i[-1]['arrivalTime'], 3, len(i)-1, 4, "%.2d:%.2d" % (diff/3600, (diff % 3600)/60))
            
            count += 1
            
        #Define the recipe list treeview with multiple selections, search, etc.
        self.checkpoint_tv = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        
        self.checkpoint_tv.connect("row-activated", self.result_clicked)
        selection = self.checkpoint_tv.get_selection()
        self.checkpoint_tv.set_model(list)

        parea = hildon.PannableArea()
        parea.add(self.checkpoint_tv)
        # add columns to the tree view
        self.add_columns_to_left_list(self.checkpoint_tv)
        
        return parea

    def add_columns_to_left_list(self, treeview):
        model = treeview.get_model()


        # column for ID
        renderer = gtk.CellRendererText()
        renderer.set_property('xalign', .5)
        column = gtk.TreeViewColumn('#', renderer, text=0)
        column.set_property('max-width', 50)       
        column.set_property('min-width', 50)        
        
        treeview.append_column(column)
        

        # column for ID
        renderer = gtk.CellRendererText()
        renderer.set_property('xalign', 0)
        column = gtk.TreeViewColumn('Departure', renderer, text=1)
        column.set_property('max-width', 150)       
        column.set_property('min-width', 150)        
        
        treeview.append_column(column)
        

        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', 0)
        column = gtk.TreeViewColumn('Arrival', renderer, text=2)
        column.set_property('max-width', 150)       
        column.set_property('min-width', 150)
        treeview.append_column(column)


        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', .5)
        column = gtk.TreeViewColumn('Transfers', renderer, text=3)
        column.set_property('max-width', 140)       
        column.set_property('min-width', 140)
        treeview.append_column(column)

        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', .5)
        column = gtk.TreeViewColumn('Travel Time', renderer, text=4)
        column.set_property('max-width', 100)       
        column.set_property('min-width', 100)
        treeview.append_column(column)

        
        # set tree properties
        treeview.set_headers_visible(True)
        treeview.set_fixed_height_mode(False)
#        treeview.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)


    def on_next_clicked(self, button, list):
        try:
            result = self.nsclient.fetch_next()
        except NSClientException, error:
            display_banner(self.window, error)
            return

        list.clear()
        
        for stop in result:
            if stop['departureExtraTime'] != 0:
                depTime = "%s +%s" % (stop['departureTime'], stop['departureExtraTime'])
            else:
                depTime = stop['departureTime']
            
            if stop['arrivalExtraTime'] != 0:
                arrTime = "%s +%s" % (stop['arrivalTime'], stop['arrivalExtraTime'])
            else:
                arrTime = stop['arrivalTime']
             
            
            niter = list.append()
            list.set(niter, 0, depTime, 1, stop['departureStation'], 2, stop['departurePlatform'], 3, stop['typeTrain'])
            niter = list.append()
            list.set(niter, 0, arrTime, 1, stop['arrivalStation'], 2, stop['arrivalPlatform'], 3, "") 
         
    def on_prev_clicked(self, button, list):
        try:
            result = self.nsclient.fetch_prev()
        except NSClientException, error:
            display_banner(self.window, error)
            return
            
        list.clear()
        self.build_result_list(list, result)

    def build_result_list(self, list, result):
        for stop in result:
            if stop['departureExtraTime'] != 0:
                depTime = "%s +%s" % (stop['departureTime'], stop['departureExtraTime'])
            else:
                depTime = stop['departureTime']
            
            if stop['arrivalExtraTime'] != 0:
                arrTime = "%s +%s" % (stop['arrivalTime'], stop['arrivalExtraTime'])
            else:
                arrTime = stop['arrivalTime']
             
            
            niter = list.append()
            list.set(niter, 0, depTime, 1, stop['departureStation'], 2, stop['departurePlatform'], 3, stop['typeTrain'])
            niter = list.append()
            list.set(niter, 0, arrTime, 1, stop['arrivalStation'], 2, stop['arrivalPlatform'], 3, "") 

    def display_result(self, result):
        parea, list = self.build_right_column(result)
        
        toolbar = gtk.Toolbar()
        toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_GO_BACK,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 "Back")
        toolitem.connect("clicked", self.on_prev_clicked, list)    
        toolbar.insert(toolitem, 0)
   
   
        toolitem = gtk.ToolButton(gtk.image_new_from_stock(gtk.STOCK_GO_FORWARD,
                                 gtk.ICON_SIZE_LARGE_TOOLBAR),
                                 "Forward")
        toolitem.connect("clicked", self.on_next_clicked, list)    
        toolbar.insert(toolitem, 1)
   


       
        win = hildon.StackableWindow()
        win.set_title("Journey")  
        win.add(parea)   
        win.add_toolbar(toolbar)       
        win.show_all()

    def build_right_column(self, result):     
        list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING)
        
        for stop in result:
            if stop['departureExtraTime'] != 0:
                depTime = "%s +%s" % (stop['departureTime'], stop['departureExtraTime'])
            else:
                depTime = stop['departureTime']
            
            if stop['arrivalExtraTime'] != 0:
                arrTime = "%s +%s" % (stop['arrivalTime'], stop['arrivalExtraTime'])
            else:
                arrTime = stop['arrivalTime']
             
            
            niter = list.append()
            list.set(niter, 0, depTime, 1, stop['departureStation'], 2, stop['departurePlatform'], 3, stop['typeTrain'])
            niter = list.append()
            list.set(niter, 0, arrTime, 1, stop['arrivalStation'], 2, stop['arrivalPlatform'], 3, "") 

        #Define the recipe list treeview with multiple selections, search, etc.
        self.checkpoint_tv = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        selection = self.checkpoint_tv.get_selection()
        self.checkpoint_tv.set_model(list)

        parea = hildon.PannableArea()
        parea.add(self.checkpoint_tv)
        # add columns to the tree view
        self.add_columns_to_right_list(self.checkpoint_tv)
        
        return parea, list

    def add_columns_to_right_list(self, treeview):
        model = treeview.get_model()

        # column for ID
        renderer = gtk.CellRendererText()
        renderer.set_property('xalign', 0)
        column = gtk.TreeViewColumn('Time', renderer, text=0)
        column.set_property('max-width', 130)       
        column.set_property('min-width', 130)        
        
        treeview.append_column(column)
        

        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', 0)
        column = gtk.TreeViewColumn('Station', renderer, text=1)
        column.set_property('max-width', 380)       
        column.set_property('min-width', 380)
        treeview.append_column(column)


        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', .5)
        column = gtk.TreeViewColumn('Track', renderer, text=2)
        column.set_property('max-width', 100)       
        column.set_property('min-width', 100)
        treeview.append_column(column)

        # column for title
        renderer = gtk.CellRendererText()        
        renderer.set_property('xalign', .5)
        column = gtk.TreeViewColumn('Details', renderer, text=3)
        column.set_property('max-width', 100)       
        column.set_property('min-width', 100)
        treeview.append_column(column)

        
        # set tree properties
        treeview.set_headers_visible(True)
        treeview.set_fixed_height_mode(False)
#        treeview.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)
          
    def create_menu(self,label):
        menu = hildon.AppMenu()
        
        # about button
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        button.set_label("About")
        button.connect("clicked", self.on_about_button_clicked)
        menu.append(button)

        menu.show_all()
        
        return menu
    
    def on_about_button_clicked(self, widget):
        #FIXME
        about = gtk.AboutDialog()
        about.set_name("NSSchedule")
        about.set_comments("Dutch Train Journey Information")
        about.set_version("0.1")
        about.set_copyright("Giorgos Logiotatidis\nseadog@sealabs.net")
        about.set_website("https://www.sealabs.net/seadog")
        about.set_logo_icon_name("nsschedule")
        about.connect("response", lambda x, y: x.destroy())
        about.show()

if __name__ == "__main__":  
    app = NS() 
    app.run()         
