#ifndef UIPLAYLIST_H
#define UIPLAYLIST_H

#include <QtCore>
#include <QtGui>

class Player;

class UIPlaylist : public QWidget{
        Q_OBJECT
	public:
                // Constructor
                UIPlaylist(Player* parent);
		~UIPlaylist();

                // Return the playlist widget
                QListWidget* getWidget(){return widgetPlaylist;}

                // Return the current selected row
                int currentRow(){return widgetPlaylist->currentRow();}

                // Add a media in the playlist
		void addItem(QString s);
                void encItem(QString s, int row);
		void changeItem(QString s,int row);

                // Set bold/Unbold a row of the playlist
		void setBold(unsigned int row, bool b);

                void setPlaylistH();
                void setPlaylistV();

	public slots:
                void clearPlaylist();
		void playlistDoubleClicked();
		void delItem();
                void moveUp();
                void moveDown();
                void moveAfterCurrent();
                void goToCurrent();
                void plsSearch();

	private:
		QListWidget* widgetPlaylist;
                QPushButton* buttonDel;     //QToolButton* buttonDel;
                QPushButton* buttonMoveUp;
                QPushButton* buttonMoveDown;
                QPushButton* buttonMoveAfterCurrent;
                QPushButton* buttonGoToCurrent;
                    QPushButton* buttonPlsSearch;

                QBoxLayout* layoutControlPL;
                QBoxLayout* layout;

                Player* parent;
};

#endif // UIPLAYLIST_H
