#ifndef UIFOLDER_H
#define UIFOLDER_H

#include <QtGui>

class Player;

class UIFolder : public QWidget{
    Q_OBJECT
    public:
        /* Constructor */
        UIFolder(Player* parent, QString musicPath1, QString musicPath2);
        ~UIFolder();

        void refreshWithNewMusicPath(QString& s1, QString& s2);

        void setFolderH();
        void setFolderV();

    public slots:
        void folderListDoubleClicked(QListWidgetItem* item);
        void slotAddFolder();
        void slotReplFolder();
        void slotEncFolder();
        void slotCD();

private:
        QListWidget* listWidget;
        QBoxLayout* layoutControlF;
        QBoxLayout* layout;
        QPushButton* buttonAdd, *buttonRepl, *buttonEnc, *buttonCD;

        QString musicPath1;
        QString musicPath2;

        QStringList dirContent;
        QStringList dirContent2;

        QStringList filters;

        int refreshDirContent();

        void addFile(QString uri);
        void addFolder(QString uri);
        void encFile(QString uri);
        void encFolder(QString uri);
        QStringList getMediaFilesInDir(QString uri);
        bool fileIsGood(QString uri);

        Player* parent;
};

#endif // UIFOLDER_H
