#include <iostream>
#include <QtGui>
#include "Player.h"

UIFolder::UIFolder(Player* parent, QString mp1, QString mp2)
{
    this->parent = parent;

    listWidget = new QListWidget;
        listWidget->setSpacing(0);
        listWidget->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    QStyle * s = parent->style();
    //buttonAdd = new QPushButton(tr("+"));
    buttonAdd = new QPushButton(s->standardIcon(QStyle::SP_FileDialogNewFolder),"");
    buttonRepl = new QPushButton(s->standardIcon(QStyle::SP_DialogApplyButton),"");
    buttonEnc = new QPushButton(s->standardIcon(QStyle::SP_DialogResetButton),"");
    buttonCD = new QPushButton(s->standardIcon(QStyle::SP_DialogOpenButton),"");

    layout = new QBoxLayout (QBoxLayout::LeftToRight);
        layout->setSpacing(0);
        layout->setMargin(0);

    layoutControlF = new QBoxLayout (QBoxLayout::Down);
        layoutControlF->setSpacing(0);
        layoutControlF->setMargin(0);
    layoutControlF ->addWidget(buttonRepl);
    layoutControlF ->addWidget(buttonEnc);
    layoutControlF ->addWidget(buttonAdd);
    layoutControlF ->addWidget(buttonCD);
        //layoutControlF->addStretch();
        //layoutControlF->setAlignment(Qt::AlignRight|Qt::AlignTop);
        layoutControlF->setAlignment(Qt::AlignTop);

    layout->addWidget(listWidget);
    layout->addLayout(layoutControlF);

    this->musicPath1 = mp1;
    this->musicPath2 = mp2;

    connect(listWidget, SIGNAL(itemDoubleClicked(QListWidgetItem*)),
            SLOT(folderListDoubleClicked(QListWidgetItem*)));

    connect(buttonAdd, SIGNAL(clicked()), SLOT(slotAddFolder()) );
    connect(buttonRepl, SIGNAL(clicked()), SLOT(slotReplFolder()) );
    connect(buttonEnc, SIGNAL(clicked()), SLOT(slotEncFolder()) );
    connect(buttonCD, SIGNAL(clicked()), SLOT(slotCD()) );

    filters << "*.mp3" << "*.wav" << "*.wma" << "*.mpc"     // Audio Filters
            << "*.m4a" << "*.ogg" << "*.aac" << "*.flac";
    //filters << "*.avi" << "*.mpg";                        // Videos Filters
    filters << "..";                                        // System Filters

    refreshDirContent();
    setLayout(layout);
}

UIFolder::~UIFolder()
{
    //qDebug()<<"UIFolder destructor";
    if (buttonAdd)          delete buttonAdd;
    if (buttonRepl)         delete buttonRepl;
    if (buttonEnc)          delete buttonEnc;
    if (buttonCD)           delete buttonCD;
    if (layoutControlF)     delete layoutControlF;
    if (listWidget)         delete listWidget;
    if (layout)             delete layout;
}

int UIFolder::refreshDirContent(){
    listWidget->clear();
    int n=0;

    QDir tmp(musicPath1);
    tmp.setSorting(QDir::DirsFirst | QDir::IgnoreCase);
    if(parent->config->showHidden)
        tmp.setFilter(QDir::AllDirs|QDir::Files|QDir::Hidden);
    else
        tmp.setFilter(QDir::AllDirs | QDir::Files);
    tmp.setNameFilters(filters);
    dirContent = tmp.entryList();

    QListWidgetItem* item = NULL;
    QStyle * style = parent->style();
    QStyle::StandardPixmap icon;
    QFileInfo fi;

    for (int i=0; i < dirContent.count(); i++){
        fi.setFile(musicPath1+"/"+dirContent[i]);
        if (fi.fileName()==".") continue;
        QSize sz(800, 30);
        if (fi.isDir()){
            if(fi.fileName()==".."){
                icon = QStyle::SP_FileDialogToParent;
                sz.rheight() += 20;
            }else{
                icon = QStyle::SP_DirIcon;
            }
        }else{
            icon = QStyle::SP_FileIcon;
        }
        item = new QListWidgetItem(style->standardIcon(icon),dirContent[i]);
        item->setSizeHint(sz);
        item->setData(Qt::UserRole, musicPath1);
        if (item){
            listWidget->addItem(item);
            n++;
        }
    }
    return n;
}


void UIFolder::folderListDoubleClicked(QListWidgetItem* item){
//qDebug()<<item->data(Qt::UserRole).toString();
    QString s = musicPath1 + "/" + item->text();
    QFileInfo fi;

    fi.setFile(s);

    if (fi.isDir()) { // directory
        QString oldPath = musicPath1;
        musicPath1 += "/" + item->text();
        musicPath1 = QDir::cleanPath(musicPath1);
        if (!refreshDirContent()) //bad permission to this dir
        { //back
            musicPath1 = oldPath;
            musicPath1 = QDir::cleanPath(musicPath1);
            refreshDirContent();
        }
    }else{
        addFile(s);
    }
}

void UIFolder::slotAddFolder(){
    // add the content of the dir
    if ((listWidget->currentItem()->text() != "..")
            &&(listWidget->currentItem()->text() != ".")){
        QString uri = musicPath1 + "/" + listWidget->currentItem()->text();
        QFileInfo fi;
        fi.setFile(uri);
        if (fi.isDir()){addFolder(uri);}
        else {addFile(uri);}
    }
}

void UIFolder::slotReplFolder(){
    if (listWidget->currentItem()->text() != ".."){
        parent->ui->clearPlaylist();
        slotAddFolder();
        parent->play(0);
    }
}

void UIFolder::slotEncFolder(){
    if ((listWidget->currentItem()->text() != "..")
            &&(listWidget->currentItem()->text() != ".")){
        QString uri = musicPath1 + "/" + listWidget->currentItem()->text();
        QFileInfo fi;
        fi.setFile(uri);
        if (fi.isDir()) {encFolder(uri);}
        else {encFile(uri);}
    }
}

void UIFolder::slotCD(){ // Button for moving up/down in directory structure
    if (listWidget->currentItem()){
//        QString s = musicPath1 + "/" + listWidget->currentItem()->text();
        QString itemPath = listWidget->currentItem()->data(Qt::UserRole).toString();
        QString itemName = "/" + listWidget->currentItem()->text();
        QFileInfo fi;
        fi.setFile(itemPath+itemName);
        if (itemName == ".." || fi.isFile()){
            musicPath1 += "/../";
            musicPath1 = QDir::cleanPath(musicPath1);
            refreshDirContent();
        }else if (fi.isDir()){
            musicPath1 += "/" + itemName;
            musicPath1 = QDir::cleanPath(musicPath1);
            refreshDirContent();
        }
    }else if (musicPath1 != parent->config->musicFolder1){
        musicPath1 += "/../";
        musicPath1 = QDir::cleanPath(musicPath1);
        //qDebug()<<musicPath1<<"slot";
        refreshDirContent();
    }
}

void UIFolder::addFile(QString uri){
    if (fileIsGood(uri)){
        QStringList files;
        files.append(uri);
        parent->ui->playlistAdd(files);
    }
}

void UIFolder::addFolder(QString uri){
    QStringList files;
    files=getMediaFilesInDir(uri);
    parent->ui->playlistAdd(files);
}

void UIFolder::encFile(QString uri){
    if (fileIsGood(uri)){
        QStringList files;
        files.append(uri);
        parent->ui->playlistEnc(files);
    }
}

void UIFolder::encFolder(QString uri){
    QStringList files;
    files=getMediaFilesInDir(uri);
    parent->ui->playlistEnc(files);
}

QStringList UIFolder::getMediaFilesInDir(QString uri){
    QDir tmp(uri);
    QString s;
    QFileInfo fi;
    QStringList tmpDirContent = tmp.entryList();
    QStringList mFileList;
    int count = tmpDirContent.count();
//    qDebug()<<tmpDirContent;
//    return mFileList;
    for(int i=0;i<count;i++){
        if((tmpDirContent[i]=="..")||(tmpDirContent[i]=="."))
          continue;
        s = uri + "/" + tmpDirContent[i];
        fi.setFile(s);
        if(fi.isDir()){
          mFileList.append(getMediaFilesInDir(s));
        }else{
            if (fileIsGood(s)){
              mFileList.append(s);
            }
        }
    }
    return mFileList;
}

bool UIFolder::fileIsGood(QString uri){
    int nbFilters = filters.count();
    bool isGood = false;
  
//    qDebug()<<uri;
    QString filter="";
    for (int i = 0; i < nbFilters;i++){
            //qDebug()<<filters[i];
            filter=filters[i];
        if ((uri.endsWith(filter.remove(QRegExp("^[*]")),Qt::CaseInsensitive))
                && (filters[i] != "..")){
            isGood = true;
            break;
        }
    }
    return isGood;
}

void UIFolder::refreshWithNewMusicPath(QString& s1, QString& s2){
    musicPath1 = s1;
    musicPath2 = s2;
    refreshDirContent();
}

void UIFolder::setFolderH(){
    layoutControlF->setDirection(QBoxLayout::Down);
    layout->setDirection(QBoxLayout::LeftToRight);
}

void UIFolder::setFolderV(){
    layoutControlF->setDirection(QBoxLayout::LeftToRight);
    layout->setDirection(QBoxLayout::Down);
}
