#ifndef UI_H
#define UI_H

#include <QtGui>
//#include <Phonon/VolumeSlider>

#include "UIFolder.h"
#include "UIPlaylist.h"
#include "UIControl.h"
#include "SettingsDialog.h"
#include <libosso.h>


class Player;

class UI : public QMainWindow{
        Q_OBJECT
    public:
        UI(Player* parent,QString& musicPath1, QString& musicPath2);
        ~UI();

        void playlistAdd(QStringList ss);
        void playlistEnc(QStringList ss);

        void addItem(QString s);
        void encItem(QString s, int row);

        void changeItem(QString s,int row);

        // Return the current selected row in the playlist
        int playlistCurrentRow(){return playlist->currentRow();}

        // Return how many files in the playlist
        int playlistCount(){return playlist->getWidget()->count();}

        // Change the selected row in the playlist
        void setSelectedRow(unsigned int row){
            playlist->getWidget()->setCurrentRow(row);}

        void setRandom(bool b);

        UIControl& getControls(){return *controls;}

        UIPlaylist& getPlaylist(){return *playlist;}

        void setOrientation(int orientation);

    public slots:

        void toggleList();

        // Controls
        void play();
        void next();
        void prev();
        void stop();

        void settingsDialogOpen();
        void settingsDialogAccepted();
        void orientationChanged();

        void clearPlaylist();
        void savePlaylistDialog();
        void loadPlaylistDialog();

        void showFMTXDialog();
        void randomChanged();

    private:
        void setupActions();
        void setupMenus();
        QWidget *mainW;

        UIPlaylist*     playlist;
        UIFolder*       folder;
        UIControl*      controls;

        QBoxLayout*     mainLayout;
        QBoxLayout*     ctrlLayout_HV;
        QVBoxLayout*    inf_seek;
        QHBoxLayout*    inf_time;
        //QVBoxLayout*    inf_volume;

        QString         workdir;

        QAction         *settingsAction;
        QAction         *loadPlaylist,*savePlaylist;
        QAction         *clearPlaylistAction;
        QAction         *fmtxAction;
        QAction         *randomAction;
        osso_context_t  *osso_context_1;

        QMenu           *settingsMenu;

        SettingsDialog  *settingsdialog;

        Player*          parent;
};

#endif // UI_H
