#include <iostream>
#include <QtGui>

#include "Player.h"
#include "UI.h"

UI::UI(Player* parent, QString& musicPath1, QString& musicPath2)
{
    this->parent = parent;

    setupActions();
    setupMenus();

    workdir=QDesktopServices::storageLocation(QDesktopServices::HomeLocation);

    qsrand(time(NULL));                         // Initialize the random

    controls = new UIControl(parent);           // Controls
    playlist = new UIPlaylist(parent);          // Playlist
    folder = new UIFolder(parent,musicPath1,musicPath2);    // Folder

    // Layouts
    mainLayout = new QBoxLayout (QBoxLayout::LeftToRight);
        mainLayout->setSpacing(0);
        mainLayout->setMargin(0);
    ctrlLayout_HV = new QBoxLayout (QBoxLayout::Down);
        ctrlLayout_HV->setSpacing(0);
        ctrlLayout_HV->setMargin(0);
    // seekbar
    inf_seek=new QVBoxLayout;
        inf_seek->setSpacing(0);
        inf_seek->setMargin(0);
    inf_seek->addLayout(parent->engine->getSeekLayout());
    // volume
        //inf_volume=new QVBoxLayout;
        //inf_volume->addLayout(parent->engine->getVolLayout());
    // time
    inf_time=new QHBoxLayout;
        inf_time->setSpacing(0);
        inf_time->setMargin(0);
    inf_time->addLayout(parent->engine->getTimeLayout());

    ctrlLayout_HV->addWidget(controls);
    ctrlLayout_HV->addLayout(inf_time);
    ctrlLayout_HV->addLayout(inf_seek);
        //ctrlLayout->addLayout(inf_volume);
        //ctrlLayout->addStretch();

    mainLayout->addLayout(ctrlLayout_HV);
    mainLayout->addWidget(playlist);
    mainLayout->addWidget(folder);
    folder->setVisible(false);

    // UI
    mainW = new QWidget();
    mainW->setLayout(mainLayout);
    setCentralWidget(mainW);
    //adjustSize();

    settingsdialog = new SettingsDialog();
    connect(settingsdialog, SIGNAL(accepted()), this, SLOT(settingsDialogAccepted()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    orientationChanged();
    show();
}

UI::~UI(){
    //qDebug()<<"UI destructor";
    if (controls)       delete controls; controls = NULL;
    if (playlist)       delete playlist; playlist = NULL;
    if (folder)         delete folder; folder = NULL;
    if (inf_seek)       delete inf_seek;
        //if (inf_volume)     delete inf_volume;
    if (inf_time)       delete inf_time;
    if (ctrlLayout_HV)  delete ctrlLayout_HV;
    if (mainLayout)     delete mainLayout;
    if (mainW)          delete mainW;
}

void UI::toggleList(){
    if (playlist->isVisible()){
        playlist->setVisible(false);
        folder->setVisible(true);
    }else{
        folder->setVisible(false);
        playlist->setVisible(true);
    }
}

void UI::clearPlaylist(){
    playlist->clearPlaylist();
}

void UI::playlistAdd(QStringList ss){
    parent->engine->addMedia(ss);
}

void UI::playlistEnc(QStringList ss){
    parent->engine->encMedia(ss);
}

void UI::addItem(QString s){
    playlist->addItem(s);
}

void UI::encItem(QString s,int row){
    playlist->encItem(s, row);
}

void UI::changeItem(QString s, int row){
    playlist->changeItem(s,row);
}

void UI::play(){
    parent->play(-1);
}

void UI::stop(){
    parent->stop();
}

void UI::next(){
    parent->next();
}

void UI::prev(){
    parent->prev();
}

void UI::setRandom(bool b){
    randomAction->setChecked(b);
}

void UI::randomChanged(){
    if (!randomAction->isChecked() ){
        parent->config->random = false;
        randomAction->setChecked(false);
    }else{
        parent->config->random = true;
        randomAction->setChecked(true);
    }
}

void UI::setupActions(){
    // Settings Button
    settingsAction = new QAction(tr("Settings"),this);
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(settingsDialogOpen()));
    // Clear Playlist Button
    clearPlaylistAction = new QAction(tr("Clear Playlist"),this);
    connect(clearPlaylistAction, SIGNAL(triggered()), this, SLOT(clearPlaylist()));
    // Load Playlist Button
    loadPlaylist =  new QAction(tr("Open Playlist"),this);
    connect(loadPlaylist, SIGNAL(triggered()), this, SLOT(loadPlaylistDialog()));
    // Save Playlist Button
    savePlaylist =  new QAction(tr("Save Playlist"),this);
    connect(savePlaylist, SIGNAL(triggered()), this, SLOT(savePlaylistDialog()));
    // FMTX Button
    fmtxAction = new QAction(tr("FMTX Settings"),this);
    connect(fmtxAction, SIGNAL(triggered()), this, SLOT(showFMTXDialog()));
    // Random Button (Checkable)
    randomAction = new QAction(tr("Random"), this);
    randomAction->setCheckable(true);
    connect(randomAction, SIGNAL(triggered()),this, SLOT(randomChanged() ) );
}

void UI::setupMenus(){
    settingsMenu = menuBar()->addMenu(tr("Settings"));
    settingsMenu->addAction(settingsAction);
    settingsMenu->addAction(clearPlaylistAction);
    settingsMenu->addAction(loadPlaylist);
    settingsMenu->addAction(savePlaylist);
    settingsMenu->addAction(fmtxAction);
    settingsMenu->addAction(randomAction);
}

void UI::settingsDialogOpen(){
    settingsdialog->setConfig(parent->config);
    settingsdialog->exec();
}

void UI::settingsDialogAccepted(){
    //qDebug()<<"Setting Dialog Accepted";
    int tmpOrientation=parent->config->orientation;
    settingsdialog->getConfig(parent->config);

    folder->refreshWithNewMusicPath(parent->config->musicFolder1,
                                    parent->config->musicFolder2);
    if (tmpOrientation!=parent->config->orientation)
            setOrientation(parent->config->orientation);
}

void UI::loadPlaylistDialog(){
  QString tmpfile;
  tmpfile=QFileDialog::getOpenFileName(this,tr("Open Playlist"),workdir,
                                       tr("Playlist files ( *.m3u *.M3U *.pls *.PLS)"));
    if(!tmpfile.isNull()){
        clearPlaylist();
        parent->engine->setCurrentPlayedMedia(0);
        if(tmpfile.endsWith(".pls",Qt::CaseInsensitive)){
            parent->openPlaylist_pls(tmpfile);
        }else{
            parent->restorePlaylist(tmpfile);
        }
        QFileInfo tmpinfo(tmpfile);
        workdir=tmpinfo.dir().absolutePath();
    }
}

void UI::savePlaylistDialog(){
    QString tmpfile;
    tmpfile=QFileDialog::getSaveFileName(this,tr("Save Playlist"),workdir,
                                    tr("Playlist files ( *.m3u *.M3U)"));
    if((!tmpfile.isNull())&&(!tmpfile.isEmpty())){
        if(!tmpfile.endsWith(".m3u",Qt::CaseInsensitive))
            tmpfile.append(".m3u");

        parent->savePlaylist(tmpfile);
        QFileInfo tmpinfo(tmpfile);
        workdir=tmpinfo.dir().absolutePath();
    }
}

void UI::showFMTXDialog(){
    osso_context_1 = osso_initialize("necrolongplayer", "0.0.1", TRUE, NULL);
    osso_cp_plugin_execute(osso_context_1, "libcpfmtx.so", this, TRUE);
}

void UI::setOrientation(int orientation){
    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case 0://ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);break;
    case 1://ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);break;
    default:
    case 2://ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);break;
#else
    case 0://ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;break;
    case 1://ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;break;
    default:
    case 2://ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;break;
#endif
    };
    setAttribute(attribute, true);
}

void UI::orientationChanged(){
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        //mainLayout->removeItem(ctrlLayout_V);mainLayout->addItem(ctrlLayout_H);
        controls->setControlH();
        parent->engine->setSliderH();
        playlist->setPlaylistH();
        folder->setFolderH();
        ctrlLayout_HV->setDirection(QBoxLayout::Down);
        mainLayout->setDirection(QBoxLayout::LeftToRight);
    }else{
        controls->setControlV();
        parent->engine->setSliderV();
        playlist->setPlaylistV();
        folder->setFolderV();
        ctrlLayout_HV->setDirection(QBoxLayout::LeftToRight);
        mainLayout->setDirection(QBoxLayout::Down);
    }
}
