#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QtCore>
#include <QtGui>
#include "Config.h"

class SettingsDialog : public QDialog{
        Q_OBJECT
    public:
        SettingsDialog();
        ~SettingsDialog();
        void setConfig(Config* inputConfig);
        void getConfig(Config* outputConfig);

    private:
        //QVBoxLayout*        dialogLayout;
        //QVBoxLayout*        configLayout;
        #ifdef Q_WS_MAEMO_5
        QHBoxLayout*        configLayout;
        #else
        QVBoxLayout*        configLayout;
        #endif

        QVBoxLayout*        scrollLayout;
        QWidget*            scrollW;
        QScrollArea*        scrArea;

        QGroupBox*          orientationBox;
        QVBoxLayout*        orientationLayout;
        QHBoxLayout*        orientationButtonLayout;
        QButtonGroup        *orientationGroup;
        QRadioButton*       orientationH;
        QRadioButton*       orientationA;
        QRadioButton*       orientationV;

        QGroupBox*          playlistBox;
        QVBoxLayout*        playlistLayout;
        QCheckBox*          savePositionOnQuit;

        QGroupBox*          directoryBox;
        QVBoxLayout*        directoryLayoutV;
        QHBoxLayout*        directoryLayout1;
        QHBoxLayout*        directoryLayout2;

        QLabel*             labelDirectory1;
        QLabel*             labelDirectory2;
        QLineEdit*          directory1;
        QLineEdit*          directory2;
        QPushButton*        buttonDir1;
        QPushButton*        buttonDir2;

        QCheckBox*          showHiddenFiles;

        QDialogButtonBox*   dialogButtons;

    private slots:
        void browseDir1();
        void browseDir2();
};
#endif
