/*
 * This file is part of Hildon Tutorial Examples
 *
 * Copyright (C) 2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */

#include                                        <hildon/hildon.h>

/* This is a callback function. The data arguments are ignored
 * in this example. More on callbacks . */
static void hello (GtkWidget *widget,
                   gpointer   data)
{
  g_print ("Hello World!\n");
}

int
main                                            (int argc,
                                                 char **argv)
{
  HildonProgram *program;
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *win;
  GtkWidget *label;
  GtkWidget *label2;
  GtkBox *vbox;

   hildon_gtk_init (&argc, &argv);
 
   program = hildon_program_get_instance ();

   window = hildon_window_new ();

  g_set_application_name ("Update-Menu");

  hildon_program_add_window (program, HILDON_WINDOW (window));
    g_signal_connect (G_OBJECT (window), "delete_event",
                    G_CALLBACK (gtk_main_quit), NULL);

  label = gtk_label_new ("Updateprocess is running .\n\n"
                         "Please wait until this window close.");
  label2 = gtk_label_new ("Bugs please report to maemo@3ion.at");

  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_CENTER);

  vbox = GTK_BOX (gtk_vbox_new (FALSE, 20));

  gtk_box_pack_start (vbox, label, TRUE, TRUE, 0);
  gtk_box_pack_start (vbox, label2, TRUE, TRUE, 0);


  gtk_container_add (GTK_CONTAINER (window), GTK_WIDGET (vbox));

  gtk_widget_show_all (GTK_WIDGET (window));

  gtk_main ();

  return 0;
}

