#!/bin/sh
## ----------------------------------------------------------------------
## debian/postinst : postinstallation script for mymenu
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
#set -e

if /usr/bin/test -f /home/user/MyDocs/mymenu.log
then
rm /home/user/MyDocs/mymenu.log
echo 'old log file removed'
fi

touch /home/user/MyDocs/mymenu.log
log=/home/user/MyDocs/mymenu.log
error1='Install error -> please send the log (/home/user/MyDocs/mymenu.log) to maemo@3ion.at'

echo Install on `date` >> $log


if /usr/bin/test -d /opt/menu-update/ 
then
	echo '/opt/menu-update exist' >> $log
else
	echo '/opt/menu-update does not exist' >> $log 
	exit 1 && echo $error1
fi

if /usr/bin/test -d /opt/menu-update/mymenu/
then
	echo '/opt/menu-update/mymenu exist' >> $log
else
	echo '/opt/menu-update/mymenu does not exist' >> $log
	exit 1 && echo $error1
fi

if /usr/bin/test -d /opt/menu-update/mymenu/new/
then
	echo '/opt/menu-update/mymenu/new exist' >> $log
else
	echo '/opt/menu-update/mymenu/new does not exist' >> $log
	exit 1 && echo $error1
fi


# refresh the icon-cache
if [ -f /usr/share/icons/hicolor/.icon-theme.cache ]; then
echo icon cache was locked >> $log
rm /usr/share/icons/hicolor/.icon-theme.cache
gtk-update-icon-cache -f /usr/share/icons/hicolor
echo icon cache updated >> $log
else
gtk-update-icon-cache -f /usr/share/icons/hicolor
echo icon cache updated >> $log
fi

pathto='/opt/menu-update/mymenu'
# copy sudoers entry for update-script
cp $pathto/sudoers.d/* /etc/sudoers.d
/usr/sbin/update-sudoers


# check language and set variable
echo 'check language and set varable' >> $log
echo current Language: $LANG >> $log

case $LANG in
	de_DE) prog='Entwicklung'
		learn='Lernen&Wissen'
		games='Spiele'
		graph='Grafik'
		multi='Multimedia'
		navi='Navigation'
		netw='Netzwerk'
		office='Büro'
		science='Wissenschaft'
		system='System'
		utils='sonstige'
		tool='Tool' ;;
	en_GB) prog='Programming'
		learn='Learn&Science'
		games='Games'
		graph='Graphics'
		multi='Multimedia'
		navi='Navigation'
		netw='Networking'
		office='Office'
		science='Science'
		system='System'
		utils='Other'
		tool='Tools' ;;
	en_US) prog='Programming'
		learn='Education'
		games='Games'
		graph='Graphics'
		multi='Multimedia'
		navi='Navigation'
		netw='Networking'
		office='Office'
		science='Science'
		system='System'
		utils='Other'
		tool='Tools' ;;
	es_MX) prog='Programación'
		learn='Educación'
		games='Juegos'
		graph='Gráficos'
		multi='Multimedia'
		navi='Navegación'
		netw='Redes'
		office='Oficina'
		science='Ciencia'
		system='Sistema'
		utils='Utilitarios'
		tool='Tool' ;;
	nl_NL) prog='Ontwikkeling'
		learn='Educatief'
		games='Spelletjes'
		graph='Grafisch'
		multi='Multimedia'
		navi='Navigatie'
		netw='Netwerk'
		office='Kantoor'
		science='Wetenschap'
		system='Systeem'
		utils='Gereedschappen'
		tool='Tool' ;;
	pt_BR) prog='Desenvolvimento'
		learn='Educação'
		games='Jogos'
		graph='Gráficos'
		multi='Multimídia'
		navi='Navegação'
		netw='Redes'
		office='Escritório'
		science='Ciência'
		system='Sistema'
		utils='Utilitários'
		tool='Tool' ;;
	no_NO) prog='Programming'
		learn='Undervisning'
		games='Spill'
		graph='Grafikk'
		multi='Multimedia'
		navi='Navigasjonen'
		netw='Nettverk'
		office='Kontor'
		science='Vitenskap'
		system='System'
		utils='Verktoy'
		tool='Tool' ;;
	fi_FI) prog='Ohjelmointi'
		learn='Opiskelu'
		games='Pelit'
		graph='Grafiikka'
		multi='Multimedia'
		navi='navigointi'
		netw='viestintä'
		office='Toimisto'
		science='Tiede'
		system='Järjestelmä'
		utils='Apuohjelmat'
		tool='Tool' ;;
	it_IT) prog='Programmazione'
		learn='Educazione'
		games='Giochi'
		graph='Grafica'
		multi='Multimedia'
		navi='Navigazione'
		netw='Internet'
		office='Ufficio'
		science='Scienza'
		system='Sistema'
		utils='Utilità'
		tool='Tool' ;;
	fr_CA) prog='Programmation'
		learn='Éducation'
		games='Jeux'
		graph='Graphismes'
		multi='Multimédia'
		navi='Navigation'
		netw='Internet'	
		office='Bureautique'
		science='Science'
		system='Système'
		utils='Utilitaires'
		tool='Tool' ;;
	da_DK) prog='Programmering'
		learn='Undervisning'
		games='Spil'
		graph='Grafik'
		multi='Multimedier'
		navi='Navigation'
		netw='Internet'
		office='Kontor'
		science='Videnskab'
		system='System'
		utils='Værktøjer'
		tool='Tool' ;;
	pt_PT) prog='Desenvolvimento'
		learn='Educação'
		games='Jogos'
		graph='Gráficos'
		multi='Multimédia'
		navi='Navegação'
		netw='Redes'
		office='Escritório'
		science='Ciência'
		system='Sistema'
		utils='Utilitários'
		tool='Tool' ;;
	sv_SE) prog='Programmering'
		learn='Utbildning'
		games='Spel'	
		graph='Grafik'
		multi='Multimedia'
		navi='Navigation'
		netw='Nätverk'
		office='Kontor'
		science='Vetenskap'
		system='System'
		utils='Verktyg'
		tool='Tool' ;;
	fr_FR) prog='Programmation'
		learn='Éducation'
		games='Jeux'
		graph='Graphismes'
		multi='Multimédia'
		navi='Navigation'
		netw='Réseaux'
		office='Bureautique'
		science='Science'
		system='Système'
		utils='Utilitaires'
		tool='Tool' ;;
	es_ES) prog='Programación'
		learn='Educación'
		games='Juegos'
		graph='Gráficos'
		multi='Multimedia'
		navi='Navegación'
		netw='Redes'
		office='Oficina'
		science='Ciencia'
		system='Sistema'
		utils='Utilidades'
		tool='Tool' ;;
	ru_RU) prog='Программирование'
		learn='Образование'
		games='Игры'
		graph='Графика'
		multi='Мультимедиа'
		navi='навигация'
		netw='Интернет'
		office='Офис'
		science='Наука'
		system='Система'
		utils='Утилиты'
		tool='Tool' ;;
            *)  prog='Programming'
		learn='Education'
		games='Games'
		graph='Graphics'
		multi='Multimedia'
		navi='Navigation'
		netw='Networking'
		office='Office'
		science='Science'
		system='System'
		utils='Other'
		tool='Tools'

esac


audiovideo1=/usr/share/applications/hildon/directory/audiovideo.directory
development1=/usr/share/applications/hildon/directory/development.directory
game1=/usr/share/applications/hildon/directory/game.directory
geo1=/usr/share/applications/hildon/directory/geo.directory
graphics1=/usr/share/applications/hildon/directory/graphics.directory
network1=/usr/share/applications/hildon/directory/network.directory
office1=/usr/share/applications/hildon/directory/office.directory
other1=/usr/share/applications/hildon/directory/other.directory
science1=/usr/share/applications/hildon/directory/science.directory
system1=/usr/share/applications/hildon/directory/system.directory
tools1=/usr/share/applications/hildon/directory/tools.directory
education1=/usr/share/applications/hildon/directory/education.directory

#############################
# create .directory entries #
#############################

#education
echo '[Desktop Entry]
Type=Directory' >> $education1
echo Name=$(echo $learn)  >> $education1
echo 'Icon=mymenu-education
X-Maemo-Category=Learn
X-Text-Domain=maemo-af-desktop' >> $education1



# audiovideo
echo '[Desktop Entry]
Type=Directory' >> $audiovideo1
echo Name=$(echo $multi) >> $audiovideo1
echo 'Icon=mymenu-multimedia
X-Maemo-Category=AudioVideo
X-Text-Domain=maemo-af-desktop' >> $audiovideo1

# development
echo '[Desktop Entry]
Type=Directory' >> $development1
echo Name=$(echo $prog) >> $development1
echo 'Icon=mymenu-development
X-Maemo-Category=Development
X-Text-Domain=maemo-af-desktop' >> $development1




# games
echo '[Desktop Entry]
Type=Directory' >> $game1
echo Name=$(echo $games) >> $game1
echo 'Icon=mymenu-games
X-Maemo-Category=Game
X-Text-Domain=maemo-af-desktop'  >> $game1

# navigation
echo '[Desktop Entry]
Type=Directory' >> $geo1
echo Name=$(echo $navi) >> $geo1
echo 'Icon=mymenu-GPS
X-Maemo-Category=Geo
X-Text-Domain=maemo-af-desktop' >> $geo1

# graphics
echo '[Desktop Entry]
Type=Directory' >> $graphics1
echo Name=$(echo $graph) >> $graphics1
echo 'Icon=mymenu-graphics
X-Maemo-Category=Graphics
X-Text-Domain=maemo-af-desktop' >> $graphics1

# network
echo '[Desktop Entry]
Type=Directory' >> $network1
echo Name=$(echo $netw)  >> $network1
echo 'Icon=mymenu-network
X-Maemo-Category=Network
X-Text-Domain=maemo-af-desktop' >> $network1

# office
echo '[Desktop Entry]
Type=Directory' >> $office1
echo Name=$(echo $office)  >> $office1
echo 'Icon=mymenu-office
X-Maemo-Category=Office
X-Text-Domain=maemo-af-desktop' >> $office1

# other
echo '[Desktop Entry]
Type=Directory' >> $other1
echo Name=$(echo $utils)  >> $other1
echo 'Icon=mymenu-other
X-Maemo-Category=other
X-Text-Domain=maemo-af-desktop' >> $other1

#science
echo '[Desktop Entry]
Type=Directory' >> $science1
echo Name=$(echo $science)  >> $science1
echo 'Icon=mymenu-education
X-Maemo-Category=Learn
X-Text-Domain=maemo-af-desktop' >> $science1

#system
echo '[Desktop Entry]
Type=Directory' >> $system1
echo Name=$(echo $system) >> $system1
echo 'Icon=mymenu-system
X-Maemo-Category=System
X-Text-Domain=maemo-af-desktop' >> $system1

# tools
echo '[Desktop Entry]
Type=Directory' >> $tools1
echo Name=$(echo $tool)  >> $tools1
echo 'Icon=mymenu-tools 
X-Maemo-Category=System
X-Text-Domain=maemo-af-desktop' >> $tools1



# write .directory files to log
echo >> $log
cat $audiovideo1 >> $log
echo >> $log
cat $development1 >> $log
echo >> $log
cat $game1 >> $log
echo >> $log
cat $geo1 >> $log
echo >> $log
cat $graphics1 >> $log
echo >> $log
cat $network1 >> $log
echo >> $log
cat $office1 >> $log
echo >> $log
cat $other1 >> $log
echo >> $log
cat $science1 >> $log
echo >> $log
cat $system1 >> $log
echo >> $log
cat $tools1 >> $log
echo >> $log
cat $education1 >> $log
echo >> $log

#############################
# create .directory entries #
#############################


# pathvariable
menu=/opt/menu-update
menui=/opt/menu-update/mymenu
menun=/opt/menu-update/mymenu/new

cd $menun

# filevariable
if /usr/bin/test -f /opt/menu-update/mymenu/new/hildon.menu 
then
 	rm -r /opt/menu-update/mymenu/new/hildon.menu
 	echo 'exist /opt/menu-update/mymenu/new/hildon.menu - deleted it' >> $log
else
	echo 'hildon.menu doesnt exist under /opt/menu-update/mymenu/new/' >> $log
fi

hildon_menu='/opt/menu-update/mymenu/new/hildon.menu'


touch /opt/menu-update/mymenu/new/hildon.menu

# create hildon.menu

###################################################################################
###          Start check for installed apps                                     ###
###################################################################################

newline='\n'

for i in $(ls /usr/share/applications/hildon | grep .desktop)
do

desktop=`cat  /opt/menu-update/category | grep -i "$i"`

test=`echo $desktop | grep -i "Science+learn"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss="-"
fi
test=`echo $desktop | grep -i "office"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss1="-"
fi
test=`echo $desktop | grep -i "Multimedia"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss2="-"
fi
test=`echo $desktop | grep -i "Programmierung"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss3="-"
fi
test=`echo $desktop | grep -i "Spiele" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss4="-"
fi
test=`echo $desktop | grep -i "Graphics" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss5="-"
fi
test=`echo $desktop | grep -i "Netzwerk" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss6="-"
fi
test=`echo $desktop | grep -i "System" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss7="-"
fi
test=`echo $desktop | grep -i "sonstige" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss8="-"
fi
test=`echo $desktop | grep -i "gps"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss9="-"
fi
test=`echo $desktop | grep -i "tools"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss10="-"
fi

done
###################################################################################
###         Stop check for installed apps                                       ###
###################################################################################


##########################################################################################
#     start creating menu.hildon                                                         #
##########################################################################################

#### Main Menu ####
echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">

<!-- Created & Edited by Manfred Weiß (C) - 2010
     you can freely rewrite & distripute this Script....
     Mail: maemo@3ion.at -->

<Menu>

  <Name>Main</Name>

  <!-- Search the default locations -->
  <AppDir>/usr/share/applications/hildon</AppDir>
  <DirectoryDir>/usr/share/applications/hildon/directory</DirectoryDir>

  <Include>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Include>

  <Layout>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Layout>



' >> $hildon_menu

#### Science & Learn ####
if [ ${#ergebniss} -gt 0 ]; then
echo '
  <Menu>
    <Name>Science+learn</Name>
    <Directory>education.directory</Directory>
    <Include>' >> $hildon_menu
    cat $menu/category | grep -i "Science+learn" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Science+learn
fi

#### Office ####
if [ ${#ergebniss1} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Office</Name>
    <Directory>office.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "office" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no office
fi

#### Multimedia ####
if [ ${#ergebniss2} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Multimedia</Name>
    <Directory>audiovideo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Multimedia" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no multimedia
fi

#### Development ####
if [ ${#ergebniss3} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Programmierung</Name>
    <Directory>development.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Programmierung" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Programmierung
fi

#### Games ####
if [ ${#ergebniss4} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Spiele</Name>
    <Directory>game.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Spiele" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Spiele
fi

#### Graphics ####
if [ ${#ergebniss5} -gt 0 ]; then
echo '   
   <Menu>
    <Name>Graphics</Name>
    <Directory>graphics.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Graphics" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Graphics
fi

#### Network ####
if [ ${#ergebniss6} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Netzwerk</Name>
    <Directory>network.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Netzwerk" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Netzwerk
fi

#### GPS ####
if [ ${#ergebniss9} -gt 0 ]; then
echo '   
  <Menu>
    <Name>GPS</Name>
    <Directory>geo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "gps" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no gps
fi

#### System ####
if [ ${#ergebniss7} -gt 0 ]; then
echo '   
  <Menu>
    <Name>System</Name>
    <Directory>system.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "System" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no System
fi

#### Other ####
if [ ${#ergebniss8} -gt 0 ]; then
echo '   
  <Menu>
    <Name>sonstige</Name>
    <Directory>other.directory</Directory>
    <OnlyUnallocated/>
    <Include>
      <All/>' >> $hildon_menu
cat $menu/category | grep -i "sonstige" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no sonstige
fi

#### Tools ####
if [ ${#ergebniss10} -gt 0 ]; then
echo '   
  <Menu>
    <Name>tools</Name>
    <Directory>tools.directory</Directory>
    <OnlyUnallocated/>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "tools" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no tools
fi
echo '</Menu>' >> $hildon_menu


##########################################################################################
#     stop creating menu.hildon                                                          #
##########################################################################################
echo hildon.menu created  >> $log

if /usr/bin/test -f /opt/menu-update/mymenu/new/hildon.menu 
then
  echo 'hildon.menu exist under /opt/menu-update/mymenu/new/' >> $log
	mymenu=`cat /opt/menu-update/mymenu/new/hildon.menu` 	
	if [ ${#mymenu} -gt 0 ]; then
		/etc/init.d/hildon-desktop stop
		echo stop hildon-desktop >> $log

			if /usr/bin/test -f /etc/xdg/menus/hildon.menu 
			   then 
				echo '/etc/xdg/menus/hildon.menu exist' >> $log
				rm /etc/xdg/menus/hildon.menu
				echo 'rm hildon.menu' >> $log
			   else
				echo '/etc/xdg/menus/hildon.menu does not exist' >> $log
			fi

		echo >> $log
		cat $hildon_menu >> $log
		echo >> $log
		cp $hildon_menu /etc/xdg/menus
	   	echo cp hildon.menu >> $log
	    	sleep 2
	    	echo start hildon-desktop >> $log
	    	/etc/init.d/hildon-desktop start
	    	echo Status of hildon-desktop start: $? >> $log
	else 
		echo 'hildon.menu was 0' >> $log	
	fi
  else
   echo 'hildon.menu does not exist under /opt/menu-update/mymenu/new/' >> $log
   exit 1 && echo $error1
fi


## FINAL TEST
echo FINAL TEST
COUNTER=10
until [  $COUNTER -lt 1 ]; do
check=`ps axf | pgrep hildon-desktop`

if [ "$COUNTER" = 10 ]; then
 echo $check >> 10
  elif [ "$COUNTER" = 1 ]; then
    echo $check >> 1
else
echo 
fi
sleep 1
    let COUNTER-=1
done

if [ "$(cat 10)" = "$(cat 1)"  ]; then
 echo NO ERROR
else
 echo ERROR = RESTORING ORIGINAL SETUP
 if [ "$(uname -r)" = "2.6.28-omap1" ]; then


if test -d /opt/menu-update/ 
then
 rm -r /opt/menu-update
fi

# remove configuration
filename="/etc/xdg/menus/hildon.menu"
if test -f /etc/xdg/menus/hildon.menu
then
 rm $filename
fi 

touch $filename


# Set Menu to orginal strukture.
#DEBHELPER#

echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">

<Menu>

  <Name>Main</Name>

  <!-- Search only in the hildon directory. -->
  <AppDir>/usr/share/applications/hildon</AppDir>
  <DirectoryDir>/usr/share/applications/hildon</DirectoryDir>

  <Include>
    <Filename>browser.desktop</Filename>
    <Filename>mediaplayer.desktop</Filename>
    <Filename>calendar.desktop</Filename>
    <Filename>image-viewer.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>nokia-maps.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>modest.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
    <Filename>worldclock.desktop</Filename>
    <Filename>osso_calculator.desktop</Filename>
    <Filename>ovi.desktop</Filename>
    <Filename>hildon-control-panel.desktop</Filename>
  </Include>

  <Layout>
    <Filename>browser.desktop</Filename>
    <Filename>mediaplayer.desktop</Filename>
    <Filename>calendar.desktop</Filename>
    <Filename>image-viewer.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>nokia-maps.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>modest.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
    <Filename>worldclock.desktop</Filename>
    <Filename>osso_calculator.desktop</Filename>
    <Filename>ovi.desktop</Filename>
    <Filename>hildon-control-panel.desktop</Filename>
    <Menuname>Applications</Menuname>
    <Merge type="all"/>
  </Layout>

  <MergeDir>hildon/</MergeDir>

</Menu> ' >> $filename

if test -f /usr/share/applications/hildon/update.desktop
then
 rm /usr/share/applications/hildon/update.desktop
 echo update.desktop cleaned
else
 echo update.desktop not exist no cleaning
fi

/etc/init.d/hildon-desktop stop
sleep 5
/etc/init.d/hildon-desktop start

exit 1

 else


if test -d /opt/menu-update/ 
then
 rm -r /opt/menu-update
fi

# remove configuration
filename="/etc/xdg/menus/hildon.menu"
if test -f /etc/xdg/menus/hildon.menu
then
 rm $filename
fi 

touch $filename


# Set Menu to orginal strukture.
#DEBHELPER#

echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">
 
 <Menu>
 
   <Name>Main</Name>
   
     <!-- Search the default locations -->
      <AppDir>/usr/share/applications/hildon</AppDir>
      <DirectoryDir>/usr/share/applications/hildon</DirectoryDir>
         
      <Include>
        <Filename>browser.desktop</Filename>
        <Filename>mediaplayer.desktop</Filename>
        <Filename>calendar.desktop</Filename>
        <Filename>image-viewer.desktop</Filename>
        <Filename>osso-addressbook.desktop</Filename>
        <Filename>rtcom-call-ui.desktop</Filename>
        <Filename>nokia-maps.desktop</Filename>
        <Filename>camera-ui.desktop</Filename>
        <Filename>modest.desktop</Filename>
        <Filename>rtcom-messaging-ui.desktop</Filename>
        <Filename>worldclock.desktop</Filename>
        <Filename>osso_calculator.desktop</Filename>
        <Filename>ovi.desktop</Filename>
        <Filename>hildon-control-panel.desktop</Filename>
      </Include>
                                          
      <Menu>
        <Name>Applications</Name>
        <Directory>applications.directory</Directory>
        <OnlyUnallocated/>
   <Include>
     <All/>
     </Include>
   </Menu>
   </Menu> ' >> $filename

if test -f /usr/share/applications/hildon/update.desktop
then
 rm /usr/share/applications/hildon/update.desktop
 echo update.desktop cleaned
else
 echo update.desktop not exist no cleaning
fi

/etc/init.d/hildon-desktop stop
sleep 5
/etc/init.d/hildon-desktop start
exit 1
 fi
fi



exit 0
