#ifndef SETTINGS_H
#define SETTINGS_H

#include <QtCore>
#include "globals.h"

class Settings
{
public: //TODO: change to private

    QSettings qSettings;
    City currentCity;
    bool showHadith;
    bool showOnAthan;

public:

    Settings(): showHadith(false), showOnAthan(false)
    {
        showHadith = qSettings.value("mainwindow/showHadith").toBool();
        showOnAthan = qSettings.value("mainwindow/showOnAthan").toBool();

        if(qSettings.value("location/name").toString() == "")  //If no city set in config file, use default (Mecca).
        {
            return;
        }
        else
        {
            //Set city
            setCity(
            qSettings.value("location/name").toString(),
            qSettings.value("location/latitude").toDouble(),
            qSettings.value("location/longitude").toDouble(),
            qSettings.value("location/gmtDiff").toDouble(),
            qSettings.value("location/dst").toInt(),
            qSettings.value("method/mathhab").toInt(),
            qSettings.value("method/calcMethod").toInt()
            );
        }
    }
    ~Settings()
    {
        qSettings.setValue("mainwindow/showHadith", showHadith);
        qSettings.setValue("mainwindow/showOnAthan", showOnAthan);

        qSettings.setValue("location/name", currentCity.name);
        qSettings.setValue("location/latitude", currentCity.location.degreeLat);
        qSettings.setValue("location/longitude", currentCity.location.degreeLong);
        qSettings.setValue("location/gmtDiff", currentCity.location.gmtDiff);
        qSettings.setValue("location/dst", currentCity.location.dst);

        qSettings.setValue("method/mathhab", currentCity.method.mathhab);
        qSettings.setValue("method/calcMethod", currentCity.calcMethod);

        qSettings.sync();
    }

    void setCity(QString name, double latitude, double longitude, double gmtDiff, int dst, int mathhab, int calcMethod)
    {
        //Location
        currentCity.name = name;
        currentCity.location.degreeLat = latitude;
        currentCity.location.degreeLong = longitude;
        currentCity.location.gmtDiff = gmtDiff;
        currentCity.location.dst = dst;
        currentCity.method.mathhab = mathhab;
        currentCity.calcMethod = calcMethod;

        //... defaults
        currentCity.location.pressure = 1010;
        currentCity.location.seaLevel = 0;
        currentCity.location.temperature = 10;
        currentCity.method.round = 2;   //Better rounding for imsaak

        getMethod(currentCity.calcMethod, &currentCity.method);
    }
    City getCity()
    {
        return currentCity;
    }

    QRect getScreenGeo()
    {
        return qSettings.value("mainwindow/geometry").toRect();
    }

    void setScreenGeo(QRect geo)
    {
        qSettings.setValue("mainwindow/geometry", geo);
    }


};

#endif // SETTINGS_H
