#ifndef MUNADIENGINE_H
#define MUNADIENGINE_H

//#define TESTING //Just for testing

#include <QtGui>
#include <QtCore>
#include <QtNetwork>
#include "libitl/prayer.h"
#include "settings.h"
#include <QStringList>

#ifdef SFML

#include <SFML/Audio.hpp>

#else

#include <QMediaPlayer>

#endif

#define dout qDebug()

class MunadiEngine : public QObject
{
    Q_OBJECT

public:

    MunadiEngine(QObject * parent = 0);
    virtual ~MunadiEngine();

    enum PrayerType{Fajr, Sunrise, Duhr, Asr, Magrib, Isha};

    QTime getFajr();
    QTime getDuhr();
    QTime getAsr();
    QTime getMagrib();
    QTime getIsha();
    QTime getTest();
    QTime getSunrise();
    QString getTimeDifference();
    QTime getNextPrayer();
    QString getNextPrayerLabel();
    QString getCurrPrayerLabel();
    void initHadithList();
    QString getRandomHadith();
    QString getNextHadith();
    QString getPrevHadith();
    bool isAthanPlaying();

    Settings * settings;
    QTime testTime;

#ifdef SFML
    sf::Music * athanObject;
#else
    QMediaPlayer * athanObject;
#endif

private:

    QTimer * timer;
    QStringList * hadithList;
    int currentHadithIndex;
    int hadithCount;
    QString nextPrayerLabel;
    QString currentPrayerLabel;

public slots:
    void playAthan();
    void stopAthan();
    void checkAthan();
    void calculatePrayer();

signals:
    void athanTriggered();
    void stateChanged();

};

#endif // MUNADIENGINE_H
