#include <QtGui/QApplication>
#include <QFont>
#include <string.h>
#include "alarmHandler.h"
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#include "mainwindow.h"
#include "azanwindow.h"
#include <qmessagebox.h>
#include "dbusCommands.h"

int main(int argc, char *argv[])
{

    QApplication a(argc, argv);
    AzanWindow azanWindow;
    DbusCommands *dbusCommands=new DbusCommands(&azanWindow);
    MainWindow w;
    if(argc > 2 && strncmp(argv[1],"nogui",5) == 0){
        w.printTimes(argv[2]);
    } else if(argc>1){
        if(!strcmp( argv[1],"setupAlarm")){
          AlarmHandler::setupAzan();
          return 0;
        }
        else if(!strcmp( argv[1],"restoreProfile")){
          dbusCommands->setProfile("general");
          return 0;
        }
       else if(QString(argv[1]).startsWith("Azan"))
       {
           dbusCommands->unlockScreenAndKeys();
           azanWindow.setAzan(argv[1]);
           azanWindow.show();

           QObject::connect(&a,SIGNAL(lastWindowClosed()),dbusCommands,SLOT(stopVibration()));
           if(QString(argv[1]).contains(QString("ikama")) && !dbusCommands->getCurrentProfile().contains("silent")){
                QObject::connect(&a,SIGNAL(lastWindowClosed()),dbusCommands,SLOT(setProfileSilent()));
            }
        }
   } else{
       w.show();
   }
    return a.exec();
}
