#ifndef PRAYERTIMESETTINGS_H
#define PRAYERTIMESETTINGS_H

#include <QString>
#include <QSettings>


class PrayerTimeSettings
{
public:
    PrayerTimeSettings();
    double getLatitude();
    double getLongitude();
    double getTimeZone();
    int getCalcMethod();
    int getJuristicMethod();
    int getLatMethod();
    int getTimeFormat();

    //Azan properties
    bool getFagrEnabled();
    bool getZuhrEnabled();
    bool getAsrEnabled();
    bool getMagribEnabled();
    bool getIshaEnabled();
    int getFagrAMargin();
    int getZuhrAMargin();
    int getAsrAMargin();
    int getMagribAMargin();
    int getIshaAMargin();
    int getFagrIMargin();
    int getZuhrIMargin();
    int getAsrIMargin();
    int getMagribIMargin();
    int getIshaIMargin();
    int getFagrSPeriod();
    int getZuhrSPeriod();
    int getAsrSPeriod();
    int getMagribSPeriod();
    int getIshaSPeriod();
    //end azan properties
    bool setupCompleted();
    void update(QString lat, QString longitude, QString timeZone, int calcMethod, int jMethod, int latMethod, int timeFormat);
    void updateAzanSettings(
            //individual azans
            bool fagrEnabled,bool zuhrEnabled,bool asrEnabled,bool magribEnabled,bool ishaEnabled,
            //azan margin (can be +ve or -ve)
           int fagrAMargin,int zuhrAMargin,int asrAMargin,int magribAMargin,int ishaAMargin,
            //ikama margin (can be +ve or -ve)
            int fagrIMargin,int zuhrIMargin,int asrIMargin,int magribIMargin,int ishaIMargin,
            //Silent periods
            int fagrSPeriod,int zuhrSPeriod,int asrSPeriod,int magribSPeriod,int ishaSPeriod);

private:
    double lat;
    double longitude;
    double timeZone;
    int calcMethod;
    int juristicMethod;
    int latMethod;
    int timeFormat;

};


#endif // PRAYERTIMESETTINGS_H
