#include "prayertimesettings.h"
#include "alarmHandler.h"
#include <QCoreApplication>

QSettings settings("Team Mohannad", "mPrayerTime");

PrayerTimeSettings::PrayerTimeSettings()
{

}

double PrayerTimeSettings::getLatitude(){
    return settings.value("latitude").toDouble();
}

double PrayerTimeSettings::getLongitude(){
    return settings.value("longitude").toDouble();
}

double PrayerTimeSettings::getTimeZone(){
    return settings.value("timeZone").toDouble();
}

int PrayerTimeSettings::getTimeFormat(){
    return settings.value("timeFormat").toInt();
}

int PrayerTimeSettings::getCalcMethod(){
    return settings.value("calcMethod").toInt();
}

int PrayerTimeSettings::getJuristicMethod(){
    return settings.value("jMethod").toInt();
}

int PrayerTimeSettings::getLatMethod(){
    return settings.value("latMethod").toInt();
}

bool  PrayerTimeSettings::getFagrEnabled(){
    return settings.value("fagrEnabled").toBool();
}

bool  PrayerTimeSettings::getZuhrEnabled(){
    return settings.value("zuhrEnabled").toBool();
}

bool  PrayerTimeSettings::getAsrEnabled(){
    return settings.value("asrEnabled").toBool();
}

bool  PrayerTimeSettings::getMagribEnabled(){
    return settings.value("magribEnabled").toBool();
}

bool  PrayerTimeSettings::getIshaEnabled(){
    return settings.value("ishaEnabled").toBool();
}

int  PrayerTimeSettings::getFagrAMargin(){
    return settings.value("farAMargin").toInt();
}

int  PrayerTimeSettings::getZuhrAMargin(){
    return settings.value("zuhrAMargin").toInt();
}

int  PrayerTimeSettings::getAsrAMargin(){
    return settings.value("asrAMargin").toInt();
}

int  PrayerTimeSettings::getMagribAMargin(){
    return settings.value("magribAMargin").toInt();
}

int  PrayerTimeSettings::getIshaAMargin(){
    return settings.value("ishaAMargin").toInt();
}

int  PrayerTimeSettings::getFagrIMargin(){
    return settings.value("fagrIMargin").toInt();
}

int  PrayerTimeSettings::getZuhrIMargin(){
    return settings.value("zuhrIMargin").toInt();
}

int  PrayerTimeSettings::getAsrIMargin(){
    return settings.value("asrIMargin").toInt();
}

int  PrayerTimeSettings::getMagribIMargin(){
    return settings.value("magribIMargin").toInt();
}

int  PrayerTimeSettings::getIshaIMargin(){
    return settings.value("ishaIMargin").toInt();
}
int  PrayerTimeSettings::getFagrSPeriod(){
    return settings.value("fagrSPeriod").toInt();
}

int  PrayerTimeSettings::getZuhrSPeriod(){
    return settings.value("zuhrSPeriod").toInt();
}

int  PrayerTimeSettings::getAsrSPeriod(){
    return settings.value("asrSPeriod").toInt();
}

int  PrayerTimeSettings::getMagribSPeriod(){
    return settings.value("magribSPeriod").toInt();
}

int  PrayerTimeSettings::getIshaSPeriod(){
    return settings.value("ishaSPeriod").toInt();
}
//end azan properties
void PrayerTimeSettings::update(QString lat, QString longitude, QString timeZone, int calcMethod, int jMethod, int latMethod, int timeFormat){
    settings.setValue("latitude", lat);
    settings.setValue("longitude", longitude);
    settings.setValue("timeZone", timeZone);
    settings.setValue("calcMethod", calcMethod);
    settings.setValue("jMethod", jMethod);
    settings.setValue("latMethod", latMethod);
    settings.setValue("timeFormat", timeFormat);
}

void PrayerTimeSettings::updateAzanSettings(bool fagrEnabled, bool zuhrEnabled, bool asrEnabled, bool magribEnabled, bool ishaEnabled,
                                            int fagrAMargin, int zuhrAMargin, int asrAMargin, int magribAMargin, int ishaAMargin,
                                            int fagrIMargin, int zuhrIMargin, int asrIMargin, int magribIMargin, int ishaIMargin,
                                            int fagrSPeriod, int zuhrSPeriod, int asrSPeriod, int magribSPeriod, int ishaSPeriod){
    settings.setValue("fagrEnabled", fagrEnabled);
    settings.setValue("zuhrEnabled",zuhrEnabled );
    settings.setValue("asrEnabled",asrEnabled );
    settings.setValue("magribEnabled",magribEnabled );
    settings.setValue("ishaEnabled", ishaEnabled);
    settings.setValue("fagrAMargin",fagrAMargin );
    settings.setValue("zuhrAMargin", zuhrAMargin);
    settings.setValue("asrAMargin", asrAMargin);
    settings.setValue("magribAMargin", magribAMargin);
    settings.setValue("ishaAMargin", ishaAMargin);
    settings.setValue("fagrIMargin",fagrIMargin );
    settings.setValue("zuhrIMargin", zuhrIMargin);
    settings.setValue("asrIMargin", asrIMargin);
    settings.setValue("magribIMargin",magribIMargin );
    settings.setValue("ishaIMargin", ishaIMargin);
    settings.setValue("fagrSPeriod",fagrSPeriod );
    settings.setValue("zuhrSPeriod", zuhrSPeriod);
    settings.setValue("asrSPeriod", asrSPeriod);
    settings.setValue("magribSPeriod",magribSPeriod );
    settings.setValue("ishaSPeriod", ishaSPeriod);
    AlarmHandler::setupAzan();
}

bool PrayerTimeSettings::setupCompleted(){

    double longitude = getLongitude();
    double latitude = getLatitude();
    if (longitude == 0.0 && latitude == 0.0){
        return false;
    }
    return true;

}


