#include "optionsdialog.h"
#include "ui_optionsdialog.h"

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog)
{
    ui->setupUi(this);
    if (settings.setupCompleted()){
        QString s;
        this->ui->latLineEdit->setText(s.setNum(settings.getLatitude(),'f',6));
        this->ui->longLineEdit->setText(s.setNum(settings.getLongitude(),'f',6));
        this->ui->tzLineEdit->setText(s.setNum(settings.getTimeZone(),'f',2));
        this->ui->timeFormatBox->setCurrentIndex(settings.getTimeFormat());
        this->ui->calcMethoBox->setCurrentIndex(settings.getCalcMethod());
        this->ui->jMethodBox->setCurrentIndex(settings.getJuristicMethod());
        this->ui->latMethodBox->setCurrentIndex(settings.getLatMethod());
        this->ui->chkAsr->setChecked(settings.getAsrEnabled());
        this->ui->chkFagr->setChecked(settings.getFagrEnabled());
        this->ui->chkIsha->setChecked(settings.getIshaEnabled());
        this->ui->chkMagrib->setChecked(settings.getMagribEnabled());
        this->ui->chkZuhr->setChecked(settings.getZuhrEnabled());
        this->ui->spinFagrA->setValue(settings.getFagrAMargin());
        this->ui->spinZuhrA->setValue(settings.getZuhrAMargin());
        this->ui->spinAsrA->setValue(settings.getAsrAMargin());
        this->ui->spinMagribA->setValue(settings.getMagribAMargin());
        this->ui->spinIshaaA->setValue(settings.getIshaAMargin());
        this->ui->spinFagrI->setValue(settings.getFagrIMargin());
        this->ui->spinZuhrI->setValue(settings.getZuhrIMargin());
        this->ui->spinAsrI->setValue(settings.getAsrIMargin());
        this->ui->spinMagribI->setValue(settings.getMagribIMargin());
        this->ui->spinIshaaI->setValue(settings.getIshaIMargin());
        this->ui->spinFagrS->setValue(settings.getFagrSPeriod());
        this->ui->spinZuhrS->setValue(settings.getZuhrSPeriod());
        this->ui->spinAsrS->setValue(settings.getAsrSPeriod());
        this->ui->spinMagribS->setValue(settings.getMagribSPeriod());
        this->ui->spinIshaaS->setValue(settings.getIshaSPeriod());
    }
}

void OptionsDialog::positionUpdated(const QGeoPositionInfo &info)
{
    float lng = info.coordinate().longitude();
    float lat = info.coordinate().latitude();
    QString s;
    this->ui->latLineEdit->setText(s.setNum(lat,'f',6));
    this->ui->longLineEdit->setText(s.setNum(lng,'f',6));
    QDateTime dt;
    QDateTime utc;
    dt = QDateTime::currentDateTime();
    utc = dt.toUTC();
    float timezone;
    int hourdiff = dt.time().hour() - utc.time().hour();
    int daydiff = dt.date().dayOfYear() - utc.date().dayOfYear();
    int yeardiff = dt.date().year() - dt.date().year();
    if (daydiff == 0 && yeardiff == 0){
        timezone = hourdiff;
    } else if (daydiff > 0 || yeardiff > 0){
        timezone = hourdiff + 24;
    } else {
        timezone = hourdiff - 24;
    }
    this->ui->tzLineEdit->setText(s.setNum(timezone,'f',2));
    qDebug("local: %i, utc: %i, diff: %f",dt.time().hour(), utc.time().hour(),timezone);
    qDebug("lat: %f, long: %f", lat, lng);
    QMaemo5InformationBox::information(this, "<font color='black'>Position updated.</font>",QMaemo5InformationBox::DefaultTimeout);
    ui->autoConfigButton->setEnabled(true);
    ui->autoConfigButton->setText("Auto Configure");
    source->stopUpdates();
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void OptionsDialog::saveClickedHandler(){
    settings.update(ui->latLineEdit->text(), ui->longLineEdit->text(),ui->tzLineEdit->text(),ui->calcMethoBox->currentIndex(),
                    ui->jMethodBox->currentIndex(), ui->latMethodBox->currentIndex(),ui->timeFormatBox->currentIndex());
    settings.updateAzanSettings(
        //individual azans
        ui->chkFagr->isChecked(),ui->chkZuhr->isChecked(),ui->chkAsr->isChecked(),ui->chkMagrib->isChecked(),ui->chkIsha->isChecked(),
        //azan margin (can be +ve or -ve)
        ui->spinFagrA->value(),ui->spinZuhrA->value(),ui->spinAsrA->value(),ui->spinMagribA->value(),ui->spinIshaaA->value(),
        //ikama margin (can be +ve or -ve)
        ui->spinFagrI->value(),ui->spinZuhrI->value(),ui->spinAsrI->value(),ui->spinMagribI->value(),ui->spinIshaaI->value(),
        //silent period
        ui->spinFagrS->value(),ui->spinZuhrS->value(),ui->spinAsrS->value(),ui->spinMagribS->value(),ui->spinIshaaS->value());


    this->accept();
}

void OptionsDialog::autoConfigureClickHandler(){
    ui->autoConfigButton->setText("Please wait");
    ui->autoConfigButton->setEnabled(false);
    qDebug("Auto Configure....");
    source = QGeoPositionInfoSource::createDefaultSource(this);
    if (source) {
        QMaemo5InformationBox::information(this, "<font color='black'>Retrieving current position and timezone...</font>",5000);
        qDebug("Retrieving position.");
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),
        this, SLOT(positionUpdated(QGeoPositionInfo)));
        source->startUpdates();
    }
}
void OptionsDialog::save(){


}

QString OptionsDialog::doubleToString(double in){
    QString s;
    s.setNum(in, 'g', 6);
    return s;
}

QString OptionsDialog::intToString(int in){
    QString s;
    s.setNum(in, 10);
    return s;
}
