#include "dbusCommands.h"
#include <QMessageBox>


DbusCommands::DbusCommands(QObject* parent)
{
    commandParent=parent;
}

QDBusInterface*  DbusCommands::getMCEDbusInterface(){
   return new QDBusInterface(QString(MCE_SERVICE), QString(MCE_REQUEST_PATH),
                             QString(MCE_REQUEST_IF), QDBusConnection::systemBus(),
                              commandParent);
}
QDBusInterface*  DbusCommands::getProfiledDbusInterface(){
   return new QDBusInterface(QString("com.nokia.profiled"), QString("/com/nokia/profiled"),
                             QString("com.nokia.profiled"));
}
QDBusInterface*  DbusCommands::getNotificationDbusInterface(){
   return new QDBusInterface(QString("org.freedesktop.Notifications"), QString("/org/freedesktop/Notifications"),
                             QString("org.freedesktop.Notifications"));
}
void DbusCommands::enableVibration(){
    getMCEDbusInterface()->call(MCE_ENABLE_VIBRATOR);
}

void DbusCommands::vibrate(){
    #ifdef Q_WS_MAEMO_5
       getMCEDbusInterface()->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
       //vibrate for 10 seconds
       QTimer::singleShot(10000,this,SLOT (stopVibration()));
    #endif

}
void DbusCommands::stopVibration(){
  #ifdef Q_WS_MAEMO_5
    getMCEDbusInterface()->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
  #endif
}

void DbusCommands::unlockScreenAndKeys(){
  #ifdef Q_WS_MAEMO_5
    getMCEDbusInterface()->call(MCE_TKLOCK_MODE_CHANGE_REQ,"unlocked");
  #endif
}
void DbusCommands::setProfile(QString profileString){
    #ifdef Q_WS_MAEMO_5

      getProfiledDbusInterface()->call("set_profile",profileString);
      showNotification(QString("profile set to ")+profileString);
    #endif
}
QString DbusCommands::getCurrentProfile(){
    #ifdef Q_WS_MAEMO_5

      QString result= getProfiledDbusInterface()->call("get_profile").arguments().at(0).toString();
    //  showNotification(QString("profile is ")+result);
      return result;
    #endif
}
void DbusCommands::setProfileSilent(){
    setProfile(QString("silent"));

}
void DbusCommands::showNotification(QString notifyString){
    #ifdef Q_WS_MAEMO_5
      getNotificationDbusInterface()->call("SystemNoteInfoprint",notifyString  );
    #endif
}
