// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CONNECT_H
#define CONNECT_H

#include <QObject>

namespace xQt {

    enum ExtendedConnectionType {
        AutoConnection = Qt::AutoConnection,
        DirectConnection = Qt::DirectConnection,
        QueuedConnection = Qt::QueuedConnection,
        BlockingQueuedConnection = Qt::BlockingQueuedConnection,
        UniqueConnection = Qt::UniqueConnection,
        AutoBlockingConnection = 40,
    };

    inline void connect(QObject *sender, const char *signal, QObject *receiver, const char *method, ExtendedConnectionType type)
    {
        switch (type) {
            // TODO support UniqueConnection flag
        case AutoBlockingConnection:
            QObject::connect(sender, signal, receiver, method,
                             (sender->thread() == receiver->thread()) ? Qt::DirectConnection : Qt::BlockingQueuedConnection);
            break;
        default:
            QObject::connect(sender, signal, receiver, method, (Qt::ConnectionType) type);
            break;
        }
    }
}

#endif // CONNECT_H
