// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "calendar.h"

#ifdef MAEMO_SDK
#include <CCalendar.h>
#include <CMulticalendar.h>
#include <CEvent.h>
#include <CalendarErrors.h>

Calendar::Calendar(QObject *parent)
        : QObject(parent),
        _multi_calendar(0)
{
    _multi_calendar = CMulticalendar::MCInstance();
}

Calendar::~Calendar()
{
    delete _multi_calendar;
}

bool Calendar::AddEvent(const QString &event_name, const QDateTime &start_time,
                        const QDateTime &end_time, const QString &location, const QString &description)
{
    int error_code = 0;

    CCalendar *calendar = _multi_calendar->getDefaultCalendar();
    if (calendar == 0) {
        return false;
    }
    CEvent *event = new CEvent(event_name.toStdString(), description.toStdString(),
                               location.toStdString(), start_time.toTime_t(), end_time.toTime_t());
    event->setAlarmBefore(3600);
    if (!calendar->addEvent(event, error_code)) {
        return false;
    }
    delete event;
    if (error_code != CALENDAR_ENTRY_DUPLICATED && error_code != CALENDAR_OPERATION_SUCCESSFUL) {
        return false;
    }
    return true;
}
#endif
